/*
 * $Id: TestMessageListener.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi.networking;

import com.navtools.util.UnaryFunction;
import org.apache.log4j.Category;

public class TestMessageListener implements MessageListener
{
	public static final Category LOG =
	Category.getInstance( TestMessageListener.class.getName() );

	public void registerTestMessageHandler( UnaryFunction handler )
	{
		handler_ = handler;
	}

	/**
	 * Call the com.navtools.networking.armi.networking.test message handler
	 * @param msg the message to process
	 * @return false
	 */
	public boolean processMessage( Message msg )
	{
		if ( !( msg instanceof TestMessage ) )
		{
			return false;
		}

		if ( handler_ != null )
		{
			handler_.execute( msg );
		}

		return false;
	}

	protected TestMessageListener()
	{
	}

	public static TestMessageListener instance()
	{
		if ( instance_ == null )
		{
			instance_ = new TestMessageListener();
		}

		return instance_;
	}

	UnaryFunction handler_;

	protected static TestMessageListener instance_;
}
