package com.navtools.armi.networking;

import java.io.IOException;
import java.net.*;
import java.util.Set;

import com.navtools.thread.Job;
import com.navtools.thread.TaskMaster;
import org.apache.log4j.Category;
import java.nio.channels.SelectionKey;

public class UDPMessenger extends DatagramSocket
implements UDPMessengerInterface
{
    public static final Category LOG =
    Category.getInstance( UDPMessenger.class.getName() );

    protected UDPMessenger() throws SocketException, UnknownHostException
    {
        super();
        messengerID_.setAddress( InetAddress.getLocalHost() );
        isUsingFirstAvailablePort_ = true;
    }

    protected UDPMessenger( int port )
    throws SocketException, UnknownHostException
    {
        super( port );
        messengerID_.setAddress( InetAddress.getLocalHost() );
    }

    public static UDPMessenger establishInstance( int port )
    throws SocketException, UnknownHostException
    {
        //if establishInstance has already been called
        if ( instance_ != null )
        {
            //if the existing instance has a different port, throw an error
            //otherwise, just use the existing instance
            if ( instance_.getLocalPort() != port )
            {
                throw new Error( "UDPMessenger instance already established" );
            }
            else
            {
                return instance_;
            }
        }

        return instance_ = new UDPMessenger( port );
    }

    public static UDPMessenger establishInstance()
    throws SocketException, UnknownHostException
    {
        //if establishInstance has already been called
        if ( instance_ != null )
        {
            //if the existing instance is not also just using the first
            //available port, throw an error.
            //otherwise, just use the existing instance
            if ( instance_.isServer() )
            {
                throw new Error( "UDPMessenger instance already established" );
            }
            else
            {
                return instance_;
            }
        }

        return instance_ = new UDPMessenger();
    }

    public static UDPMessenger instance()
    {
        if ( instance_ == null )
        {
            try
            {
                establishInstance();
            }
            catch ( Exception e )
            {
                LOG.error( e.getMessage(), e );
            }
        }

        return instance_;
    }

    /**
     * This method is only here to work around a bug in InetAddress that
     * causes it to retrieve 127.0.0.1 for the local IP in some circumastances.
     * Set the local IP to the correct IP for remote access here.
     */
    public void setLocalAddress( InetAddress localAddress )
    {
        messengerID_.setAddress( localAddress );
    }

    public InetAddress getLocalAddress()
    {
        return messengerID_.getAddress();
    }

    public void send( Packet p )
    {
        final Packet pclone = (Packet) p.clone();
        //do all networking on another thread.  The taskMaster_ has only one
        //thread, so all jobs put into him are automatically serialized.
        //(Not necessarily in the order in which you think you put them in,
        //since multiple threads may add jobs, but no two jobs will ever
        //be executed "at the same time")
        taskMaster_.execute( new Job()
        {
            public void execute()
            {
                DatagramSocketSend( pclone );
            }
        } );
    }

    public void receive( Packet p ) throws IOException
    {
        if ( LOG.isDebugEnabled() )
        {
            LOG.debug( "Waiting for incoming packet" );
        }

        DatagramPacket dp = new DatagramPacket( p.getData(), p.getLength() );
        super.receive( dp );

        p.setAddress( dp.getAddress() );
        p.setPort( dp.getPort() );
        p.setData( dp.getData() );
        p.setLength( dp.getLength() );

        if ( LOG.isDebugEnabled() )
        {
            LOG.debug( "Received incoming packet" );
        }
    }

    protected void DatagramSocketSend( Packet p )
    {
        try
        {
            if ( LOG.isDebugEnabled() )
            {
                LOG.debug( "Before raw send" );
            }
            DatagramPacket dp = new DatagramPacket( p.getData(), p.getLength(), p.getAddress(), p.getPort() );
            super.send( dp );
            if ( LOG.isDebugEnabled() )
            {
                LOG.debug( "After raw send" );
            }
        }
        catch ( IOException e )
        {
            //TODO hand this back to the UI somehow for evaluation
            LOG.error( e.getMessage(), e );
        }
    }

    public boolean isServer()
    {
        return !isUsingFirstAvailablePort_;
    }

    public MessengerID getMessengerID()
    {
        return messengerID_;
    }

    public void addDisconnectionListener( MessengerID messengerID,
                                          DisconnectionListener dcb )
    {
        //TODO
    }

    public void addDisconnectionListener( SelectionKey key,
                                          DisconnectionListener dcb )
    {
        //TODO
    }

    public void setIncomingMessageQueue( StandardUDPIncomingMessageQueue imq )
    {
    }

    public Set getClients()
    {
        return null;
    }

    protected static UDPMessenger instance_;
    protected TaskMaster taskMaster_ = new TaskMaster( 1, false );
    protected MessengerID messengerID_ = new MessengerID();
    protected boolean isUsingFirstAvailablePort_ = false;

    //com.navtools.networking.armi.networking.test code follows
    public static void main( String[] args ) throws Exception
    {
    }
}
