package com.navtools.armi.networking;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import java.nio.channels.SelectionKey;

import org.apache.log4j.Category;

public class UDPMessengerFilter implements UDPMessengerInterface
{
    public static final Category LOG =
    Category.getInstance( UDPMessengerFilter.class.getName() );

    public UDPMessengerFilter( UDPMessengerInterface inner )
    {
        inner_ = inner;
    }

    public void send( Packet p ) throws IOException
    {
        inner_.send( p );
    }

    public void receive( Packet p ) throws IOException
    {
        inner_.receive( p );
    }

    public void close()
    {
        inner_.close();
    }

    public int getLocalPort()
    {
        return inner_.getLocalPort();
    }

    /**
     * This method is only here to work around a bug in InetAddress that
     * causes it to retrieve 127.0.0.1 for the local IP in some circumastances.
     * Set the local IP to the correct IP for remote access here.
     */
    public void setLocalAddress( InetAddress localAddress )
    {
        inner_.setLocalAddress( localAddress );
    }

    public InetAddress getLocalAddress()
    {
        return inner_.getLocalAddress();
    }

    public MessengerID getMessengerID()
    {
        return inner_.getMessengerID();
    }

    public void addDisconnectionListener( MessengerID messengerID,
                                          DisconnectionListener dl )
    {
        inner_.addDisconnectionListener( messengerID, dl );

    }

    public void addDisconnectionListener( SelectionKey key,
                                          DisconnectionListener dl )
    {
        inner_.addDisconnectionListener( key, dl );

    }

    public Set getClients()
    {
        return null;
    }

    public void setIncomingMessageQueue( StandardUDPIncomingMessageQueue imq )
    {
    }

    protected UDPMessengerInterface inner_;
}
