package com.navtools.armi.networking;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import java.nio.channels.SelectionKey;

import org.apache.log4j.Category;

public interface UDPMessengerInterface
{
    public static final Category LOG =
    Category.getInstance( UDPMessengerInterface.class.getName() );

    public void setLocalAddress( InetAddress localAddress );

    public InetAddress getLocalAddress();

    public void send( Packet p ) throws IOException;

    public void receive( Packet p ) throws IOException;

    public void close();

    public int getLocalPort();

    public MessengerID getMessengerID();

    public void addDisconnectionListener( MessengerID messengerID,
                                          DisconnectionListener dcb );

    public void addDisconnectionListener( SelectionKey key,
                                          DisconnectionListener dcb );

    public Set getClients();

    public void setIncomingMessageQueue( StandardUDPIncomingMessageQueue imq );
}
