/*
 * $Id: DataStreamable.java,v 1.1 2003/09/06 21:49:22 wurp Exp $
 * $Log: DataStreamable.java,v $
 * Revision 1.1  2003/09/06 21:49:22  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:20  gergiskhan
 * no message
 *
 * Revision 1.1.1.1  2001/06/26 00:55:48  wurp
 * importing initial rev of source
 *
 * Revision 1.2  2001/06/20 02:58:52  wurp
 * Updated to log4j.  Added default ctor to CharacterInfo
 *
 * Revision 1.1  2001/04/06 05:35:02  wurp
 * Reorganized networking code
 *
 * Revision 1.1  2001/03/19 01:51:31  wurp
 * Adding new Asynchronous Messaging system.  Needs more testing, but superficial
 * tests show it working.
 *
 */

package com.navtools.serialization;

/**
 * DataStreamable objects should also provide a default constructor, so
 * they can be instantiated and read from a stream.
 */

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import org.apache.log4j.Category;

public interface DataStreamable
{
	public static final Category LOG =
	Category.getInstance( DataStreamable.class.getName() );

	public void readFrom( DataInputStream in ) throws IOException;

	public void writeTo( DataOutputStream out ) throws IOException;
}
