/*
 * $Id: BlockingQueue.java,v 1.3 2003/09/06 21:49:22 wurp Exp $
 */

package com.navtools.thread;

import java.util.LinkedList;

import org.apache.log4j.Category;

public class BlockingQueue
{
	public static final Category LOG =
	Category.getInstance( BlockingQueue.class.getName() );


	public void add( Object object )
	{
		Lock.logBeforeSync();
		synchronized ( this )
		{
			Lock.logBeginSync();
			getObjectList().addFirst( object );

			Lock.logBeforeNotifyAll();
			notifyAll();
			Lock.logAfterNotifyAll();

			Lock.logEndSync();
		}
		Lock.logAfterSync();
	}


	public Object get()
	{
		Object retval;
		Lock.logBeforeSync();
		synchronized ( this )
		{
			Lock.logBeginSync();
			while ( getObjectList().size() == 0 )
			{
				try
				{
					//It is expected that this monitor may never be released
					//since it is just waiting for objects that may or may not
					//come.
					Lock.logBeforeJobJarWait();
					wait();
					Lock.logAfterWait();
				}
				catch ( InterruptedException e )
				{
				}
			}
			retval = (Object) getObjectList().removeLast();
			Lock.logEndSync();
		}
		Lock.logAfterSync();

		return retval;
	}


	public boolean ready()
	{
		return size() != 0;
	}


	private LinkedList getObjectList()
	{
		synchronized ( objectList_ )
		{
			return objectList_;
		}
	}


	public boolean contains( Object object )
	{
		return getObjectList().contains( object );
	}


	public Object get( int index )
	{
		return (Object) getObjectList().get( index );
	}


	public int size()
	{
		return getObjectList().size();
	}


	private LinkedList objectList_ = new LinkedList();
}
