/*
 * $Id: CentralThreadPool.java,v 1.4 2003/09/06 21:49:22 wurp Exp $
 *
 * $Log: CentralThreadPool.java,v $
 * Revision 1.4  2003/09/06 21:49:22  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:20  gergiskhan
 * no message
 *
 * Revision 1.3  2002/04/15 03:43:57  wurp
 * Cache id to method mappings in text file
 * Fix sporadic bug in acquiring ids (timing bug in ClassAndMethodTable)
 * Fixed bug with methods having no arguments using ReturnValues
 * Added disconnectionListener
 *
 * Revision 1.2  2001/07/31 12:29:39  wurp
 * Added boolean 'expandable' parameter to TaskMaster to allow building thread
 * pools that expand as needed.
 *
 * Revision 1.1.1.1  2001/06/26 00:56:00  wurp
 * importing initial rev of source
 *
 * Revision 1.4  2001/06/20 03:36:07  wurp
 * added log4j.
 * debugging character creation issues.
 *
 * Revision 1.3  2001/01/28 07:52:18  wurp
 * Removed <dollar> from Id and Log in log comments.
 * Added several new commands to AdminApp
 * Unfortunately, several other changes that I have lost track of.  Try diffing this
 * version with the previous one.
 *
 * Revision 1.2  2000/12/16 22:07:32  wurp
 * Added Id and Log to almost all of the files that didn't have it.  It's
 * possible that the script screwed something up.  I did a commit and an update
 * right before I ran the script, so if a file is screwed up you should be able
 * to fix it by just going to the version before this one.
 *
 *
 */

package com.navtools.thread;

import org.apache.log4j.Category;

public class CentralThreadPool extends TaskMaster
{
	public static final Category LOG =
	Category.getInstance( CentralThreadPool.class.getName() );


	protected CentralThreadPool()
	{
		super( INITIAL_NUM_THREADS, false );
	}


	public static CentralThreadPool instance()
	{
		if ( instance_ == null )
		{
			instance_ = new CentralThreadPool();
		}

		return instance_;
	}


	protected static CentralThreadPool instance_;
	public static final int INITIAL_NUM_THREADS = 10;
}
