/*
 * $Id: Job.java,v 1.6 2003/09/06 21:49:22 wurp Exp $
 */

package com.navtools.thread;

import com.navtools.util.BooleanWrapper;
import org.apache.log4j.Category;

public abstract class Job
{
    public static final Category LOG =
    Category.getInstance( Job.class.getName() );

    private int trackingNumber = 0;

    void doJob()
    {
        if ( LOG.isDebugEnabled() )
        {
            LOG.debug( "Attempting to do job " + this  +" with TRACKING NUMBER: "+trackingNumber);
        }
        Lock.logBeforeSync();
        synchronized ( workingLock_ )
        {
            Lock.logBeginSync();
            try
            {
                busy_ = true;
                if ( LOG.isDebugEnabled() )
                {
                    LOG.debug( "Doing job " + this +" with TRACKING NUMBER: "+trackingNumber);
                }
                TaskMaster.setThreadInUse( Thread.currentThread(), true );
                execute();
                if ( LOG.isDebugEnabled() )
                {
                    LOG.debug( "Did job " + this +" with TRACKING NUMBER: "+trackingNumber);
                }
            }
            catch ( Exception e )
            {
                LOG.error( "Exception doing job " + this +" with TRACKING NUMBER: "+trackingNumber);
                LOG.error( e.getMessage(), e );
            }
            busy_ = false;
            TaskMaster.setThreadInUse( Thread.currentThread(), false );
            Lock.logEndSync();
        }
        Lock.logAfterSync();
    }

    public int getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(int num) {
        trackingNumber = num;
    }

    public boolean isBusy()
    {
        return busy_;
    }

    public void waitFor()
    {
        Lock.logBeforeSync();
        synchronized ( workingLock_ )
        {
            Lock.logBeginSync();
            Lock.logEndSync();
        }
        Lock.logAfterSync();
    }

    public abstract void execute() throws Exception;

    public void stop()
    {
        synchronized ( stopFlag )
        {
            stopFlag.setValue( true );
        }
    }

    public boolean isStopped()
    {
        synchronized ( stopFlag )
        {
            return stopFlag.getValue();
        }
    }

    public BooleanWrapper getStopFlag()
    {
        synchronized ( stopFlag )
        {
            return stopFlag;
        }
    }

    protected boolean busy_;
    private BooleanWrapper stopFlag = new BooleanWrapper( false );

    //This object is used as a lock, locked while the Job
    //is in doJob.  'this' is not used so it is available
    //for normal synchronization within the child class.
    private Object workingLock_ = new Object();

    //com.navtools.networking.armi.networking.test code follows
}
