/*
 * $Id: Lock.java,v 1.6 2003/09/06 21:49:22 wurp Exp $
 */

package com.navtools.thread;

import org.apache.log4j.Category;

public class Lock
{
	public static final Category LOG =
	Category.getInstance( Lock.class.getName() );

	public static final Category HIDBG =
	Category.getInstance( "debug." + Lock.class.getName() );


	public void lock()
	{
		logBeforeSync();
		synchronized ( this )
		{
			logBeginSync();
			waitFor();

			locked_ = true;
			logEndSync();
		}
		logAfterSync();
	}


	public void unlock()
	{
		logBeforeSync();
		synchronized ( this )
		{
			logBeginSync();
			locked_ = false;

			logBeforeNotifyAll();
			notifyAll();
			logAfterNotifyAll();

			logEndSync();
		}
		logAfterSync();
	}


	public void waitFor()
	{
		synchronized ( this )
		{
			while ( locked_ )
			{
				try
				{
					wait();
				}
				catch ( InterruptedException e )
				{
					LOG.error( "waitFor", e );
				}
			}
		}
	}


	public static final void logWithStackTrace( String s )
	{
		if ( HIDBG.isDebugEnabled() )
		{
			Exception e = new Exception();
			HIDBG.debug( s, e );
			HIDBG.debug( "\n" );
		}
	}


	public static final void logBeforeSync()
	{
		logWithStackTrace( "before sync" );
	}


	public static final void logAfterSync()
	{
		logWithStackTrace( "after sync" );
	}


	public static final void logBeginSync()
	{
		logWithStackTrace( "begin sync" );
	}


	public static final void logEndSync()
	{
		logWithStackTrace( "end sync" );
	}


	public static final void logBeforeJobJarWait()
	{
		logWithStackTrace( "before JobJar wait" );
	}


	public static final void logBeforeWait()
	{
		logWithStackTrace( "before wait" );
	}


	public static final void logAfterWait()
	{
		logWithStackTrace( "after wait" );
	}


	public static final void logBeforeNotify()
	{
		logWithStackTrace( "before notify" );
	}


	public static final void logAfterNotify()
	{
		logWithStackTrace( "after notify" );
	}


	public static final void logBeforeNotifyAll()
	{
		logWithStackTrace( "before notifyAll" );
	}


	public static final void logAfterNotifyAll()
	{
		logWithStackTrace( "after notifyAll" );
	}


	protected boolean locked_ = false;
}
