/*
 * $Id: TaskMaster.java,v 1.7 2003/09/06 21:49:22 wurp Exp $
 */

package com.navtools.thread;

import java.util.*;

import org.apache.log4j.Category;

class TestJob extends Job
{
    public static final Category LOG =
    Category.getInstance( TestJob.class.getName() );


    public void execute()
    {
        for ( int i = 0; i < 40; ++i )
        {
            System.out.println( Thread.currentThread().getName() + " " + i );
            try
            {
                Thread.sleep( 1000 );
            }
            catch ( Exception e )
            {
            }
        }
    }
}

public class TaskMaster
{
    public static final Category LOG =
    Category.getInstance( TaskMaster.class.getName() );


    public TaskMaster( int initialNumberOfWorkers, boolean expandable )
    {
        if ( LOG.isDebugEnabled() )
        {
            LOG.debug( "constructing expandable? " + expandable + " taskmaster",
                       new Exception() );
        }

        expandable_ = expandable;

        for ( int i = 0; i < initialNumberOfWorkers; ++i )
        {
            addWorker( new Worker() );
        }
    }


    public void execute( Job job )
    {
        if (LOG.isDebugEnabled()) {
            LOG.debug("TackMaster.execute() job with TRACKING NUMBER: "+job.getTrackingNumber());
        }

        if ( expandable_ )
        {
            Iterator iter = new ArrayList( workerList_ ).iterator();
            boolean allBusy = true;
            while ( allBusy && iter.hasNext() )
            {
                Worker curr = (Worker) iter.next();
                if ( !curr.isBusy() )
                {
                    allBusy = false;
                }
            }

            if ( allBusy )
            {
                synchronized ( this )
                {
                    LOG.warn( "expanding taskmaster " + this );
                    addWorker( new Worker( job ) );
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("TackMaster.execute() added Worker with job with TRACKING NUMBER: "+job.getTrackingNumber());
                    }
                }
            }
            else
            {
                jobJar_.add( job );
                if (LOG.isDebugEnabled()) {
                    LOG.debug("TackMaster.execute() added job to jobJar with TRACKING NUMBER: "+job.getTrackingNumber());
                }
            }
        }
        else
        {
            jobJar_.add( job );
            if (LOG.isDebugEnabled()) {
                    LOG.debug("TackMaster.execute() added job to jobJar, not expandable, with TRACKING NUMBER: "+job.getTrackingNumber());
            }
        }
    }


    public void addWorker( Worker worker )
    {
        workerList_.add( worker );
        worker.getJobsFrom( jobJar_ );
    }


    public void waitFor( Job job )
    {
        if ( jobJar_.contains( job ) )
        {
            job.waitFor();
        }
    }


    public void waitForAll()
    {
        while ( jobJar_.size() != 0 )
        {
            Job job = jobJar_.get( 0 );
            if ( job != null )
            {
                job.waitFor();
            }
        }
    }


    public int getNumberOfWorkers()
    {
        return workerList_.size();
    }


    public static Collection getThreadsInUse()
    {
        return threadsInUse_;
    }


    public static void setThreadInUse( Thread thread, boolean inUse )
    {
        if ( inUse )
        {
            if ( threadsInUse_.contains( thread ) )
            {
                LOG.warn( "Attempt to set as in-use a thread " +
                          "which is already in-use: " + thread );
            }
            else
            {
                threadsInUse_.add( thread );
            }
        }
        else
        {
            if ( threadsInUse_.contains( thread ) )
            {
                threadsInUse_.remove( thread );
            }
            else
            {
                LOG.warn( "Attempt to set as not in-use a " +
                          "thread which is not in-use: " + thread );
            }
        }
    }


    protected JobJar jobJar_ = new JobJar();
    protected List workerList_ = Collections.synchronizedList( new LinkedList() );
    protected boolean expandable_ = true;

    protected static Set threadsInUse_ = Collections.synchronizedSet( new HashSet() );


    //com.navtools.networking.armi.networking.test code follows
    public static void main( String[] args )
    {
        TaskMaster taskMaster = new TaskMaster( 1, false );

        Job aJob = null;
        for ( int i = 0; i < 10; ++i )
        {
            Job job = new TestJob();
            if ( i == 3 )
            {
                aJob = job;
            }
            taskMaster.execute( job );
            try
            {
                Thread.sleep( 370 );
            }
            catch ( Exception e )
            {
            }
        }
        ;

        taskMaster.waitFor( aJob );
        System.out.println( "A job finished" );
        taskMaster.waitForAll();
    }
}

