package com.navtools.thread;

import org.apache.log4j.Category;

public class ThreadUtil
{
	public static final Category LOG =
	Category.getInstance( ThreadUtil.class.getName() );


	protected ThreadUtil()
	{
	};

	public static void executeWithTimeout( final Job toExec,
	                                       final int timeoutInMillis )
	{
		final Thread parent = Thread.currentThread();

		//if we are debugging, create an exception show we can show the stack
		//trace where the thread was created when we run it
		Exception tempShowWhereCalled = null;
		if ( LOG.isDebugEnabled() )
		{
			tempShowWhereCalled = new Exception();
		}
		final Exception showWhereCalled = tempShowWhereCalled;


		Thread toTime = new Thread()
		{
			public void run()
			{
				try
				{
					if ( ThreadUtil.LOG.isDebugEnabled() )
					{
						ThreadUtil.LOG.debug( "about to run " + this );
					}

					toExec.execute();

					if ( ThreadUtil.LOG.isDebugEnabled() )
					{
						ThreadUtil.LOG.debug( "ran " + this );
					}

					if ( !toExec.isStopped() )
					{
						parent.interrupt();
					}
				}
				catch ( Exception e )
				{
					LOG.error( "" + Thread.currentThread(), e );
					if ( showWhereCalled != null )
					{
						LOG.error( "Thread created at:", showWhereCalled );
					}
				}
			}
		};
		toTime.start();

		try
		{
			if ( LOG.isDebugEnabled() )
			{
				LOG.debug( "about to wait " + timeoutInMillis + " for " + toTime );
			}

			//clear the interrupted flag if it's set, otherwise the sleep won't sleep
			Thread.interrupted();
			Thread.currentThread().sleep( timeoutInMillis );
			toExec.stop();

			if ( LOG.isDebugEnabled() )
			{
				LOG.debug( "timed out on " + toExec, new Exception() );
			}
		}
		catch ( InterruptedException e )
		{
			if ( LOG.isDebugEnabled() )
			{
				LOG.debug( "completed " + toExec, e );
			}
			Thread.interrupted();
		}
	}
}
