/*
 * $Id: Worker.java,v 1.6 2003/09/06 21:49:22 wurp Exp $
 */

package com.navtools.thread;

import org.apache.log4j.Category;

public class Worker extends Thread
{
    public static final Category LOG =
    Category.getInstance( Worker.class.getName() );


    public Worker()
    {
    }


    public Worker( Job startingJob )
    {
        busy_ = true;
        currJob_ = startingJob;
    }


    public void getJobsFrom( JobJar jobJar )
    {
        Lock.logBeforeSync();
        synchronized ( this )
        {
            Lock.logBeginSync();

            jobJar_ = jobJar;
            if ( !started_ )
            {
                started_ = true;
                start();
            }
            Lock.logEndSync();
        }
        Lock.logAfterSync();
    }


    public void run()
    {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Worker.run()");
        }
        try
        {
            while ( shouldRun_ )
            {
                if ( currJob_ == null )
                {
                    currJob_ = jobJar_.get();
                }

                int trackingNum = currJob_.getTrackingNumber();

                if (LOG.isDebugEnabled()) {
                    LOG.debug("currentJob has TRACKING NUMBER:"+trackingNum);
                }

                busy_ = true;
                currJob_.doJob();
                currJob_ = null;
                busy_ = false;

                if (LOG.isDebugEnabled()) {
                    LOG.debug("finished job with TRACKING NUMBER:"+trackingNum);
                }
            }
            started_ = false;
        }
        catch ( Exception e )
        {
            LOG.error( e.getMessage(), e );
        }
    }


    public boolean isBusy()
    {
        return busy_;
    }


    public void stopRunning()
    {
        shouldRun_ = false;
    }


    protected boolean started_ = false;
    protected boolean shouldRun_ = true;
    protected boolean busy_ = false;
    protected JobJar jobJar_;
    protected Job currJob_;


    //com.navtools.networking.armi.networking.test code follows
    public static void main( String[] args )
    {
    }
}
