/*
 * $Id: ArrayUtil.java,v 1.6 2003/09/06 21:49:22 wurp Exp $
 */

package com.navtools.util;

/**
 *
 * @author Bobby Martin
 * @copyright 2000, 2002
 * @version 0.1
 * @since 0.1
 */

import java.lang.reflect.Array;
import java.util.Comparator;

import org.apache.log4j.Category;

//import org.apache.xpath.objects.Comparator;

public class ArrayUtil
{
	public static final Category LOG =
	Category.getInstance( ArrayUtil.class.getName() );

	/**
	 * Return true iff arg1 and arg2 have the same objects
	 * in the same order.
	 */
	public static boolean compare( Object[] arg1, Object[] arg2 )
	{
		if ( arg1.length != arg2.length )
		{
			return false;
		}

		for ( int i = 0; i < arg1.length; ++i )
		{
			if ( arg1[i] != arg2[i] )
			{
				return false;
			}
		}

		return true;
	}

	/**
	 * Searches the array for an object identical to obj.
	 * @param arr array to search
	 * @param obj object to search for
	 * @return index of obj or ArrayUtil.NOT_FOUND if obj not in arr
	 */
	public static int search( Object[] arr, Object obj )
	{
		for ( int i = 0; i < arr.length; ++i )
		{
			if ( arr[i] == obj )
			{
				return i;
			}
		}

		return NOT_FOUND;
	}

	/**
	 * Searches the array for an object equal to obj (arr[i].equals(obj)).
	 * @param arr array to search
	 * @param obj object to search for
	 * @return index of obj or ArrayUtil.NOT_FOUND if obj not in arr
	 */
	public static int searchEquals( Object[] arr, Object obj )
	{
		for ( int i = 0; i < arr.length; ++i )
		{
			if ( arr[i].equals( obj ) )
			{
				return i;
			}
		}

		return NOT_FOUND;
	}

	public static int wrapIndex( Object[] arr, int index )
	{
		if ( index < 0 )
		{
			index += ( ( arr.length - index ) / arr.length ) * arr.length;
		}

		return index % arr.length;
	}

	public static void arrayCopy( byte[] src,
	                              int src_position,
	                              byte[] dst,
	                              int dst_position,
	                              int length )
	{
		for ( int i = 0; i < length; ++i )
		{
			dst[dst_position + i] = src[src_position + i];
		}
	}

	/**
	 * Writes an integer as 4 bytes in a buffer, with the first byte
	 * being at index start.
	 * Uses the standard serialization format for an integer.
	 */
	public static void writeInt( int i, byte[] buffer, int start )
	{
		buffer[start] = (byte) ( ( i >> 24 ) & 0xff );
		buffer[start + 1] = (byte) ( ( i >> 16 ) & 0xff );
		buffer[start + 2] = (byte) ( ( i >> 8 ) & 0xff );
		buffer[start + 3] = (byte) ( i & 0xff );
	}

	public static String toHexString( byte[] buffer, int start, int length )
	{
		StringBuffer sb = new StringBuffer();
		int end = start + length;
		for ( int i = start; i < end; ++i )
		{
			sb.append( Integer.toHexString( (int) ( buffer[i] + 0x200 ) )
			           .substring( 1 ) );
			sb.append( "-" );
		}

		return sb.toString();
	}

	/**
	 * @return a copy of mainList, but without anything from toRemove
	 */
	public static Object[] allBut( Object[] mainList, final Object[] toRemove )
	{
		return allBut( mainList, toRemove, new Comparator()
		{
			public int compare( Object arg1, Object arg2 )
			{
				return arg1.equals( arg2 ) ? 0 : 1;
			}
		} );
	}

	public static Object[] allBut( Object[] mainList, final Object[] toRemove,
	                               final Comparator comparison )
	{
		return allBut( mainList, new Criterion()
		{
			public boolean matches( Object mainListObj )
			{
				for ( int i = 0; i < toRemove.length; ++i )
				{
					if ( comparison.compare( mainListObj, toRemove[i] ) == 0 )
					{
						return true;
					}
				}

				return false;
			}
		} );
	}

	/**
	 * @return a copy of mainList, but without anything that matches shouldRemove
	 */
	public static Object[] allBut( Object[] mainList, Criterion shouldRemove )
	{
		boolean removed;
		int copiedCount = 0;

		for ( int j = 0; j < mainList.length; ++j )
		{
			if ( !shouldRemove.matches( mainList[j] ) )
			{
				mainList[copiedCount++] = mainList[j];
			}
		}

		Object[] retval = newInstanceLike( mainList, copiedCount );
		System.arraycopy( mainList, 0, retval, 0, retval.length );

		return retval;
	}

	/**
	 * Create a new array instance that has the same type components as
	 * arrayToBeLike, i.e. if arrayToBeLike is an int[], then this method
	 * will return a int[] that is length long.
	 */
	public static Object[] newInstanceLike( Object[] arrayToBeLike, int length )
	{
		return (Object[]) Array.newInstance( arrayToBeLike.getClass().getComponentType(),
		                                     length );
	}

	public static final int NOT_FOUND = -1;
	//provide a list of standard empty arrays for use as arguments to the
	//Collection.toArray(Object[]) methods
	public static final String[] EMPTY_STRING_ARRAY = new String[0];
	public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
}
