/*
 * $Id: CriterionBase.java,v 1.2 2003/09/06 21:49:22 wurp Exp $
 */

package com.navtools.util;

/**
 *
 *
 * @author Bobby Martin
 * Copyright (c) 2001, all rights reserved
 * Created UTC 2001/10/10 03:12:25
 */

import org.apache.log4j.Category;

public abstract class CriterionBase implements Criterion
{
	public static final Category LOG =
	Category.getInstance( CriterionBase.class.getName() );

	public CriterionAnd and( Criterion rhs )
	{
		return new CriterionAnd( this, rhs );
	}

	public CriterionOr or( Criterion rhs )
	{
		return new CriterionOr( this, rhs );
	}

	public CriterionNot not()
	{
		return new CriterionNot( this );
	}

	/**
	 * Tests to see if two objects are equal, handling null pointers
	 * in the intuitive way without throwing a NullPointerException.
	 */
	public static boolean objectsEqual( Object lhs, Object rhs )
	{
		if ( lhs != null )
		{
			return lhs.equals( rhs );
		}
		else
		{
			return rhs == null;
		}
	}

	public static void main( String[] args )
	{
	}
}
