package com.navtools.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class FileUtil
{
	/**
	 * Returns a list of all files in the tree with the given
	 * root which match the criterion.  If filter is null, all
	 * files (including directories) are retrieved.
	 * The search is depth-first.
	 */
	public static List/*File*/ getAllFilesInTree( File root, FileFilter filter )
	{
		List/*File*/ retval = new ArrayList();
		getAllFilesInTree( retval, root, filter );
		return retval;
	}

	/**
	 * Returns a list of all files in the tree with the given
	 * root which match the criterion.  If crit is null, all
	 * files (including directories) are retrieved.
	 * The files are added to the end of list.
	 * The search is depth-first.
	 */
	public static List/*File*/ getAllFilesInTree( List/*File*/ list, File root, FileFilter filter )
	{
		if ( filter == null )
		{
			filter = ACCEPT_ALL_FILES;
		}

		File[] localFiles = root.listFiles();
		for ( int i = 0; i < localFiles.length; ++i )
		{
			if ( localFiles[i].isDirectory() )
			{
				getAllFilesInTree( list, localFiles[i], filter );
			}
			if ( filter.accept( localFiles[i] ) )
			{
				list.add( localFiles[i] );
			}
		}

		return list;
	}

	public static final FileFilter ACCEPT_ALL = new FileFilter()
	{
		public boolean accept( File f )
		{
			return true;
		}
	};

	public static final FileFilter ACCEPT_ALL_FILES = new FileFilter()
	{
		public boolean accept( File f )
		{
			return f.isFile();
		}
	};

	public static final FileFilter ACCEPT_ALL_CLASS_FILES = new FileFilter()
	{
		public boolean accept( File f )
		{
			return f.isFile() && f.getName().endsWith( ".class" );
		}
	};

	public static final FileFilter ACCEPT_ALL_DIRECTORIES = new FileFilter()
	{
		public boolean accept( File f )
		{
			return f.isDirectory();
		}
	};
}
