/*
 * $Id: Pair.java,v 1.2 2003/09/06 21:49:22 wurp Exp $
 *
 * $Log: Pair.java,v $
 * Revision 1.2  2003/09/06 21:49:22  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:21  gergiskhan
 * no message
 *
 * Revision 1.1.1.1  2001/06/26 00:56:00  wurp
 * importing initial rev of source
 *
 * Revision 1.7  2001/06/22 03:06:02  wurp
 * More log4j changes
 *
 * Revision 1.6  2001/06/20 02:58:52  wurp
 * Updated to log4j.  Added default ctor to CharacterInfo
 *
 * Revision 1.5  2001/06/09 17:22:08  wurp
 * Integrating with main PC from laptop... hope all goes well
 *
 * Revision 1.4  2001/04/01 06:27:07  wurp
 * Finally fixed new networking system to handle multiple clients (ouch!).
 * Had to add support for arbitrary number of instances shared for each interface.
 *
 * Revision 1.3  2001/01/28 07:52:19  wurp
 * Removed <dollar> from Id and Log in log comments.
 * Added several new commands to AdminApp
 * Unfortunately, several other changes that I have lost track of.  Try diffing this
 * version with the previous one.
 *
 * Revision 1.2  2000/12/16 22:07:32  wurp
 * Added Id and Log to almost all of the files that didn't have it.  It's
 * possible that the script screwed something up.  I did a commit and an update
 * right before I ran the script, so if a file is screwed up you should be able
 * to fix it by just going to the version before this one.
 *
 *
 */

package com.navtools.util;

import java.io.Serializable;

import org.apache.log4j.Category;

public class Pair implements Serializable
{
	public static final Category LOG =
	Category.getInstance( Pair.class.getName() );

	public Pair( Object first, Object second )
	{
		first_ = first;
		second_ = second;
	}

	public boolean equals( Object obj )
	{
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "In equals" );
		}

		if ( obj instanceof Pair )
		{
			Pair rhs = (Pair) obj;
			if ( first_.equals( rhs.first_ ) && second_.equals( rhs.second_ ) )
			{
				return true;
			}
		}

		return false;
	}

	//use bitwise xor of first & second for hashcode, since bitwise
	//xor doesn't care about the order of the args, and it also
	//preserves as much uniqueness in the hashcode as possible
	public int hashCode()
	{
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "In hashcode" );
		}
		return first_.hashCode() ^ second_.hashCode();
	}

	public String toString()
	{
		return first_ + ", " + second_;
	}

	public Object getFirst()
	{
		return first_;
	}

	public Object getSecond()
	{
		return second_;
	}

	public void setFirst( Object first )
	{
		first_ = first;
	}

	public void setSecond( Object second )
	{
		second_ = second;
	}

	Object first_;
	Object second_;

	//com.navtools.networking.armi.networking.test code follows
	public static void main( String[] args ) throws Exception
	{
		String a = "Hi";
		String b = "H";
		b += "i";
		String c = "Hello";
		String d = "Bye";

		Pair upab = new Pair( a, b );
		Pair upac = new Pair( a, c );
		Pair upca = new Pair( c, a );
		Pair upba = new Pair( b, a );
		Pair upbc = new Pair( b, c );
		Pair upcb = new Pair( c, b );

		//leftover com.navtools.networking.armi.networking.test code from when I copied this from UnorderedPair
//          //since unorderedpair does a == on the values, but doesn't care about
//          //the order of the values, upab == upba; upac != upca; upba != upca
//          //upbc == upcb; upbc != upac; upbc != upca
//          verify("!upab.equals(upba)", !upab.equals(upba));
//          verify("upac.equals(upca)", upac.equals(upca));
//          verify("!upba.equals(upca)", !upba.equals(upca));
//          verify("upbc.equals(upcb)", upbc.equals(upcb));
//          verify("!upbc.equals(upac)", !upbc.equals(upac));
//          verify("!upbc.equals(upca)", !upbc.equals(upca));

//          Map map = new HashMap();
//          //since hashmap uses equals to determine if a key is valid or not,
//          verify("original size == 0", map.size() == 0);
//          map.put(upab,"1");
//          verify("upab not dupe", map.size() == 1);

//          map.put(upba,"1.1");
//          verify("upba is dupe", map.size() == 1);

//          map.put(upbc,"2");
//          verify("upbc is not dupe", map.size() == 2);

//          map.put(upcb,"2.1");
//          verify("upbc is dupe", map.size() == 2);

//          map.put(upca,"3");
//          verify("upca is not dupe", map.size() == 3);

//          map.put(upac,"3.1");
//          verify("upac is dupe", map.size() == 3);

//          Iterator iter = map.asList().iterator();
//          while(iter.hasNext())
//              {
//                  System.out.println(iter.next());
//              }
	}

	public static void verify( String desc, boolean valid )
	{
		if ( !valid )
		{
			System.err.println( "Error, not valid: " + desc );
		}
	}
}
