/*
 * $Id: RFCUtil.java,v 1.2 2003/09/06 21:49:22 wurp Exp $
 * $Log: RFCUtil.java,v $
 * Revision 1.2  2003/09/06 21:49:22  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:21  gergiskhan
 * no message
 *
 * Revision 1.1.1.1  2001/06/26 00:56:00  wurp
 * importing initial rev of source
 *
 * Revision 1.3  2001/06/22 03:06:02  wurp
 * More log4j changes
 *
 * Revision 1.2  2001/06/20 02:58:52  wurp
 * Updated to log4j.  Added default ctor to CharacterInfo
 *
 * Revision 1.1  2001/04/04 15:46:35  wurp
 * Added SNTP client to sync time from client to server.
 * Still have to run SNTP server on LoginServer, and may need to change from default SNTP port. (since it's below 1024 and thus not accessible to non-root processes on *nix)
 *
 */

package com.navtools.util;

import org.apache.log4j.Category;

public class RFCUtil
{
	public static final Category LOG =
	Category.getInstance( RFCUtil.class.getName() );

	public static final long getLong( byte[] buffer, int offset )
	{
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "Getting RFC long" );
		}

		long retval = 0;
		//TODO verify this procedure against an actual NTPTimeStamp message
		//from an official server
		for ( int i = 0; i < 8; ++i )
		{
			if ( LOG.isDebugEnabled() )
			{
				LOG.debug( "" + ( ( (int) buffer[offset + i] ) & 0xff ) );
			}
			retval <<= 8;
			retval |= ( (int) buffer[offset + i] ) & 0xff;
		}

		return retval;
	}

	public static final void setLong( byte[] buffer, int offset, long val )
	{
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "Setting RFC long" );
		}

		//TODO verify this procedure against an actual NTPTimeStamp message
		//from an official server
		for ( int i = 7; i >= 0; --i )
		{
			if ( LOG.isDebugEnabled() )
			{
				LOG.debug( "" + ( val & 0xff ) );
			}
			buffer[offset + i] = (byte) ( val & 0xff );
			val >>= 8;
		}
	}

	public static final int getInt( byte[] buffer, int offset )
	{
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "Getting RFC int" );
		}

		int retval = 0;
		//TODO verify this procedure against an actual NTPTimeStamp message
		//from an official server
		for ( int i = 0; i < 4; ++i )
		{
			if ( LOG.isDebugEnabled() )
			{
				LOG.debug( "" + ( ( (int) buffer[offset + i] ) & 0xff ) );
			}
			retval <<= 8;
			retval |= ( (int) buffer[offset + i] ) & 0xff;
		}

		return retval;
	}

	public static final void setInt( byte[] buffer, int offset, long val )
	{
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "Setting RFC int" );
		}

		//TODO verify this procedure against an actual NTPTimeStamp message
		//from an official server
		for ( int i = 3; i >= 0; --i )
		{
			if ( LOG.isDebugEnabled() )
			{
				LOG.debug( "" + ( val & 0xff ) );
			}
			buffer[offset + i] = (byte) ( val & 0xff );
			val >>= 8;
		}
	}

	//debug code follows
}
