/*
 * $Id: SNTPServer.java,v 1.2 2003/09/06 21:49:23 wurp Exp $
 * $Log: SNTPServer.java,v $
 * Revision 1.2  2003/09/06 21:49:23  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:21  gergiskhan
 * no message
 *
 * Revision 1.1  2002/04/15 03:43:57  wurp
 * Cache id to method mappings in text file
 * Fix sporadic bug in acquiring ids (timing bug in ClassAndMethodTable)
 * Fixed bug with methods having no arguments using ReturnValues
 * Added disconnectionListener
 *
 * Revision 1.4  2001/06/23 16:24:00  wurp
 * More log4j migration
 * Fixed sr; replacement of $1 type variables was broken.
 *
 * Revision 1.3  2001/06/22 03:06:02  wurp
 * More log4j changes
 *
 * Revision 1.2  2001/06/20 02:58:53  wurp
 * Updated to log4j.  Added default ctor to CharacterInfo
 *
 * Revision 1.1  2001/04/04 15:46:35  wurp
 * Added SNTP client to sync time from client to server.
 * Still have to run SNTP server on LoginServer, and may need to change from default SNTP port. (since it's below 1024 and thus not accessible to non-root processes on *nix)
 *
 */

package com.navtools.util;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

import org.apache.log4j.Category;

public class SNTPServer extends Thread
{
	public static final Category LOG =
	Category.getInstance( SNTPServer.class.getName() );

	protected SNTPServer()
	{
	}

	public static void initialize( TimeProvider timeProvider, int port )
	throws SocketException
	{
		timeProvider_ = timeProvider;
		port_ = port;
		socket_ = new DatagramSocket( port_ );
		new SNTPServer().start();
	}

	public static void initialize( TimeProvider timeProvider )
	throws SocketException
	{
		initialize( timeProvider, DEFAULT_NTP_PORT );
	}

	public static void initialize( int port )
	throws SocketException
	{
		initialize( SNTPClient.defaultTimeProvider(), port );
	}

	public static void initialize()
	throws SocketException
	{
		initialize( DEFAULT_NTP_PORT );
	}

	public void run()
	{
		DatagramPacket incoming = new DatagramPacket( new byte[2048], 2048 );
		DatagramPacket outgoing = new DatagramPacket( new byte[2048], 2048 );

		while ( true )
		{
			try
			{
				incoming.setLength( 2048 );
				getSocket().receive( incoming );
				long receiveMillis = timeProvider_.currentTimeMillis();
				if ( LOG.isDebugEnabled() )
				{
					LOG.debug( "receiving SNTP message" );
				}
				SNTPMessage msg = new SNTPMessage( incoming.getData(),
				                                   incoming.getLength() );
				if ( msg.isValid() )
				{
					//copy client message into outgoing buffer
					outgoing.setData( msg.getBuffer() );
					outgoing.setLength( msg.getBuffer().length );

					//set the fields that indicate this is a server NTP message
					msg.setServerData();

					if ( LOG.isDebugEnabled() )
					{
						LOG.debug( "replying to SNTP message, reply length: " +
						           outgoing.getLength() );
					}
					//reply back to requester
					outgoing.setAddress( incoming.getAddress() );
					outgoing.setPort( incoming.getPort() );

					msg.setReceiveTimeStampFromMillis( receiveMillis );
					msg.setTransmitTimeStampFromMillis( timeProvider_.currentTimeMillis() );
					getSocket().send( outgoing );
				}
			}
			catch ( Exception e )
			{
				LOG.error( e.getMessage(), e );
			}
		}
	}

	public static DatagramSocket getSocket()
	{
		return socket_;
	}

	protected static final int DEFAULT_NTP_PORT = 123;

	protected static int port_;
	protected static DatagramSocket socket_;
	protected static TimeProvider timeProvider_;

	public static void main( String[] args ) throws Exception
	{
		SNTPServer.initialize();
	}
}

