/*
 * $Id: StringUtil.java,v 1.4 2003/09/06 21:49:23 wurp Exp $
 *
 * $Log: StringUtil.java,v $
 * Revision 1.4  2003/09/06 21:49:23  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:21  gergiskhan
 * no message
 *
 * Revision 1.3  2002/09/20 01:17:55  wurp
 * Added some extra functionality to the array & string utilities; shortened the check cycle on the Terminator
 *
 * Revision 1.2  2001/10/16 03:59:06  wurp
 * Adding Josh Laase's replaceString method
 *
 * Revision 1.1.1.1  2001/06/26 00:55:57  wurp
 * importing initial rev of source
 *
 * Revision 1.4  2001/06/20 02:58:53  wurp
 * Updated to log4j.  Added default ctor to CharacterInfo
 *
 * Revision 1.3  2001/01/28 07:52:19  wurp
 * Removed <dollar> from Id and Log in log comments.
 * Added several new commands to AdminApp
 * Unfortunately, several other changes that I have lost track of.  Try diffing this
 * version with the previous one.
 *
 * Revision 1.2  2000/12/16 22:07:33  wurp
 * Added Id and Log to almost all of the files that didn't have it.  It's
 * possible that the script screwed something up.  I did a commit and an update
 * right before I ran the script, so if a file is screwed up you should be able
 * to fix it by just going to the version before this one.
 *
 *
 */

package com.navtools.util;

import java.util.Collection;
import java.util.Iterator;

import org.apache.log4j.Category;

public class StringUtil
{
	public static final Category LOG =
	Category.getInstance( StringUtil.class.getName() );

	public static String spaces( int numSpaces )
	{
		StringBuffer retval = new StringBuffer( "" );
		while ( retval.length() < numSpaces )
		{
			retval.append( " " );
		}

		return retval.toString();
	}

	public static String denull( String s )
	{
		return s == null ? "" : s;
	}

	public static boolean isIndexPastEnd( String s, int idx )
	{
		return idx >= s.length();
	}

	public static String excise( String s, int idx )
	{
		return s.substring( 0, idx ) + s.substring( idx + 1 );
	}

	/**
	 * @param source - the original string
	 * @param old - the old value to replace with newstring
	 * @param newstring - the new value to use for replacing old string
	 * @return string where all occurrences of old in source are replaced with newstring
	 */
	public static String replaceString( String source, String old, String newstring )
	{
		String sRet = "";

		if ( source != null && old != null && newstring != null )
		{
			for ( int i = 0; i < source.length(); i++ )
			{
				//we need to make sure that we do not take a sub
				//string that is longer than our original word
				if ( ( source.length() - i ) < ( old.length() ) )
				{
					while ( i < source.length() )
					{
						sRet += source.substring( i, i + 1 );
						i++;
					}
					break;
				}

				if ( source.substring( i, i + old.length() ).equals( old ) )
				{
					sRet += newstring;
					i += old.length() - 1;
				}
				else
				{
					sRet += source.substring( i, i + 1 );
				}
			}
		}

		return sRet;
	}

	public static String makeList( Collection/*String*/ list, String delimiter )
	{
		StringBuffer retval = new StringBuffer();

		boolean first = true;
		Iterator iter = list.iterator();
		while ( iter.hasNext() )
		{
			if ( !first )
			{
				retval.append( delimiter );
			}
			first = false;

			retval.append( iter.next().toString() );
		}

		return retval.toString();
	}

	public static String makeList( Object[] array, String delimiter )
	{
		StringBuffer retval = new StringBuffer();

		boolean first = true;
		for ( int i = 0; i < array.length; ++i )
		{
			if ( !first )
			{
				retval.append( delimiter );
			}
			first = false;

			retval.append( array[i].toString() );
		}

		return retval.toString();
	}

	public static void verify( String desc, boolean valid )
	{
		if ( !valid )
		{
			System.err.println( "Error, not valid: " + desc );
		}
	}
}
