/*
 * $Id: SyncedTime.java,v 1.2 2003/09/06 21:49:23 wurp Exp $
 */

package com.navtools.util;

import org.apache.log4j.Category;

public class SyncedTime
{
	public static final Category LOG =
	Category.getInstance( SyncedTime.class.getName() );

	protected SyncedTime( TimeProvider timeProvider )
	{
		timeProvider_ = timeProvider;
	}

	public long getNow()
	{
		long now = syncDelta_ + timeProvider_.currentTimeMillis();
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "Current synced time: " + now );
		}
		return now;
	}

	/**
	 * Pass in the timestamp of the server to sync with.
	 * All future calls to this object will get the synced time, a close
	 * approximation of the time on the server last synced with.
	 */
	public void syncWith( Timestamp serverTime )
	{
		syncDelta_ = timeProvider_.currentTimeMillis() - serverTime.getMillis();
	}

	public void setSyncDelta( long syncDelta )
	{
		syncDelta_ = syncDelta;
	}

	public static SyncedTime instance()
	{
		if ( instance_ == null )
		{
			instance_ = new SyncedTime( new SystemTimeProvider() );
		}

		return instance_;
	}

	public static SyncedTime establishInstance( TimeProvider timeProvider )
	{
		if ( instance_ == null )
		{
			instance_ = new SyncedTime( timeProvider );
		}

		return instance_;
	}

	protected TimeProvider timeProvider_;
	protected long syncDelta_;
	protected static SyncedTime instance_;

	//com.navtools.networking.armi.networking.test code follows

	public static void main( String[] args )
	{
	}
}
