/*
 * $Id: SyncedTimer.java,v 1.2 2003/09/06 21:49:23 wurp Exp $
 */

/* Generated by Together */

package com.navtools.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;

import org.apache.log4j.Category;

public class SyncedTimer extends Timer
{
	public static final Category LOG =
	Category.getInstance( SyncedTimer.class.getName() );

	protected SyncedTimer( InetAddress timeServerAddress )
	{
		timeProvider_ = TimeProvider.getInstance();

		SyncedTime.establishInstance( timeProvider_ );

		try
		{
			if ( timeServerAddress != null )
			{
				SNTPClient.initialize( timeProvider_,
				                       timeServerAddress, SAFE_NTP_PORT );

				boolean done = false;
				//try up to 20 times to sync times
				for ( int i = 0; i < 20 && !done; ++i )
				{
					try
					{
						SyncedTime.instance().
						setSyncDelta( SNTPClient.
						              getOffsetInMillis( NUM_POLLS ) );
						done = true;
					}
					catch ( IOException e )
					{
						LOG.error( e.getMessage(), e );
					}
				}
			}
			else
			{
				SNTPServer.initialize( SAFE_NTP_PORT );
			}
		}
		catch ( SocketException e )
		{
			LOG.error( e.getMessage(), e );
			throw new RuntimeException( "Couldn't contact time server" );
		}
	}

	public static void establishInstance()
	{
		establishInstance( (InetAddress) null );
	}

	public static void establishInstance( InetAddress timeServerAddress )
	{
		if ( ( instance_ == null ) || !( instance_ instanceof SyncedTimer ) )
		{
			establishInstance( new SyncedTimer( timeServerAddress ) );
		}
	}

	public static void setInstance()
	{
		setInstance( (InetAddress) null );
	}

	public static void setInstance( InetAddress timeServerAddress )
	{
		setInstance( new SyncedTimer( timeServerAddress ) );
	}

	public long getTimeInMillis()
	{
		return SyncedTime.instance().getNow();
	}

	//default number of time polls to make to SNTP server
	public static final int NUM_POLLS = 20;

	//use a port above 1024 so we can server off *nix machines without being
	//root
	public static final int SAFE_NTP_PORT = 2727;

	public TimeProvider timeProvider_;
}
