/*
 * $Id: Terminator.java,v 1.5 2003/09/06 21:49:23 wurp Exp $
 */

package com.navtools.util;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Category;

public class Terminator
{
	public static final Category LOG =
	Category.getInstance( Terminator.class.getName() );

	protected Terminator()
	{
		//create a new thread to kill this app when a file called 'killme'
		//or 'killme.txt' is created in the directory from which the app
		//was started
		Thread killer = new Thread( "killer" )
		{
			public void run()
			{
				File killer1 = new File( "killme" );
				File killer2 = new File( "killme.txt" );
				while ( true )
				{
					if ( killer1.exists() || killer2.exists() )
					{
						String killString =
						"killme file found; deleting and " +
						"calling terminator.exit(-13)";
						System.err.println( killString );
						LOG.warn( killString );

						killer1.delete();
						killer2.delete();
						Terminator.instance().exit( -13 );
					}

					try
					{
						Thread.currentThread().sleep( KILL_CHECK_INTERVAL );
					}
					catch ( Exception e )
					{
					}
				}
			}
		};

		killer.setDaemon( true );
		killer.start();
	}

	public static Terminator instance()
	{
		if ( instance_ == null )
		{
			instance_ = new Terminator();
		}

		return instance_;
	}

	public void runOnExit( VoidFunction vf )
	{
		jobsToRunOnExit_.add( 0, vf );
	}

	public void exit( int status )
	{
		runExitJobs();
		System.gc();
		System.runFinalization();
		System.exit( status );
	}

	public void finalize()
	{
		runExitJobs();
	}

	public void runExitJobs()
	{
		Iterator iter = jobsToRunOnExit_.iterator();
		while ( iter.hasNext() )
		{
			VoidFunction vf = (VoidFunction) iter.next();
			vf.execute();
		}
	}

	protected List jobsToRunOnExit_ = new LinkedList();

	protected static Terminator instance_;

	//check every 5 seconds for a killme or killme.txt file
	public static final int KILL_CHECK_INTERVAL = 5000;

	//com.navtools.networking.armi.networking.test code follows
	public static void main( String[] args )
	{
	}
}
