/*
 * $Id: ThreadLocalInstance.java,v 1.2 2003/09/06 21:49:23 wurp Exp $
 */

package com.navtools.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Category;

public abstract class ThreadLocalInstance
{
	public static final Category LOG =
	Category.getInstance( ThreadLocalInstance.class.getName() );

	public Object get()
	{
		Thread currThread = Thread.currentThread();

		//TODO: This may cause rare occasions in which the wrong instance
		//or a null instance is retrieved since we don't synchronize the get
		//with the put.  It is a major performance drain to synchronize every
		//get, so I'm leaving it like this for now... may turn out to be a
		//mistake ;)
		Object retval = threadToInstanceMap_.
		get( currThread );

		if ( retval == null )
		{
			synchronized ( threadToInstanceMap_ )
			{
				retval = make();
				threadToInstanceMap_.put( currThread, retval );
			}
		}

		init( retval );

		return retval;
	}

	/**
	 * subclasses must override this method to make a new instance
	 * of the object to be threadlocalized.
	 */
	public abstract Object make();

	/**
	 * subclasses can override this to initialize the object each
	 * time get() is called, if desired.
	 */
	public void init( Object obj )
	{
	}

	private Map threadToInstanceMap_ = new HashMap();
}
