/*
 * $Id: TimeProvider.java,v 1.3 2003/09/21 03:33:24 wurp Exp $
 */

package com.navtools.util;

import org.apache.log4j.Category;

public abstract class TimeProvider
{
	public static final Category LOG =
	Category.getInstance( TimeProvider.class.getName() );


	public static TimeProvider getInstance()
	{
		TimeProvider timeProvider = null;

		//Windows has crappy time resolution in java, so we use a custom
		//native method to get the time
		if ( System.getProperty( "os.name" ).indexOf( "Windows" ) != -1 )
		{
			LOG.info( "Using windows time provider" );
			try
			{
				timeProvider = (TimeProvider) Class.forName( "com.navtools.util.WindowsTimeProvider" ).newInstance();
			}
			catch ( Exception e )
			{
				LOG.error( "constructing WindowsTimeProvider", e );
			}
		}
		else
		{
			LOG.info( "Using system time provider" );
			timeProvider = new SystemTimeProvider();
		}

		return timeProvider;
	}


	public abstract long currentTimeMillis();
}

