/*
 * $Id: TimedEvent.java,v 1.2 2003/09/06 21:49:23 wurp Exp $
 */

package com.navtools.util;

//note that it is not valid to add a single instance of TimedEvent
//to the Timer multiple times.

import org.apache.log4j.Category;

public class TimedEvent
{
	public static final Category LOG =
	Category.getInstance( TimedEvent.class.getName() );

	public TimedEvent( float periodInSeconds, boolean isRepeating, VoidFunction action )
	{
		period_ = (long) ( periodInSeconds * 1000 );
		isRepeating_ = isRepeating;
		action_ = action;
	}

	public void trigger()
	{
		action_.execute();
	}

	public final long getPeriod()
	{
		return getPeriodInMillis() * 1000;
	}

	public long getPeriodInMillis()
	{
		return period_;
	}

	public boolean isRepeating()
	{
		return isRepeating_;
	}

	public VoidFunction getAction()
	{
		return action_;
	}

	public void setNextScheduledTime( long nst )
	{
		nextScheduledTime_ = nst;
	}

	public long getNextScheduledTime()
	{
		return nextScheduledTime_;
	}

	protected long period_;
	protected long nextScheduledTime_ = -1;
	protected boolean isRepeating_;
	protected VoidFunction action_;
}
