/*
 * $Id: Timestamp.java,v 1.1 2003/09/06 21:49:23 wurp Exp $
 * $Log: Timestamp.java,v $
 * Revision 1.1  2003/09/06 21:49:23  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:21  gergiskhan
 * no message
 *
 * Revision 1.4  2003/06/20 17:31:49  wurp
 * Added before() and END_OF_TIME
 *
 * Revision 1.3  2003/04/04 03:35:04  wurp
 * Added compareTo to Timestamp
 *
 * Revision 1.2  2002/11/11 04:15:46  wurp
 * Fixed executeWithTimeout (had some issues with interrupting threads and not clearing status)
 * Added ready() to BlockingQueue.
 * Added stop(), isStopped() to Job
 *
 * Revision 1.1  2002/04/15 03:43:57  wurp
 * Cache id to method mappings in text file
 * Fix sporadic bug in acquiring ids (timing bug in ClassAndMethodTable)
 * Fixed bug with methods having no arguments using ReturnValues
 * Added disconnectionListener
 *
 * Revision 1.6  2001/09/30 06:43:48  wurp
 * Made changes necessary to allow multiple mobs to login
 * fixed 'move to 0,0 upon death' bug
 * introduced client vs. server positional bug; will fix tomorrow.  too tired.
 *
 */

package com.navtools.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

import com.navtools.serialization.DataStreamable;
import org.apache.log4j.Category;

public class Timestamp implements Serializable, Cloneable, DataStreamable, Comparable
{
	public static final Category LOG =
	Category.getInstance( Timestamp.class.getName() );

	public static final Timestamp END_OF_TIME = new Timestamp( Long.MAX_VALUE );

	public long serverTimestamp;

	public Object clone()
	{
		Timestamp retval = null;
		try
		{
			retval = (Timestamp) super.clone();
		}
		catch ( CloneNotSupportedException e )
		{
			LOG.error( "clone()", e );
		}

		return retval;
	}

	/**
	 * Constructor creating a timestamp representing the current synced time.
	 */
	public Timestamp()
	{
		serverTimestamp = SyncedTime.instance().getNow();
	}

	public static Timestamp make()
	{
		return new Timestamp();
	}

	/**
	 * Constructor creating a Timestamp representing the time handed in.
	 * The time is interpreted as the results from a
	 * SyncedTime.instance().getNow() call, and is the number of milliseconds
	 * since some established milestone time.
	 *
	 * @param milliseconds the time that this Timestamp represents
	 */
	public Timestamp( long milliseconds )
	{
		serverTimestamp = milliseconds;
	}

	/**
	 * Sets the internal time of this timestamp to now.
	 */
	public void setToNow()
	{
		serverTimestamp = SyncedTime.instance().getNow();
	}

	/**
	 * Returns the number of milliseconds that elapsed between this timestamp
	 * and the one passed in.  If the one passed in is later, the returned
	 * value is positive.  If it is earlier, the returned value is negative.
	 * @return elapsed milliseconds between two timestamps
	 */
	public long elapsedMillis( Timestamp later )
	{
		return later.serverTimestamp - serverTimestamp;
	}

	/**
	 * used to calculate the number of milliseconds that have elapsed since
	 * the server issued the timestamp.  used in predicting object location
	 * based on vector and velocity, so it must be accurate, and time adjusted
	 * for client time versus server time.
	 */

	public long timeElapsed()
	{
		return SyncedTime.instance().getNow() - serverTimestamp;
	}

	public void readFrom( DataInputStream dis ) throws IOException
	{
		serverTimestamp = dis.readLong();
	}

	public void writeTo( DataOutputStream dos ) throws IOException
	{
		dos.writeLong( serverTimestamp );
	}

	public void set( Timestamp ts )
	{
		serverTimestamp = ts.serverTimestamp;
	}

	public long getMillis()
	{
		return serverTimestamp;
	}

	public final boolean before( Timestamp otherTime )
	{
		return before( otherTime.getMillis() );
	}

	public boolean before( long millis )
	{
		return getMillis() < millis;
	}

	public int compareTo( Object rhs )
	{
		return (int) ( serverTimestamp - ( (Timestamp) rhs ).serverTimestamp );
	}

	public String toString()
	{
		return "Timestamp: " + serverTimestamp;
	}
}
