/*
 * $Id: Triplet.java,v 1.2 2003/09/06 21:49:23 wurp Exp $
 *
 * $Log: Triplet.java,v $
 * Revision 1.2  2003/09/06 21:49:23  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:21  gergiskhan
 * no message
 *
 * Revision 1.1.1.1  2001/06/26 00:55:57  wurp
 * importing initial rev of source
 *
 * Revision 1.3  2001/06/22 03:06:02  wurp
 * More log4j changes
 *
 * Revision 1.2  2001/06/20 02:58:53  wurp
 * Updated to log4j.  Added default ctor to CharacterInfo
 *
 * Revision 1.1  2001/04/01 06:37:21  wurp
 * Finally fixed new networking system to handle multiple clients (ouch!).
 * Had to add support for arbitrary number of instances shared for each interface.
 *
 */

package com.navtools.util;

import java.io.Serializable;

import org.apache.log4j.Category;

public class Triplet implements Serializable
{
	public static final Category LOG =
	Category.getInstance( Triplet.class.getName() );


	public Triplet( Object first, Object second, Object third )
	{
		first_ = first;
		second_ = second;
		third_ = third;
	}


	public boolean equals( Object obj )
	{
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "In equals" );
		}

		if ( obj instanceof Triplet )
		{
			Triplet rhs = (Triplet) obj;
			if ( first_.equals( rhs.first_ ) && second_.equals( rhs.second_ ) &&
			     third_.equals( rhs.third_ ) )
			{
				return true;
			}
		}

		return false;
	}


	//use bitwise xor of first & second for hashcode, since bitwise
	//xor doesn't care about the order of the args, and it also
	//preserves as much uniqueness in the hashcode as possible
	public int hashCode()
	{
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "In hashcode" );
		}
		return first_.hashCode() ^ second_.hashCode() ^ third_.hashCode();
	}


	public String toString()
	{
		return first_ + ", " + second_ + ", " + third_;
	}


	public Object getFirst()
	{
		return first_;
	}


	public Object getSecond()
	{
		return second_;
	}


	public Object getThird()
	{
		return third_;
	}


	Object first_;
	Object second_;
	Object third_;


	//com.navtools.networking.armi.networking.test code follows
	public static void main( String[] args ) throws Exception
	{
		/*  fix for Triplet
		String a = "Hi";
		String b = "H";
		b += "i";
		String c = "Hello";
		String d = "Bye";

		Triplet upab = new Triplet(a,b);
		Triplet upac = new Triplet(a,c);
		Triplet upca = new Triplet(c,a);
		Triplet upba = new Triplet(b,a);
		Triplet upbc = new Triplet(b,c);
		Triplet upcb = new Triplet(c,b);

		//leftover com.navtools.networking.armi.networking.test code from when I copied this from UnorderedTriplet
		//          //since unorderedpair does a == on the values, but doesn't care about
		//          //the order of the values, upab == upba; upac != upca; upba != upca
		//          //upbc == upcb; upbc != upac; upbc != upca
		//          verify("!upab.equals(upba)", !upab.equals(upba));
		//          verify("upac.equals(upca)", upac.equals(upca));
		//          verify("!upba.equals(upca)", !upba.equals(upca));
		//          verify("upbc.equals(upcb)", upbc.equals(upcb));
		//          verify("!upbc.equals(upac)", !upbc.equals(upac));
		//          verify("!upbc.equals(upca)", !upbc.equals(upca));

		//          Map map = new HashMap();
		//          //since hashmap uses equals to determine if a key is valid or not,
		//          verify("original size == 0", map.size() == 0);
		//          map.put(upab,"1");
		//          verify("upab not dupe", map.size() == 1);

		//          map.put(upba,"1.1");
		//          verify("upba is dupe", map.size() == 1);

		//          map.put(upbc,"2");
		//          verify("upbc is not dupe", map.size() == 2);

		//          map.put(upcb,"2.1");
		//          verify("upbc is dupe", map.size() == 2);

		//          map.put(upca,"3");
		//          verify("upca is not dupe", map.size() == 3);

		//          map.put(upac,"3.1");
		//          verify("upac is dupe", map.size() == 3);

		//          Iterator iter = map.asList().iterator();
		//          while(iter.hasNext())
		//              {
		//                  System.out.println(iter.next());
		//              }
		*/
	}


	public static void verify( String desc, boolean valid )
	{
		if ( !valid )
		{
			System.err.println( "Error, not valid: " + desc );
		}
	}
}
