/*
 * $Id: WindowsTimeProvider.java,v 1.2 2003/09/06 21:49:23 wurp Exp $
 * $Log: WindowsTimeProvider.java,v $
 * Revision 1.2  2003/09/06 21:49:23  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:21  gergiskhan
 * no message
 *
 * Revision 1.1  2002/04/15 03:43:57  wurp
 * Cache id to method mappings in text file
 * Fix sporadic bug in acquiring ids (timing bug in ClassAndMethodTable)
 * Fixed bug with methods having no arguments using ReturnValues
 * Added disconnectionListener
 *
 * Revision 1.3  2001/10/30 08:55:24  wurp
 * Changed all uses of WindowsTimeProvider to get an OS independent time provider
 * removed rmic of cosm.loginserver.ClientProxy
 *
 * Revision 1.2  2001/06/20 02:58:53  wurp
 * Updated to log4j.  Added default ctor to CharacterInfo
 *
 * Revision 1.1  2001/04/08 23:43:38  wurp
 * Adding accurate timer for windows.  Requires native code.  Will have to implement
 * alternative systems when porting to Linux, MacOS, etc.
 *
 */

package com.navtools.util;

import org.apache.log4j.Category;

public class WindowsTimeProvider extends TimeProvider
{
	public static final Category LOG =
	Category.getInstance( WindowsTimeProvider.class.getName() );

	static
	{
		//load the dll that implements currentTimeMillis in C code
		System.loadLibrary( "TimeImpl" );
	}

	public native long currentTimeMillis();

	public static void main( String[] args )
	{
		TimeProvider tp = new WindowsTimeProvider();

		for ( int i = 0; i < 1000; ++i )
		{
			System.out.println( "WTP: " + tp.currentTimeMillis() );
			System.out.println( "JTP: " + System.currentTimeMillis() );
		}
	}
}


