package com.navtools.util;

import org.apache.log4j.Category;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

import java.io.InputStream;
import java.io.OutputStream;

import java.util.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class XMLUtil {
    public static final Category LOG = Category.getInstance(XMLUtil.class.getName());
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder db;

    public static DocumentBuilder getDocumentBuilder() {
        if( db == null ) {
            try {
                db = dbf.newDocumentBuilder();
            }
            catch(Exception e) {
                LOG.error("", e);
            }
        }

        return db;
    }

    public static Document newDocument() {
        return getDocumentBuilder().newDocument();
    }

    public static Document getDocument(InputStream is) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(is);
        } catch (Exception e) {
            LOG.error("Couldn't create Document from stream", e);
        }

        return document;
    }

    public static void saveDocument(Document document, OutputStream out)
        throws TransformerException {
        TransformerFactory tfactory=TransformerFactory.newInstance();

        Transformer transformer = tfactory.newTransformer();

        transformer.setOutputProperty("indent","yes");

        transformer.transform(new DOMSource(document.getDocumentElement()),
                              new StreamResult(out));
    }

    public static Element createSubelement(Element parent, String subElemName) {
        Document doc = parent.getOwnerDocument();
        Element retval = doc.createElement(subElemName);
        parent.appendChild(retval);

        return retval;
    }

    public static String[] getTexts(Element baseElem, String subElem) {
        List elems = getChildren(baseElem, subElem);
        String[] retval = new String[elems.size()];

        for (int i = 0; i < retval.length; ++i) {
            retval[i] = ((Element) elems.get(i)).getNodeValue();
        }

        return retval;
    }

    public static String getText(Element baseElem, String subElem) {
        String[] texts = getTexts(baseElem, subElem);

        if (texts.length == 0) {
            return null;
        } else {
            return texts[0];
        }
    }

    public static Element getChild(Element elem, String name) {
        List retval = new ArrayList();
        getChildren(retval, elem, name);

        return retval.iterator().hasNext() ? (Element) retval.iterator().next()
                                           : null;
    }

    public static List getChildren(Element elem, String name) {
        List retval = new ArrayList();
        getChildren(retval, elem, name);

        return retval;
    }

    public static List getChildren(List retval, Element elem, String name) {
        int firstSlash = name.indexOf("/");
        String directChild;
        String restOfKeyName = null;

        if (firstSlash == -1) {
            directChild = name;
        } else {
            directChild = name.substring(0, firstSlash);
            restOfKeyName = name.substring(firstSlash + 1);
        }

        List directChildren = getDirectChildren(elem, directChild);

        if ((restOfKeyName != null) && !restOfKeyName.equals("")) {
            Iterator iter = directChildren.iterator();

            while (iter.hasNext()) {
                Element curr = (Element) iter.next();
                getChildren(retval, curr, restOfKeyName);
            }
        } else {
            retval.addAll(directChildren);
        }

        return retval;
    }

    public static List getDirectChildren(Element elem, String name) {
        List retval;

        name = name.trim();

        int bracketIdx = name.indexOf("[");

        if (bracketIdx == -1) {
            retval = new ArrayList();

            NodeList nl = elem.getElementsByTagName(name);

            for (int i = 0; i < nl.getLength(); ++i) {
                retval.add(nl.item(i));
            }
        } else { //name is of format "name[idx]"

            //the real name is the part that comes before the [
            String realName = name.substring(0, bracketIdx);

            //the string representing the index is what comes between the []
            String idxString = name.substring(bracketIdx + 1,
                    name.length() - bracketIdx - 2);
            int idx = Integer.parseInt(idxString);

            //return a list containing only the idx'th element that has the
            //specified real name
            retval = new ArrayList();
            retval.add(elem.getElementsByTagName(realName).item(idx));
        }

        return retval;
    }
}
