/*
 * Decompiled with CFR 0.152.
 */
package updaters;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.DesertGreen;
import com.jgoodies.looks.plastic.theme.SkyBlue;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;
import updaters.AutoUpdater;
import updaters.JCopy;
import updaters.SplashWindow;
import updaters.VersionManifest;

public class MekWarsAutoUpdate {
    private static final String CONFIG_FILE = "./data/mwconfig.txt";
    private static final String logFileName = "./logs/mekwarsautoupdate.log";
    private static final String VERSION = "0.7";
    private Properties config = null;
    private SplashWindow splash = null;

    public static void main(String[] args) {
        if (logFileName != null) {
            try {
                PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFileName), 64));
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.err.println("Running MekWarsAutoUpdate: 0.7");
        System.err.flush();
        new MekWarsAutoUpdate(args);
        System.exit(0);
    }

    public MekWarsAutoUpdate(String[] args) {
        this.loadConfigs();
        if (args.length < 1) {
            Vector<String> selections = new Vector<String>();
            selections.add("Update");
            selections.add("Create Manifest");
            JComboBox combo = new JComboBox(selections);
            combo.setEditable(false);
            JOptionPane jop = new JOptionPane(combo, 3, 2);
            JDialog dlg = jop.createDialog(null, "Select Update Option");
            combo.grabFocus();
            combo.getEditor().selectAll();
            dlg.setVisible(true);
            int selection = combo.getSelectedIndex();
            int value = (Integer)jop.getValue();
            if (value == 2) {
                System.exit(0);
            }
            if (selection == 0) {
                args = new String[]{"PLAYER"};
            } else {
                VersionManifest.createListFile();
                JOptionPane.showMessageDialog(null, "Manifest Created");
                System.exit(0);
            }
        }
        if (args[0].equals("PLAYER")) {
            this.splash = new SplashWindow(null);
        }
        try {
            String url;
            System.out.println("Starting Update");
            System.out.flush();
            if (this.splash != null) {
                this.splash.setStatus(this.splash.STATUS_FETCHINGDATA);
            }
            if ((url = this.config.getProperty("UPDATEURL")) == null || url.trim().length() < 8 || url.equals("-1")) {
                System.out.println("Unable to find UPDATEURL in the .\\mwconfig.txt");
                System.out.flush();
                System.exit(0);
            }
            AutoUpdater.update(".", url, this.splash);
            System.out.println("Update Finished");
            System.out.flush();
            System.out.println("Starting Updatefix");
            System.out.flush();
            this.copyTempFiles("./update-tmp");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.splash != null) {
            this.splash.dispose();
        }
        try {
            System.out.println("Restarting");
            System.out.flush();
            Runtime runTime = Runtime.getRuntime();
            String[] call = new String[]{"java", "-jar", "MekWarsClient.jar"};
            runTime.exec(call);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void copyTempFiles(String path) {
        File[] files;
        JCopy copier = new JCopy();
        File folder = new File(path);
        for (File file : files = folder.listFiles()) {
            if (file.isDirectory()) {
                this.copyTempFiles(file.toString());
                continue;
            }
            try {
                String newFile = "." + file.toString().substring(12);
                copier.copyFile(file, new File(newFile));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void loadConfigs() {
        this.config = new Properties();
        try {
            File configfile = new File(CONFIG_FILE);
            FileInputStream fis = new FileInputStream(configfile);
            this.config.load(fis);
            fis.close();
        }
        catch (Exception ex) {
            System.err.println("Unable to load config file: ./data/mwconfig.txt");
            System.err.flush();
            ex.printStackTrace();
            return;
        }
        try {
            Object LAF = new KunststoffLookAndFeel();
            if (this.config.getProperty("LOOKANDFEEL").equals("metal")) {
                LAF = new MetalLookAndFeel();
            } else if (this.config.getProperty("LOOKANDFEEL").equals("motif")) {
                LAF = new MotifLookAndFeel();
            } else if (this.config.getProperty("LOOKANDFEEL").equals("metouia")) {
                LAF = new MetouiaLookAndFeel();
            } else if (this.config.getProperty("LOOKANDFEEL").equals("plastic")) {
                PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)new DesertGreen());
                LAF = new Plastic3DLookAndFeel();
            } else if (this.config.getProperty("LOOKANDFEEL").equals("plasticxp")) {
                LAF = new PlasticXPLookAndFeel();
            } else if (this.config.getProperty("LOOKANDFEEL").equals("plastic3d")) {
                PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)new SkyBlue());
                LAF = new Plastic3DLookAndFeel();
            } else if (this.config.getProperty("LOOKANDFEEL").equals("jwindows")) {
                LAF = new WindowsLookAndFeel();
            }
            UIManager.setLookAndFeel((LookAndFeel)LAF);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.flush();
        }
    }
}

