/*
 * Decompiled with CFR 0.152.
 */
package updaters;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import sun.tools.jar.Main;
import updaters.AutoUpdater;
import updaters.FileDiff;
import updaters.FileInfo;
import updaters.Repository;
import updaters.Version;
import updaters.utils.IOUtil;

public class ReplaceFileDiff
extends FileDiff {
    private boolean tempFileUpToDate_ = false;
    public String localFileOffset_;
    public String remoteFileOffset_;
    public Version version_;
    public Main jar_ = new Main(System.out, System.out, "jar");

    public ReplaceFileDiff(FileInfo fileInfo, Version version) {
        this.localFileOffset_ = fileInfo.getLocalOffset();
        this.remoteFileOffset_ = fileInfo.getRemoteOffset();
        this.version_ = version;
        System.err.println("Building replace file diff for local " + this.localFileOffset_ + ", remote " + this.remoteFileOffset_);
    }

    public void apply(AutoUpdater updater, Repository repository) {
        updater.setProgressNote("Updating " + this.localFileOffset_);
        try {
            File targetParent;
            File destFileParent;
            File destFile;
            InputStream in = this.version_.getBinaryFile(this.remoteFileOffset_);
            StringTokenizer toker = new StringTokenizer(this.localFileOffset_, "!");
            String fileToken = toker.nextToken();
            String fileCopyTarget = updater.getLocalDir() + File.separator + fileToken;
            String destFileName = updater.getLocalDir() + File.separator + "update-tmp" + File.separator + fileToken;
            if (this.tempFileUpToDate_) {
                return;
            }
            File tmpDirFile = new File(updater.getLocalDir() + File.separator + "update-tmp");
            if (!tmpDirFile.exists()) {
                tmpDirFile.mkdirs();
            }
            if ((destFile = new File(destFileName)).isDirectory()) {
                destFile.delete();
            }
            if (!(destFileParent = new File(destFile.getParent())).exists()) {
                destFileParent.mkdirs();
            }
            if (!(targetParent = new File(new File(fileCopyTarget).getParent())).exists()) {
                targetParent.mkdirs();
            }
            if (toker.hasMoreTokens()) {
                destFile.createNewFile();
                String offsetWithinJar = toker.nextToken();
                File tempDir = File.createTempFile("autoupdate", ".tmp");
                tempDir.delete();
                File tempFile = new File(tempDir.getAbsolutePath() + File.separator + offsetWithinJar);
                new File(tempFile.getParent()).mkdirs();
                FileOutputStream out = new FileOutputStream(tempFile);
                IOUtil.copy(in, out);
                ((OutputStream)out).close();
                this.jar_.run(new String[]{"uf", destFileName, "-C", tempDir.getAbsolutePath(), offsetWithinJar});
                tempFile.delete();
                IOUtil.removeDirectoriesBetween(new File(tempDir.getParent()), new File(tempFile.getParent()));
            } else {
                try {
                    FileOutputStream out = new FileOutputStream(destFileName);
                    IOUtil.copy(in, out);
                    ((OutputStream)out).close();
                }
                catch (FileNotFoundException e) {
                    System.err.println(destFileName + " in use.  Writing to alternate file name.  Must run updatefix script after autoupdate process completes.");
                    String newDestFileName = destFileName + ".fiu";
                    FileOutputStream out = new FileOutputStream(newDestFileName);
                    IOUtil.copy(in, out);
                    ((OutputStream)out).close();
                }
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTempFileUpToDate(boolean isLatest) {
        this.tempFileUpToDate_ = isLatest;
    }
}

