/*
 * Decompiled with CFR 0.152.
 */
package updaters;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import updaters.FileDiff;
import updaters.FileInfo;
import updaters.ReplaceFileDiff;
import updaters.Version;
import updaters.utils.IOUtil;

public class Repository {
    String urlBase_;

    public Repository(String urlBase) {
        this.urlBase_ = Repository.fixURL(urlBase) + "/";
    }

    public Version getLatestVersion() throws IOException {
        System.err.println("Getting latest version from LatestVersion.ver");
        BufferedReader verFile = this.getCharFile("LatestVersion.ver");
        return new Version(this, verFile.readLine());
    }

    public FileDiff getDiff(FileInfo fileDiffInfo, Version version) {
        return new ReplaceFileDiff(fileDiffInfo, version);
    }

    public BufferedReader getCharFile(String filename) throws IOException {
        return new BufferedReader(new InputStreamReader(this.getBinaryFile(filename)));
    }

    public InputStream getBinaryFile(String filename) throws IOException {
        filename = Repository.fixURL(filename);
        String url = IOUtil.delimitURL(IOUtil.fixJarURL(this.urlBase_ + filename));
        System.err.println("Retrieving url " + url + " from server");
        BufferedInputStream retval = new BufferedInputStream(new URL(url).openStream());
        return retval;
    }

    public static String fixURL(String url) {
        return IOUtil.trimFileSeparator(url);
    }
}

