/*
 * Decompiled with CFR 0.152.
 */
package updaters;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import updaters.AnimationThread;

public class SplashWindow {
    public JWindow splashWindow;
    private boolean continueAnimating = true;
    private JLabel imageLabel;
    private JLabel versionLabel;
    private AnimationThread animator;
    private int currentStatus = 0;
    public final int STATUS_INITIALIZING = 0;
    public final int STATUS_FETCHINGDATA = 1;
    public final int STATUS_CONSTRUCTINGGUI = 2;
    public final int STATUS_CONNECTING = 3;
    public final int STATUS_INPUTWAIT = 4;
    public final int STATUS_DATAERROR = 5;
    public final int STATUS_CONNECTFAILED = 6;

    public SplashWindow(JFrame owner) {
        this.splashWindow = new JWindow(owner);
        ImageIcon splashImage = null;
        boolean useJPGImage = new File("data/images/mekwarssplash.jpg").exists();
        splashImage = useJPGImage ? new ImageIcon("data/images/mekwarssplash.jpg") : new ImageIcon("data/images/mekwarssplash.gif");
        Image tempImage = splashImage.getImage().getScaledInstance(350, 350, 4);
        splashImage.setImage(tempImage);
        this.imageLabel = new JLabel("<HTML><CENTER>Updating MekWars Client<br>Please Wait</CENTER></HTML>", splashImage, 0);
        this.imageLabel.setVerticalTextPosition(3);
        this.imageLabel.setHorizontalTextPosition(0);
        this.imageLabel.setVerticalTextPosition(3);
        this.imageLabel.setIconTextGap(6);
        this.versionLabel = new JLabel("<HTML><CENTER><b>Initializing<br>\u00a5</b></CENTER></HTML>", 0);
        JPanel windowPanel = new JPanel();
        this.imageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        this.versionLabel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        windowPanel.setLayout(new BoxLayout(windowPanel, 1));
        windowPanel.setBackground(Color.WHITE);
        windowPanel.add(this.imageLabel);
        windowPanel.add(new JSeparator());
        windowPanel.add(this.versionLabel);
        windowPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        this.splashWindow.getContentPane().add(windowPanel);
        this.splashWindow.getContentPane().setBackground(Color.WHITE);
        this.splashWindow.pack();
        this.splashWindow.setLocationRelativeTo(null);
        this.splashWindow.setVisible(true);
        this.animator = new AnimationThread(this);
        this.animator.start();
    }

    public void dispose() {
        this.continueAnimating = false;
        this.splashWindow.setVisible(false);
        this.splashWindow.dispose();
    }

    public boolean shouldAnimate() {
        return this.continueAnimating;
    }

    public JLabel getImageLabel() {
        return this.versionLabel;
    }

    public void setStatus(int i) {
        this.currentStatus = i;
    }

    public int getStatus() {
        return this.currentStatus;
    }

    public AnimationThread getAnimator() {
        return this.animator;
    }
}

