/*
 * Decompiled with CFR 0.152.
 */
package updaters;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import updaters.AutoUpdater;
import updaters.FileInfo;
import updaters.ProcessLogger;
import updaters.utils.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionManifest {
    protected List<FileInfo> fileList_ = new ArrayList<FileInfo>();
    protected List<String> dirsToCleanUp_ = new ArrayList<String>();
    public static String separator = "*";

    public VersionManifest(BufferedReader manifestStream) {
        String line = null;
        try {
            while ((line = manifestStream.readLine()) != null) {
                if (line.indexOf("<CLEANUP>") == -1) {
                    this.fileList_.add(new FileInfo(line));
                    continue;
                }
                StringTokenizer toker = new StringTokenizer(line, separator);
                toker.nextToken();
                this.dirsToCleanUp_.add(toker.nextToken());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<FileInfo> getDiffInfos(AutoUpdater updater) {
        System.err.println("Getting diff infos");
        ArrayList<FileInfo> retval = new ArrayList<FileInfo>();
        Iterator<FileInfo> iter = this.fileList_.iterator();
        long tempCRC = 0L;
        while (iter.hasNext()) {
            FileInfo file = iter.next();
            try {
                StringBuilder tempManifest = new StringBuilder("./");
                tempManifest.append("update-tmp");
                tempManifest.append(File.separator);
                tempManifest.append(IOUtil.removeLeadingDotSlash(file.getLocalOffset()));
                tempManifest.append(separator);
                tempManifest.append(file.getRemoteOffset());
                tempManifest.append(separator);
                tempManifest.append(file.getCRC32());
                tempCRC = 0L;
                try {
                    FileInfo tempFile = new FileInfo(tempManifest.toString());
                    InputStream tempIs = updater.getLocalFileStream(tempFile);
                    tempCRC = IOUtil.getCRC32(tempIs);
                    tempIs.close();
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("File " + file.getLocalOffset() + " is not in the temp directory.");
                }
                InputStream is = updater.getLocalFileStream(file);
                long localCRC = IOUtil.getCRC32(is);
                is.close();
                if (localCRC != file.getCRC32()) {
                    System.err.println("Noting difference between remote file " + file.getRemoteOffset() + " and local file " + file.getLocalOffset());
                    if (tempCRC == file.getCRC32()) {
                        file.setTempFileUpToDate(true);
                        System.err.println("The file " + file.getLocalOffset() + " is different, but there is an up to date " + " file in the tmp directory.");
                    } else {
                        file.setTempFileUpToDate(false);
                    }
                    retval.add(file);
                    continue;
                }
                System.err.println("Remote file " + file.getRemoteOffset() + " and local file " + file.getLocalOffset() + " appear to be the same.");
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + file.getLocalOffset() + " doesn't exist locally.  Retrieving.");
                if (tempCRC == file.getCRC32()) {
                    file.setTempFileUpToDate(true);
                    System.err.println("File " + file.getLocalOffset() + " doesn't exist locally, but it is up " + "to date in the temp directory, no need to download.");
                } else {
                    file.setTempFileUpToDate(false);
                }
                retval.add(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    public List<String> getClientFileStructure() {
        System.err.println("Getting client file structure");
        ArrayList<String> retval = new ArrayList<String>();
        for (FileInfo file : this.fileList_) {
            retval.add(file.getLocalOffset());
        }
        return retval;
    }

    public List<String> getDirectoriesToCleanUp() {
        return this.dirsToCleanUp_;
    }

    protected static void createListFile() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setCurrentDirectory(new File("./"));
        fc.setApproveButtonText("Create List");
        fc.setApproveButtonToolTipText("<html>Select the folder where the file list<br>and manifest will be crated.</html>");
        int selection = fc.showOpenDialog(null);
        if (selection != 0) {
            return;
        }
        String rootDir = fc.getSelectedFile().getPath() + File.separatorChar;
        String outFileName = rootDir + "files.txt";
        try {
            File[] listFiles;
            FileOutputStream out = new FileOutputStream(outFileName);
            PrintStream ps = new PrintStream(out);
            for (File file : listFiles = new File(rootDir).listFiles()) {
                VersionManifest.printOutFiles(ps, file, rootDir);
            }
            ps.flush();
            out.flush();
            ps.close();
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        VersionManifest.createManifestFile(outFileName);
    }

    private static void printOutFiles(PrintStream ps, File file, String root) {
        try {
            if (file.isDirectory()) {
                File[] listFiles;
                for (File newFile : listFiles = file.listFiles()) {
                    VersionManifest.printOutFiles(ps, newFile, root);
                }
            } else {
                String path = file.getAbsolutePath();
                int index = path.indexOf(root);
                if (index > -1) {
                    path = "./" + path.substring(index + root.length());
                }
                ps.println(path);
                ps.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        String line;
        BufferedReader manifestList = new BufferedReader(new FileReader(args[0]));
        while ((line = manifestList.readLine()) != null) {
            long crc32 = IOUtil.getCRC32(new BufferedInputStream(new FileInputStream(line)));
            System.out.println(line + separator + line + separator + crc32);
        }
    }

    private static void createManifestFile(String outPutFileName) {
        try {
            String line;
            BufferedReader manifestList = new BufferedReader(new FileReader(outPutFileName));
            String manifestFileName = outPutFileName.substring(0, outPutFileName.indexOf("files.txt")) + "Manifest.txt";
            FileOutputStream out = new FileOutputStream(manifestFileName);
            PrintStream ps = new PrintStream(out);
            String newLine = "";
            while ((line = manifestList.readLine()) != null) {
                long crc32 = IOUtil.getCRC32(new BufferedInputStream(new FileInputStream(line)));
                newLine = IOUtil.replaceString(line, "\\", "/");
                ps.println(newLine + separator + newLine + separator + crc32);
            }
            ps.println("<CLEANUP>*./data/mechfiles");
            ps.println("<CLEANUP>*./data/images/units");
            ps.println("<CLEANUP>*./data/images/units/wrecks");
            ps.println("<CLEANUP>*./lib");
            ps.flush();
            out.flush();
            ps.close();
            out.close();
            Runtime runtime = Runtime.getRuntime();
            String[] call = new String[]{"jar", "-cf", "Manifest.txt.jar", "Manifest.txt"};
            Process event = runtime.exec(call);
            ProcessLogger outLogger = new ProcessLogger(event.getInputStream());
            ProcessLogger errLogger = new ProcessLogger(event.getErrorStream());
            outLogger.start();
            errLogger.start();
            event.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

