/*
 * Decompiled with CFR 0.152.
 */
package updaters.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtil {
    public static final int BUFFER_SIZE = 8192;
    public static final byte[] THROWAWAY_BUFFER = new byte[8192];

    public static void copy(Reader in, Writer out) throws IOException {
        int bytesRead;
        char[] buffer = new char[8192];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(String inputFileName, String outputFileName) throws IOException {
        FileInputStream in = new FileInputStream(inputFileName);
        FileOutputStream out = new FileOutputStream(outputFileName);
        IOUtil.copy(in, out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static String[] getLines(String inputFileName) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(inputFileName));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        Iterator iter = lines.iterator();
        int i = 0;
        String[] retval = new String[lines.size()];
        while (iter.hasNext()) {
            retval[i++] = (String)iter.next();
        }
        in.close();
        return retval;
    }

    public static long getCRC32(InputStream is) throws IOException {
        CRC32 crc = new CRC32();
        CheckedInputStream cis = new CheckedInputStream(is, crc);
        while (cis.read(THROWAWAY_BUFFER, 0, THROWAWAY_BUFFER.length) != -1) {
        }
        cis.close();
        return crc.getValue();
    }

    public static String trimLeadingFileSeparator(String url) {
        while (url.endsWith("/") || url.endsWith("\\") || url.endsWith(File.separator)) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String trimTrailingFileSeparator(String url) {
        while (url.startsWith("/") || url.startsWith("\\") || url.startsWith(File.separator)) {
            url = url.substring(1);
        }
        return url;
    }

    public static String trimFileSeparator(String url) {
        url = IOUtil.trimLeadingFileSeparator(url);
        url = IOUtil.trimTrailingFileSeparator(url);
        return url;
    }

    public static void removeDirectoriesBetween(File base, File deep) {
        while (deep.getAbsolutePath().startsWith(base.getAbsolutePath()) && !deep.equals(base)) {
            deep.delete();
            deep = new File(deep.getParent());
        }
    }

    public static List<File> getTree(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        IOUtil.getTree(dir, list);
        return list;
    }

    public static void getTree(File dir, List<File> list) {
        list.add(dir);
        File[] fileList = dir.listFiles();
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                IOUtil.getTree(fileList[i], list);
            }
        }
    }

    public static String[] parseJarURL(String url) {
        ArrayList<String> parts = new ArrayList<String>();
        StringTokenizer toker = new StringTokenizer(url, "!");
        while (toker.hasMoreTokens()) {
            parts.add(toker.nextToken());
        }
        String[] retval = new String[parts.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (String)parts.get(i);
        }
        return retval;
    }

    public static String fixJarURL(String jarURL) {
        if (jarURL.indexOf("!") != -1 && !jarURL.startsWith("jar:")) {
            jarURL = "jar:" + jarURL;
        }
        return jarURL;
    }

    public static String delimitURL(String url) {
        return url.replaceAll(" ", "%20");
    }

    public static String fixPath(String path) {
        String newPath = IOUtil.removeLeadingDotSlash(path);
        if (File.separator.equals("\\")) {
            newPath = newPath.replaceAll("/", "\\");
        } else if (File.separator.equals("/")) {
            newPath = newPath.replaceAll("\\", "/");
        }
        return newPath;
    }

    public static String removeLeadingDotSlash(String path) {
        String newPath = IOUtil.replaceString(path, ".\\", "");
        return IOUtil.replaceString(newPath, "./", "");
    }

    public static void main(String[] args) throws Exception {
        IOUtil.copy(new BufferedInputStream(new URL(args[0]).openStream()), new FileOutputStream(args[1]));
    }

    public static String replaceString(String source, String old, String newstring) {
        String sRet = "";
        if (source != null && old != null && newstring != null) {
            for (int i = 0; i < source.length(); ++i) {
                if (source.length() - i < old.length()) {
                    while (i < source.length()) {
                        sRet = sRet + source.substring(i, i + 1);
                        ++i;
                    }
                    break;
                }
                if (source.substring(i, i + old.length()).equals(old)) {
                    sRet = sRet + newstring;
                    i += old.length() - 1;
                    continue;
                }
                sRet = sRet + source.substring(i, i + 1);
            }
        }
        return sRet;
    }
}

