/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.io.File;
import java.util.GregorianCalendar;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class CMWLogger {
    private static final int rotations = 5;
    private static final int normFileSize = 1000000;
    private static boolean logging = false;
    private static boolean addSeconds = false;
    private static boolean clientlog = false;
    private static File logDir;
    private static Logger clientErrLog;
    private static Logger clientOutputLog;
    private static MMNetFormatter mmnetFormatter;
    private static FileHandler clientErrHandler;
    private static FileHandler clientOutputHandler;

    public CMWLogger(boolean client) {
        this("logs", client);
    }

    public CMWLogger(String s, boolean client) {
        if (logging) {
            return;
        }
        logDir = new File(s);
        if (!logDir.exists()) {
            try {
                if (!logDir.mkdirs()) {
                    System.err.println("WARNING: logging directory cannot be created!");
                    System.err.println("WARNING: disabling log subsystem");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!logDir.isDirectory()) {
            System.err.println("WARNING: logging directory is not a directory!");
            System.err.println("WARNING: disabling log subsystem");
            return;
        }
        if (!logDir.canWrite()) {
            System.err.println("WARNING: cannot write in logging directory!");
            System.err.println("WARNING: disabling log subsystem");
            return;
        }
        mmnetFormatter = new MMNetFormatter();
        try {
            clientErrHandler = new FileHandler(logDir.getPath() + "/error", 1000000, 5, true);
            clientErrHandler.setLevel(Level.INFO);
            clientErrHandler.setFilter(null);
            clientErrHandler.setFormatter(mmnetFormatter);
            clientErrLog = Logger.getLogger("clientErrLogger");
            clientErrLog.setUseParentHandlers(false);
            clientErrLog.addHandler(clientErrHandler);
            clientOutputHandler = new FileHandler(logDir.getPath() + "/log", 1000000, 5, true);
            clientOutputHandler.setLevel(Level.INFO);
            clientOutputHandler.setFilter(null);
            clientOutputHandler.setFormatter(mmnetFormatter);
            clientOutputLog = Logger.getLogger("clientOutputLogger");
            clientOutputLog.setUseParentHandlers(false);
            clientOutputLog.addHandler(clientOutputHandler);
            client = true;
            logging = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clientErrLog(String s) {
        if (clientlog) {
            clientErrLog.info(s);
        }
    }

    public void clientErrLog(int s) {
        clientErrLog.info(Integer.toString(s));
    }

    public void clientErrLog(Exception e) {
        if (clientlog) {
            clientErrLog.warning("[" + e.toString() + "]");
            StackTraceElement[] t = e.getStackTrace();
            for (int i = 0; i < t.length; ++i) {
                clientErrLog.warning("   " + t[i].toString());
            }
        }
    }

    public void clientErrLog(Throwable e) {
        if (clientlog) {
            clientErrLog.warning("[" + e.toString() + "]");
            StackTraceElement[] t = e.getStackTrace();
            for (int i = 0; i < t.length; ++i) {
                clientErrLog.warning("   " + t[i].toString());
            }
        }
    }

    public void clientOutputLog(String s) {
        if (s != null && (s.startsWith("SENT: /signon") || s.indexOf("CONFIRM") > 0)) {
            return;
        }
        if (clientlog) {
            clientOutputLog.info(s);
        }
    }

    public void clientOutputLog(Exception e) {
        if (clientlog) {
            clientOutputLog.warning("[" + e.toString() + "]");
            StackTraceElement[] t = e.getStackTrace();
            for (int i = 0; i < t.length; ++i) {
                clientOutputLog.warning("   " + t[i].toString());
            }
        }
    }

    public void client(boolean b) {
        clientlog = b;
    }

    public class MMNetFormatter
    extends SimpleFormatter {
        public String format(LogRecord record) {
            GregorianCalendar now = new GregorianCalendar();
            now.setTimeInMillis(record.getMillis());
            StringBuilder sb = new StringBuilder();
            sb.append(now.get(1));
            if (now.get(2) < 9) {
                sb.append("0");
            }
            sb.append(now.get(2) + 1);
            if (now.get(5) < 10) {
                sb.append("0");
            }
            sb.append(now.get(5) + " ");
            if (now.get(11) < 10) {
                sb.append("0");
            }
            sb.append(now.get(11) + ":");
            if (now.get(12) < 10) {
                sb.append("0");
            }
            if (addSeconds) {
                sb.append(now.get(12) + ":");
                if (now.get(13) < 10) {
                    sb.append("0");
                }
                sb.append(now.get(13) + "|" + this.formatMessage(record) + "\n");
            } else {
                sb.append(now.get(12) + "|" + this.formatMessage(record) + "\n");
            }
            return sb.toString();
        }
    }
}

