/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CUnit;
import common.AdvanceTerrain;
import common.MMGame;
import common.MegaMekPilotOption;
import common.PlanetEnvironment;
import common.Unit;
import common.campaign.Buildings;
import common.util.UnitUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.CloseClientListener;
import megamek.client.bot.BotClient;
import megamek.client.bot.TestBot;
import megamek.client.bot.ui.AWT.BotGUI;
import megamek.client.ui.AWT.ClientGUI;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Board;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.MapSettings;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.Pilot;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;
import megamek.common.event.GameBoardChangeEvent;
import megamek.common.event.GameBoardNewEvent;
import megamek.common.event.GameEndEvent;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityNewOffboardEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GameNewActionEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerConnectedEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.options.GameOptions;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.options.IOptions;
import megamek.common.options.Option;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BuildingTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientThread
extends Thread
implements GameListener,
CloseClientListener {
    private String myname;
    private String serverip;
    private String serverName;
    private int serverport;
    private MWClient mwclient;
    private Client client;
    private ClientGUI gui;
    private int turn = 0;
    private ArrayList<Unit> mechs = new ArrayList();
    private ArrayList<CUnit> autoarmy = new ArrayList();
    BotClient bot = null;
    final int N = 0;
    final int NE = 1;
    final int SE = 2;
    final int S = 3;
    final int SW = 4;
    final int NW = 5;

    public ClientThread(String name, String servername, String ip, int port, MWClient mwclient, ArrayList<Unit> mechs, ArrayList<CUnit> autoarmy) {
        this.myname = name;
        this.serverName = servername;
        this.serverip = ip;
        this.serverport = port;
        this.mwclient = mwclient;
        this.mechs = mechs;
        this.autoarmy = autoarmy;
        if (this.serverip.indexOf("127.0.0.1") != -1) {
            this.serverip = "127.0.0.1";
        }
    }

    public int getTurn() {
        return this.turn;
    }

    public Client getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block68: {
            boolean playerUpdate = false;
            this.client = new Client(this.myname, this.serverip, this.serverport);
            this.client.game.addGameListener(this);
            this.client.addCloseClientListener(this);
            this.gui = new ClientGUI(this.client);
            this.gui.initialize();
            Vector<IOption> xmlGameOptions = new Vector<IOption>();
            Vector<IOption> loadOptions = this.client.game.getOptions().loadOptions();
            Enumeration options = this.client.game.getOptions().getOptions();
            while (options.hasMoreElements()) {
                IOption option = (IOption)options.nextElement();
                switch (option.getType()) {
                    case 0: {
                        xmlGameOptions.add(new Option((IOptions)new GameOptions(), option.getName(), (Boolean)option.getDefault()));
                        break;
                    }
                    case 2: {
                        xmlGameOptions.add(new Option((IOptions)new GameOptions(), option.getName(), ((Float)option.getDefault()).floatValue()));
                        break;
                    }
                    case 3: {
                        xmlGameOptions.add(new Option((IOptions)new GameOptions(), option.getName(), (String)option.getDefault()));
                        break;
                    }
                    case 1: {
                        xmlGameOptions.add(new Option((IOptions)new GameOptions(), option.getName(), (Integer)option.getDefault()));
                        break;
                    }
                    case 4: {
                        xmlGameOptions.add(new Option((IOptions)new GameOptions(), option.getName(), (String)option.getDefault()));
                    }
                }
            }
            xmlGameOptions.addAll(loadOptions);
            xmlGameOptions.addAll(this.mwclient.getGameOptions());
            try {
                this.client.connect();
            }
            catch (Exception ex) {
                this.client = null;
                this.mwclient.showInfoWindow("Couldn't join this game!");
                MWClient.mwClientLog.clientOutputLog(this.serverip + " " + this.serverport);
                return;
            }
            try {
                while (this.client.getLocalPlayer() == null) {
                    ClientThread.sleep(50L);
                }
                for (int i = 0; i < 1000 && this.client.game.getPhase() == -1; ++i) {
                    ClientThread.sleep(50L);
                }
                if (this.mwclient.getCurrentEnvironment() != null) {
                    MapSettings mySettings = new MapSettings(this.mwclient.getMapSize().width, this.mwclient.getMapSize().height, 1, 1);
                    AdvanceTerrain aTerrain = new AdvanceTerrain();
                    aTerrain = this.mwclient.getCurrentAdvanceTerrain();
                    if (aTerrain != null && aTerrain.isStaticMap()) {
                        mySettings = new MapSettings(aTerrain.getXSize(), aTerrain.getYSize(), aTerrain.getXBoardSize(), aTerrain.getYBoardSize());
                        Vector<String> vector = new Vector<String>();
                        if (aTerrain.getStaticMapName().equalsIgnoreCase("surprise")) {
                            int maxBoards = aTerrain.getXBoardSize() * aTerrain.getYBoardSize();
                            for (int i = 0; i < maxBoards; ++i) {
                                vector.add("[SURPRISE]");
                            }
                            mySettings.setBoardsSelectedVector(vector);
                            mySettings.setBoardsAvailableVector(this.scanForBoards(aTerrain.getXSize(), aTerrain.getYSize()));
                        } else {
                            vector.add(aTerrain.getStaticMapName());
                            mySettings.setBoardsSelectedVector(vector);
                        }
                        this.client.sendMapSettings(mySettings);
                    } else {
                        PlanetEnvironment planetEnvironment = this.mwclient.getCurrentEnvironment();
                        mySettings.setElevationParams(planetEnvironment.getHillyness(), planetEnvironment.getHillElevationRange(), planetEnvironment.getHillInvertProb());
                        mySettings.setWaterParams(planetEnvironment.getWaterMinSpots(), planetEnvironment.getWaterMaxSpots(), planetEnvironment.getWaterMinHexes(), planetEnvironment.getWaterMaxHexes(), planetEnvironment.getWaterDeepProb());
                        mySettings.setForestParams(planetEnvironment.getForestMinSpots(), planetEnvironment.getForestMaxSpots(), planetEnvironment.getForestMinHexes(), planetEnvironment.getForestMaxHexes(), planetEnvironment.getForestHeavyProb());
                        mySettings.setRoughParams(planetEnvironment.getRoughMinSpots(), planetEnvironment.getRoughMaxSpots(), planetEnvironment.getRoughMinHexes(), planetEnvironment.getRoughMaxHexes());
                        mySettings.setSwampParams(planetEnvironment.getSwampMinSpots(), planetEnvironment.getSwampMaxSpots(), planetEnvironment.getSwampMinHexes(), planetEnvironment.getSwampMaxHexes());
                        mySettings.setPavementParams(planetEnvironment.getPavementMinSpots(), planetEnvironment.getPavementMaxSpots(), planetEnvironment.getPavementMinHexes(), planetEnvironment.getPavementMaxHexes());
                        mySettings.setIceParams(planetEnvironment.getIceMinSpots(), planetEnvironment.getIceMaxSpots(), planetEnvironment.getIceMinHexes(), planetEnvironment.getIceMaxHexes());
                        mySettings.setRubbleParams(planetEnvironment.getRubbleMinSpots(), planetEnvironment.getRubbleMaxSpots(), planetEnvironment.getRubbleMinHexes(), planetEnvironment.getRubbleMaxHexes());
                        mySettings.setFortifiedParams(planetEnvironment.getFortifiedMinSpots(), planetEnvironment.getFortifiedMaxSpots(), planetEnvironment.getFortifiedMinHexes(), planetEnvironment.getFortifiedMaxHexes());
                        mySettings.setSpecialFX(planetEnvironment.getFxMod(), planetEnvironment.getProbForestFire(), planetEnvironment.getProbFreeze(), planetEnvironment.getProbFlood(), planetEnvironment.getProbDrought());
                        mySettings.setRiverParam(planetEnvironment.getRiverProb());
                        mySettings.setCliffParam(planetEnvironment.getCliffProb());
                        mySettings.setRoadParam(planetEnvironment.getRoadProb());
                        mySettings.setCraterParam(planetEnvironment.getCraterProb(), planetEnvironment.getCraterMinNum(), planetEnvironment.getCraterMaxNum(), planetEnvironment.getCraterMinRadius(), planetEnvironment.getCraterMaxRadius());
                        mySettings.setAlgorithmToUse(planetEnvironment.getAlgorithm());
                        mySettings.setInvertNegativeTerrain(planetEnvironment.getInvertNegativeTerrain());
                        mySettings.setMountainParams(planetEnvironment.getMountPeaks(), planetEnvironment.getMountWidthMin(), planetEnvironment.getMountWidthMax(), planetEnvironment.getMountHeightMin(), planetEnvironment.getMountHeightMax(), planetEnvironment.getMountStyle());
                        if (planetEnvironment.getTheme().length() > 1) {
                            mySettings.setTheme(planetEnvironment.getTheme());
                        }
                        Vector<String> boardvec = new Vector<String>();
                        boardvec.add("[GENERATED]");
                        mySettings.setBoardsSelectedVector(boardvec);
                        if (this.mwclient.getBuildingTemplate() != null && this.mwclient.getBuildingTemplate().getTotalBuildings() > 0) {
                            Vector<BuildingTemplate> buildingList = this.generateRandomBuildings(mySettings, this.mwclient.getBuildingTemplate());
                            mySettings.setBoardBuildings(buildingList);
                        } else if (!planetEnvironment.getCityType().equalsIgnoreCase("NONE")) {
                            mySettings.setRoadParam(0);
                            mySettings.setCityParams(planetEnvironment.getRoads(), planetEnvironment.getCityType(), planetEnvironment.getMinCF(), planetEnvironment.getMaxCF(), planetEnvironment.getMinFloors(), planetEnvironment.getMaxFloors(), planetEnvironment.getCityDensity(), planetEnvironment.getTownSize());
                        }
                        this.client.sendMapSettings(mySettings);
                    }
                }
                if (this.mwclient.isUsingBots()) {
                    String name = "War Bot" + this.client.getLocalPlayer().getId();
                    this.bot = new TestBot(name, this.client.getHost(), this.client.getPort());
                    this.bot.game.addGameListener(new BotGUI(this.bot));
                    try {
                        this.bot.connect();
                        ClientThread.sleep(125L);
                        while (this.bot.getLocalPlayer() == null) {
                            ClientThread.sleep(50L);
                        }
                        for (int i = 0; i < 1000 && this.bot.game.getPhase() == -1; ++i) {
                            ClientThread.sleep(50L);
                        }
                    }
                    catch (Exception ex) {
                        MWClient.mwClientLog.clientErrLog("Bot Error!");
                        MWClient.mwClientLog.clientErrLog(ex);
                    }
                    this.bot.retrieveServerInfo();
                    ClientThread.sleep(125L);
                    this.gui.getBots().put(name, this.bot);
                    if (this.mwclient.isBotsOnSameTeam()) {
                        this.bot.getLocalPlayer().setTeam(5);
                    }
                    Random r = new Random();
                    this.bot.getLocalPlayer().setStartingPos(r.nextInt(11));
                    this.bot.sendPlayerInfo();
                    ClientThread.sleep(125L);
                }
                if (this.client.game == null || this.client.game.getPhase() != 1) break block68;
                if (this.mechs.size() > 0 && xmlGameOptions.size() > 0) {
                    this.client.sendGameOptions("", xmlGameOptions);
                }
                IClientPreferences cs = PreferenceManager.getClientPreferences();
                cs.setStampFilenames(Boolean.parseBoolean(this.mwclient.getserverConfigs("MMTimeStampLogFile")));
                cs.setShowUnitId(Boolean.parseBoolean(this.mwclient.getserverConfigs("MMShowUnitId")));
                cs.setKeepGameLog(Boolean.parseBoolean(this.mwclient.getserverConfigs("MMKeepGameLog")));
                cs.setGameLogFilename(this.mwclient.getserverConfigs("MMGameLogName"));
                if (this.mwclient.getConfig().getParam("UNITCAMO").length() > 0) {
                    this.client.getLocalPlayer().setCamoCategory("-- General --");
                    this.client.getLocalPlayer().setCamoFileName(this.mwclient.getConfig().getParam("UNITCAMO"));
                    playerUpdate = true;
                }
                if (this.bot != null) {
                    this.bot.getLocalPlayer().setNbrMFConventional(this.mwclient.getPlayer().getConventionalMinesAllowed());
                    this.bot.getLocalPlayer().setNbrMFVibra(this.mwclient.getPlayer().getVibraMinesAllowed());
                } else {
                    this.client.getLocalPlayer().setNbrMFConventional(this.mwclient.getPlayer().getConventionalMinesAllowed());
                    this.client.getLocalPlayer().setNbrMFVibra(this.mwclient.getPlayer().getVibraMinesAllowed());
                }
                for (CUnit cUnit : this.mechs) {
                    IOption option;
                    Enumeration j;
                    Entity entity = cUnit.getEntity();
                    entity.setExternalId(cUnit.getId());
                    entity.setId(cUnit.getId());
                    entity.setOwner(this.client.getLocalPlayer());
                    if (entity.isOffBoard()) {
                        int direction = 0;
                        switch (this.mwclient.getPlayerStartingEdge()) {
                            case 0: {
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                direction = 0;
                                break;
                            }
                            case 4: {
                                direction = 2;
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 7: {
                                direction = 1;
                                break;
                            }
                            case 8: {
                                direction = 3;
                            }
                        }
                        entity.setOffBoard(entity.getOffBoardDistance(), direction);
                    }
                    IOptionGroup group = null;
                    Pilot pilot = null;
                    pilot = cUnit.getType() == 0 || cUnit.getType() == 1 ? new Pilot(cUnit.getPilot().getName(), cUnit.getPilot().getGunnery(), cUnit.getPilot().getPiloting()) : new Pilot(cUnit.getPilot().getName(), cUnit.getPilot().getGunnery(), 5);
                    pilot.setHits(cUnit.getPilot().getHits());
                    Enumeration enumeration = pilot.getOptions().getGroups();
                    while (enumeration.hasMoreElements() && !(group = (IOptionGroup)enumeration.nextElement()).getKey().equalsIgnoreCase("lvl3Advantages")) {
                    }
                    block31: for (MegaMekPilotOption po : cUnit.getPilot().getMegamekOptions()) {
                        j = group.getOptions();
                        while (j.hasMoreElements()) {
                            option = (IOption)j.nextElement();
                            if (!option.getName().equals(po.getMmname())) continue;
                            if (po.getMmname().equals("weapon_specialist")) {
                                option.setValue(cUnit.getPilot().getWeapon());
                                continue block31;
                            }
                            if (po.getMmname().equals("edge")) {
                                option.setValue(cUnit.getPilot().getSkills().getPilotSkill(20).getLevel());
                                continue block31;
                            }
                            option.setValue(po.isValue());
                            continue block31;
                        }
                    }
                    boolean hasEdge = cUnit.getPilot().getSkills().has(20);
                    if (hasEdge) {
                        j = group.getOptions();
                        while (j.hasMoreElements()) {
                            option = (IOption)j.nextElement();
                            if (option.getName().equals("edge_when_tac")) {
                                option.setValue(cUnit.getPilot().getTac());
                                continue;
                            }
                            if (option.getName().equals("edge_when_ko")) {
                                option.setValue(cUnit.getPilot().getKO());
                                continue;
                            }
                            if (option.getName().equals("edge_when_headhit")) {
                                option.setValue(cUnit.getPilot().getHeadHit());
                                continue;
                            }
                            if (!option.getName().equals("edge_when_explosion")) continue;
                            option.setValue(cUnit.getPilot().getExplosion());
                        }
                    }
                    entity.setCrew(pilot);
                    this.client.sendAddEntity(entity);
                    ClientThread.sleep(125L);
                }
                for (CUnit cUnit : this.autoarmy) {
                    Entity entity = cUnit.getEntity();
                    if (this.bot != null) {
                        entity.setOwner(this.bot.getLocalPlayer());
                    } else {
                        entity.setOwner(this.client.getLocalPlayer());
                    }
                    Pilot pilot = new Pilot("AutoArtillery", 4, 5);
                    entity.setCrew(pilot);
                    MWClient.mwClientLog.clientErrLog(entity.getModel() + " direction " + entity.getOffBoardDirection());
                    if (this.bot != null) {
                        this.bot.sendAddEntity(entity);
                    } else {
                        this.client.sendAddEntity(entity);
                    }
                    ClientThread.sleep(125L);
                }
                if (this.mwclient.getPlayerStartingEdge() != -1) {
                    this.client.getLocalPlayer().setStartingPos(this.mwclient.getPlayerStartingEdge());
                    playerUpdate = true;
                }
                if (this.mechs.size() > 0) {
                    CArmy cArmy;
                    CArmy cArmy2 = cArmy = this.mwclient.getPlayer().getLockedArmy();
                    synchronized (cArmy2) {
                        if (cArmy.getC3Network().size() > 0) {
                            playerUpdate = true;
                            for (int slave : cArmy.getC3Network().keySet()) {
                                this.linkMegaMekC3Units(cArmy, slave, cArmy.getC3Network().get(slave));
                            }
                            this.gui.chatlounge.refreshEntities();
                        }
                    }
                }
                if (this.mwclient.getPlayer().getTeamNumber() > 0) {
                    this.client.getLocalPlayer().setTeam(this.mwclient.getPlayer().getTeamNumber());
                    playerUpdate = true;
                }
                if (playerUpdate) {
                    this.client.sendPlayerInfo();
                    if (this.bot != null) {
                        this.bot.sendPlayerInfo();
                    }
                }
            }
            catch (Exception e) {
                MWClient.mwClientLog.clientOutputLog(e);
            }
        }
    }

    public void gamePlayerStatusChange(GameEvent e) {
    }

    @Override
    public void gameTurnChange(GameTurnChangeEvent e) {
        if (this.client != null) {
            if (this.getTurn() == 0 && (this.myname.equals(this.serverName) || this.serverName.startsWith("[Dedicated]"))) {
                this.mwclient.serverSend("SHS|" + this.serverName + "|Running");
            }
            ++this.turn;
        }
    }

    public String serializeEntity(Entity e, boolean fullStatus, boolean forceDevastate) {
        String result = "";
        boolean useRepairs = this.mwclient.isUsingAdvanceRepairs();
        if (fullStatus) {
            if (!(e instanceof MechWarrior)) {
                result = result + e.getExternalId() + "*";
                result = result + e.getOwner().getName() + "*";
                result = result + e.getCrew().getHits() + "*";
                result = forceDevastate ? result + "1024*" : result + e.getRemovalCondition() + "*";
                result = e instanceof BipedMech ? result + "0*" : (e instanceof QuadMech ? result + "5*" : (e instanceof Tank ? result + "1*" : (e instanceof Protomech ? result + "3*" : (e instanceof BattleArmor ? result + "4*" : result + "2*"))));
                Enumeration<Entity> en = e.getKills();
                if (!en.hasMoreElements()) {
                    result = result + " *";
                }
                while (en.hasMoreElements()) {
                    Entity kill = en.nextElement();
                    result = result + kill.getExternalId();
                    if (en.hasMoreElements()) {
                        result = result + "~";
                        continue;
                    }
                    result = result + "*";
                }
            }
            if (e instanceof Mech) {
                result = result + e.getCrew().isUnconscious() + "*";
                result = result + e.getInternal(1) + "*";
                result = result + e.getInternal(0) + "*";
                result = result + e.getInternal(7) + "*";
                result = result + e.getInternal(6) + "*";
                result = result + e.getInternal(5) + "*";
                result = result + e.getInternal(4) + "*";
                result = result + e.getBadCriticals(0, 4, 1) + "*";
                result = result + ((Mech)e).getCockpitType() + "*";
                if (useRepairs) {
                    result = result + UnitUtils.unitBattleDamage(e) + "*";
                }
            } else if (e instanceof Tank) {
                result = result + e.isRepairable() + "*";
                result = result + e.isImmobile() + "*";
                result = result + e.getCrew().isDead() + "*";
            } else if (e instanceof MechWarrior) {
                MechWarrior mw = (MechWarrior)e;
                result = result + "MW*";
                result = result + mw.getOriginalRideExternalId() + "*";
                result = result + mw.getPickedUpByExternalId() + "*";
                result = result + mw.isDestroyed() + "*";
            }
            if (e.isOffBoard()) {
                result = result + e.getOffBoardDistance() + "*";
            }
        } else if (e instanceof MechWarrior) {
            MechWarrior mw = (MechWarrior)e;
            result = result + "MW*" + mw.getOriginalRideExternalId() + "*";
            result = result + mw.getPickedUpByExternalId() + "*";
            result = result + mw.isDestroyed() + "*";
        } else {
            result = result + e.getOwner().getName() + "*";
            result = result + e.getExternalId() + "*";
            result = forceDevastate ? result + "1024*" : result + e.getRemovalCondition() + "*";
            if (e instanceof Mech) {
                result = result + e.getInternal(1) + "*";
                result = result + e.getInternal(0) + "*";
            } else {
                result = result + "1*";
                result = result + "1*";
            }
            result = result + e.isRepairable() + "*";
        }
        return result;
    }

    @Override
    public void gamePhaseChange(GamePhaseChangeEvent e) {
        String name = "";
        try {
            if (this.client.game.getPhase() == 18) {
                while (this.client.getLocalPlayer() == null) {
                    ClientThread.sleep(50L);
                }
                this.mwclient.getPlayer().setConventionalMinesAllowed(0);
                this.mwclient.getPlayer().setVibraMinesAllowed(0);
                this.mwclient.setUsingBots(false);
                this.mwclient.setEnvironment(null, null, null);
                this.mwclient.setAdvanceTerrain(null, null);
                this.mwclient.setPlayerStartingEdge(-1);
                Iterator<Client> i = this.gui.getBots().values().iterator();
                while (i.hasNext()) {
                    i.next().die();
                }
                this.gui.getBots().clear();
                if (this.client.game.getAllEntitiesOwnedBy(this.client.getLocalPlayer()) < 1) {
                    return;
                }
                MMGame toUse = this.mwclient.getServers().get(this.serverName);
                this.mwclient.serverSend("SGR|" + toUse.getHostName());
                MWClient.mwClientLog.clientOutputLog("GAME END");
                if (this.mwclient.getPlayer().getName().equalsIgnoreCase(name) && toUse.getHostName().startsWith("[Dedicated]")) {
                    this.mwclient.sendChat("/mail " + toUse.getHostName() + ",checkrestartcount");
                }
            } else if (this.client.game.getPhase() == 13 || this.client.game.getPhase() == 15 || this.client.game.getPhase() == 9 || this.client.game.getPhase() == 17 || this.client.game.getPhase() == 11) {
                Entity currEntity;
                if (this.client.getLocalPlayer().isObserver()) {
                    return;
                }
                Enumeration<Entity> en = this.client.game.getWreckedEntities();
                while (en.hasMoreElements()) {
                    currEntity = en.nextElement();
                    if (!(currEntity instanceof MechWarrior)) continue;
                    this.mwclient.serverSend("IPU|" + this.serializeEntity(currEntity, false, false));
                }
                en = this.client.game.getEntities();
                while (en.hasMoreElements()) {
                    currEntity = en.nextElement();
                    if (currEntity.getOwner().getName().startsWith("War Bot") || !(currEntity instanceof MechWarrior)) continue;
                    this.mwclient.serverSend("IPU|" + this.serializeEntity(currEntity, false, false));
                }
            }
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Error reporting game!");
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    @Override
    public void gameEntityRemove(GameEntityRemoveEvent e) {
        if (this.client.getLocalPlayer().isObserver()) {
            return;
        }
        Entity removedE = e.getEntity();
        if (removedE.getOwner().getName().startsWith("War Bot")) {
            return;
        }
        String toSend = this.serializeEntity(removedE, false, false);
        this.mwclient.serverSend("IPU|" + toSend);
    }

    @Override
    public void gamePlayerConnected(GamePlayerConnectedEvent e) {
    }

    @Override
    public void gamePlayerDisconnected(GamePlayerDisconnectedEvent e) {
    }

    @Override
    public void gamePlayerChange(GamePlayerChangeEvent e) {
    }

    @Override
    public void gamePlayerChat(GamePlayerChatEvent e) {
    }

    @Override
    public void gameReport(GameReportEvent e) {
    }

    @Override
    public void gameEnd(GameEndEvent e) {
    }

    @Override
    public void gameBoardNew(GameBoardNewEvent e) {
    }

    @Override
    public void gameBoardChanged(GameBoardChangeEvent e) {
    }

    @Override
    public void gameSettingsChange(GameSettingsChangeEvent e) {
    }

    @Override
    public void gameMapQuery(GameMapQueryEvent e) {
    }

    @Override
    public void gameEntityNew(GameEntityNewEvent e) {
    }

    @Override
    public void gameEntityNewOffboard(GameEntityNewOffboardEvent e) {
    }

    @Override
    public void gameEntityChange(GameEntityChangeEvent e) {
    }

    @Override
    public void gameNewAction(GameNewActionEvent e) {
    }

    @Override
    public void clientClosed() {
        PreferenceManager.getInstance().save();
        if (this.bot != null) {
            this.bot.die();
            this.bot = null;
        }
        this.client = null;
        this.mwclient.closingGame(this.serverName);
        System.gc();
    }

    public void linkMegaMekC3Units(CArmy army, Integer slaveid, Integer masterid) {
        Entity c3Unit = null;
        Entity c3Master = null;
        while (c3Unit == null || c3Master == null) {
            try {
                if (c3Unit == null) {
                    c3Unit = this.client.game.getEntity(slaveid);
                }
                if (c3Master == null) {
                    c3Master = this.client.game.getEntity(masterid);
                }
                ClientThread.sleep(10L);
            }
            catch (Exception ex) {
                MWClient.mwClientLog.clientErrLog("Error in linkMegaMekC3Units");
                MWClient.mwClientLog.clientErrLog(ex);
            }
        }
        if (c3Unit == null || c3Master == null) {
            MWClient.mwClientLog.clientErrLog("Null Units c3Unit: " + c3Unit + " C3Master: " + c3Master);
            return;
        }
        try {
            CUnit masterUnit = (CUnit)army.getUnit(masterid);
            if (!masterUnit.hasC3SlavesLinkedTo(army) && masterUnit.hasBeenC3LinkedTo(army) && (masterUnit.getC3Level() == 2 || masterUnit.getC3Level() == 4)) {
                if (c3Master.getC3MasterId() == -1) {
                    c3Master.setShutDown(false);
                    c3Master.setC3Master(c3Master);
                    this.client.sendUpdateEntity(c3Master);
                }
            } else if (c3Master.getC3MasterId() != -1) {
                c3Master.setShutDown(false);
                c3Master.setC3Master(-1);
                this.client.sendUpdateEntity(c3Master);
            }
            c3Unit.setShutDown(false);
            c3Unit.setC3Master(c3Master);
            this.client.sendUpdateEntity(c3Unit);
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
            MWClient.mwClientLog.clientErrLog("Error in setting up C3Network");
        }
    }

    public static Comparator<? super Object> stringComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String s1 = ((String)o1).toLowerCase();
                String s2 = ((String)o2).toLowerCase();
                return s1.compareTo(s2);
            }
        };
    }

    private Vector scanForBoards(int boardWidth, int boardHeight) {
        Vector<String> boards = new Vector<String>();
        File boardDir = new File("data/boards");
        if (!boardDir.isDirectory()) {
            return boards;
        }
        String[] fileList = boardDir.list();
        Vector<String> tempList = new Vector<String>();
        Comparator<? super Object> sortComp = ClientThread.stringComparator();
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].indexOf(".board") == -1 || !Board.boardIsSize(fileList[i], boardWidth, boardHeight)) continue;
            tempList.addElement(fileList[i].substring(0, fileList[i].lastIndexOf(".board")));
        }
        if (tempList.size() > 0) {
            boards.addElement("[RANDOM]");
            boards.addElement("[SURPRISE]");
            boards.addElement("[GENERATED]");
            Collections.sort(tempList, sortComp);
            for (int loop = 0; loop < tempList.size(); ++loop) {
                boards.addElement((String)tempList.elementAt(loop));
            }
        } else {
            boards.addElement("[GENERATED]");
        }
        return boards;
    }

    private Vector<BuildingTemplate> generateRandomBuildings(MapSettings mapSettings, Buildings buildingTemplate) {
        Vector<BuildingTemplate> buildingList = new Vector<BuildingTemplate>();
        Vector<String> buildingTypes = new Vector<String>();
        int width = mapSettings.getBoardWidth();
        int height = mapSettings.getBoardHeight();
        int minHeight = 0;
        int minWidth = 0;
        switch (buildingTemplate.getStartingEdge()) {
            case 2: {
                height = 5;
                minHeight = 1;
                break;
            }
            case 6: {
                if (height > 5) {
                    minHeight = height - 5;
                }
                height = 5;
                break;
            }
            case 4: {
                if (width > 5) {
                    minWidth = width - 5;
                }
                width = 5;
                break;
            }
            case 8: {
                width = 5;
                minWidth = 1;
                break;
            }
        }
        StringTokenizer types = new StringTokenizer(buildingTemplate.getBuildingType(), ",");
        while (types.hasMoreTokens()) {
            buildingTypes.add(types.nextToken());
        }
        int typeSize = buildingTypes.size();
        Random r = new Random();
        TreeSet<String> tempMap = new TreeSet<String>();
        Coords coord = new Coords();
        String stringCoord = "";
        for (int count = 0; count < buildingTemplate.getTotalBuildings(); ++count) {
            int y;
            int x;
            int loops = 0;
            boolean CFx2 = false;
            Vector<Coords> coordList = new Vector<Coords>();
            do {
                if (loops++ > 100) {
                    CFx2 = true;
                    break;
                }
                x = r.nextInt(width) + minWidth;
                y = r.nextInt(height) + minHeight;
                if (x >= mapSettings.getBoardWidth()) {
                    x = mapSettings.getBoardWidth() - 2;
                } else if (x <= 1) {
                    x = 2;
                }
                if (y >= mapSettings.getBoardHeight()) {
                    y = mapSettings.getBoardHeight() - 2;
                } else if (y <= 1) {
                    y = 2;
                }
                coord = new Coords(x, y);
            } while (tempMap.contains(stringCoord = x + "," + y));
            tempMap.add(stringCoord);
            coordList.add(coord);
            int floors = buildingTemplate.getMaxFloors() - buildingTemplate.getMinFloors();
            floors = floors <= 0 ? buildingTemplate.getMinFloors() : r.nextInt(floors) + buildingTemplate.getMinFloors();
            int totalCF = buildingTemplate.getMaxCF() - buildingTemplate.getMinCF();
            totalCF = totalCF <= 0 ? buildingTemplate.getMinCF() : r.nextInt(totalCF) + buildingTemplate.getMinCF();
            if (CFx2) {
                totalCF *= 2;
            }
            int type = 1;
            try {
                type = typeSize == 1 ? Integer.parseInt((String)buildingTypes.elementAt(0)) : Integer.parseInt((String)buildingTypes.elementAt(r.nextInt(typeSize)));
            }
            catch (Exception ex) {
                // empty catch block
            }
            buildingList.add(new BuildingTemplate(type, coordList, totalCF, floors, -1));
        }
        return buildingList;
    }

    public int getBuildingsLeft() {
        Enumeration<Building> buildings = this.client.game.getBoard().getBuildings();
        int buildingCount = 0;
        while (buildings.hasMoreElements()) {
            buildings.nextElement();
            ++buildingCount;
        }
        return buildingCount;
    }
}

