/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import common.Army;
import common.Unit;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CArmy
extends Army {
    private MWClient mwclient;
    private TreeSet<String> legalOperations = new TreeSet();

    public void fromString(String s, CPlayer p, String delimiter, MWClient client) {
        int i;
        this.mwclient = client;
        StringTokenizer ST = new StringTokenizer(s, delimiter);
        this.setID(Integer.parseInt(ST.nextToken()));
        this.setBV(Integer.parseInt(ST.nextToken()));
        this.setLocked(Boolean.parseBoolean(ST.nextToken()));
        this.setName(ST.nextToken());
        this.setLowerLimiter(Integer.parseInt(ST.nextToken()));
        this.setUpperLimiter(Integer.parseInt(ST.nextToken()));
        int count = Integer.parseInt(ST.nextToken());
        for (i = 0; i < count; ++i) {
            CUnit u = p.getUnit(Integer.parseInt(ST.nextToken()));
            if (u.getId() == 0) continue;
            this.addUnit(u);
        }
        if (ST.hasMoreElements()) {
            count = Integer.parseInt(ST.nextToken());
            for (i = 0; i < count; ++i) {
                int key = Integer.parseInt(ST.nextToken());
                int unit = Integer.parseInt(ST.nextToken());
                this.getC3Network().put(key, unit);
            }
        }
        if (ST.hasMoreTokens()) {
            this.setOpForceSize(Integer.parseInt(ST.nextToken()));
        }
    }

    public void addUnit(CUnit u) {
        this.getUnits().add(u);
    }

    public void addUnit(CUnit u, int position) {
        this.getUnits().add(position, u);
    }

    public TreeSet<String> getLegalOperations() {
        return this.legalOperations;
    }

    protected void setLegalOperations(TreeSet<String> ts) {
        this.legalOperations = ts;
    }

    public double forceSizeModifier(double opposingForceSize) {
        double myForceSize = 0.0;
        double mekSize = Double.parseDouble(this.mwclient.getserverConfigs("MekOperationsBVMod"));
        double veeSize = Double.parseDouble(this.mwclient.getserverConfigs("VehicleOperationsBVMod"));
        double baSize = Double.parseDouble(this.mwclient.getserverConfigs("BAOperationsBVMod"));
        double protoSize = Double.parseDouble(this.mwclient.getserverConfigs("ProtoOperationsBVMod"));
        double infSize = Double.parseDouble(this.mwclient.getserverConfigs("InfantryOperationsBVMod"));
        block7: for (Unit unit : this.getUnits()) {
            switch (unit.getType()) {
                case 0: {
                    myForceSize += mekSize;
                    continue block7;
                }
                case 1: {
                    myForceSize += veeSize;
                    continue block7;
                }
                case 4: {
                    myForceSize += baSize;
                    continue block7;
                }
                case 3: {
                    myForceSize += protoSize;
                    continue block7;
                }
                case 2: {
                    myForceSize += infSize;
                    continue block7;
                }
            }
            myForceSize += 1.0;
        }
        if (myForceSize > opposingForceSize) {
            return opposingForceSize / myForceSize + myForceSize / opposingForceSize - 1.0;
        }
        return 1.0;
    }
}

