/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CPersonalPilotQueues;
import client.campaign.CUnit;
import client.util.CUnitComparator;
import common.House;
import common.Player;
import common.Unit;
import common.util.UnitComponents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPlayer
extends Player {
    public static final String PREFIX = "PL";
    public static final String DELIMITER = "#";
    private MWClient mwclient;
    private String Name;
    private String House;
    private String myLogo = "";
    private int Exp;
    private int Money;
    private int Bays;
    private int FreeBays;
    private int Influence;
    private int Techs;
    private int TechCost;
    private int RewardPoints;
    private double Rating;
    private Vector<CUnit> Hangar;
    private Vector<CArmy> Armies;
    private ArrayList<CUnit> AutoArmy;
    private ArrayList<String> adminExcludes;
    private ArrayList<String> playerExcludes;
    private CPersonalPilotQueues personalPilotQueue;
    private House myHouse = null;
    private House houseFightingFor = null;
    private ArrayList<Integer> totalTechs = new ArrayList(4);
    private ArrayList<Integer> availableTechs = new ArrayList(4);
    private int repairLocation = 0;
    private int repairTechType = 0;
    private int repairRetries = 0;
    private int conventionalMinesAllowed = 0;
    private int vibraMinesAllowed = 0;
    private UnitComponents partsCache = new UnitComponents();

    public CPlayer(MWClient client) {
        this.mwclient = client;
        this.Name = "";
        this.Exp = 0;
        this.Money = 0;
        this.Bays = 0;
        this.FreeBays = 0;
        this.Influence = 0;
        this.Rating = 0.0;
        this.House = "";
        this.Hangar = new Vector();
        this.Armies = new Vector();
        this.AutoArmy = new ArrayList();
        this.personalPilotQueue = new CPersonalPilotQueues();
        this.adminExcludes = new ArrayList();
        this.playerExcludes = new ArrayList();
        this.myHouse = new House();
        this.houseFightingFor = new House();
        for (int x = 0; x < 4; ++x) {
            this.availableTechs.add(0);
            this.totalTechs.add(0);
        }
    }

    public boolean decodeCommand(String command) {
        StringTokenizer ST = new StringTokenizer(command, "|");
        String element = (String)ST.nextElement();
        if (!element.equals(PREFIX)) {
            return false;
        }
        element = (String)ST.nextElement();
        command = command.substring(3);
        if (element.equals("DA")) {
            return this.setData(command);
        }
        return false;
    }

    public void setArmyData(String data) {
        CArmy newArmy = new CArmy();
        newArmy.fromString(data, this, "%", this.mwclient);
        CArmy oldArmy = this.getArmy(newArmy.getID());
        if (oldArmy != null) {
            newArmy.setLegalOperations(oldArmy.getLegalOperations());
        }
        this.removeArmy(newArmy.getID());
        this.Armies.add(newArmy);
    }

    public boolean setData(String data) {
        int i;
        StringTokenizer ST = new StringTokenizer(data, "~");
        String element = (String)ST.nextElement();
        if (!element.equals("CP")) {
            return false;
        }
        for (int x = 0; x < 3; ++x) {
            this.setTotalTechs(x, 0);
            this.setAvailableTechs(x, 0);
        }
        this.Armies.clear();
        this.Hangar.clear();
        this.Name = (String)ST.nextElement();
        this.Money = Integer.parseInt((String)ST.nextElement());
        this.Exp = Integer.parseInt((String)ST.nextElement());
        int Hangarcount = Integer.parseInt((String)ST.nextElement());
        for (i = 0; i < Hangarcount; ++i) {
            CUnit tmek = new CUnit(this.mwclient);
            if (!tmek.setData((String)ST.nextElement())) continue;
            this.Hangar.add(tmek);
        }
        int Armiescount = Integer.parseInt((String)ST.nextElement());
        for (i = 0; i < Armiescount; ++i) {
            CArmy army = new CArmy();
            army.fromString((String)ST.nextElement(), this, "%", this.mwclient);
            this.Armies.add(army);
        }
        this.Bays = Integer.parseInt(ST.nextToken());
        this.FreeBays = Integer.parseInt(ST.nextToken());
        this.Rating = Double.parseDouble(ST.nextToken());
        this.Influence = Integer.parseInt(ST.nextToken());
        if (ST.hasMoreElements()) {
            this.setTechnicians(Integer.parseInt(ST.nextToken()));
            this.doPayTechniciansMath();
        }
        if (ST.hasMoreElements()) {
            this.RewardPoints = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.House = ST.nextToken();
        }
        if (ST.hasMoreElements()) {
            this.setHouseFightingFor(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.setLogo(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.setInvisible(Boolean.parseBoolean(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.partsCache.fromString(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.setAutoReorder(Boolean.parseBoolean(ST.nextToken()));
        }
        this.sortHangar();
        return true;
    }

    public void setHangarData(String data) {
        try {
            CUnit unit = new CUnit(this.mwclient);
            if (unit.setData(data)) {
                this.Hangar.add(unit);
                this.sortHangar();
            }
        }
        catch (Exception e) {
            MWClient.mwClientLog.clientErrLog(e);
            return;
        }
    }

    public void updateUnitData(StringTokenizer st) {
        try {
            CUnit currUnit = this.getUnit(Integer.parseInt(st.nextToken()));
            currUnit.setData(st.nextToken());
            this.sortHangar();
        }
        catch (Exception e) {
            MWClient.mwClientLog.clientErrLog(e);
            return;
        }
    }

    public boolean removeArmy(int lanceID) {
        Iterator<CArmy> i = this.Armies.iterator();
        while (i.hasNext()) {
            if (i.next().getID() != lanceID) continue;
            i.remove();
            this.mwclient.getMainFrame().updateAttackMenu();
            return true;
        }
        return false;
    }

    public boolean removeUnit(int unitID) {
        Iterator<CUnit> i = this.Hangar.iterator();
        while (i.hasNext()) {
            if (i.next().getId() != unitID) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public Vector<CArmy> getArmies() {
        return this.Armies;
    }

    public void setExp(int texp) {
        this.Exp = texp;
    }

    public void setMoney(int tmoney) {
        this.Money = tmoney;
    }

    public void setRewardPoints(int rewards) {
        this.RewardPoints = rewards;
    }

    public void setBays(int tbays) {
        this.Bays = tbays;
    }

    public void setFreeBays(int tfreebays) {
        this.FreeBays = tfreebays;
    }

    public void setInfluence(int tinfluence) {
        this.Influence = tinfluence;
    }

    public void setRating(double trating) {
        this.Rating = trating;
    }

    public void setHouse(String faction) {
        this.myHouse = this.mwclient.getData().getHouseByName(faction);
        this.House = faction;
        this.mwclient.sendChat("/c GetFactionConfigs#" + this.mwclient.getserverConfigs("TIMESTAMP"));
        if (this.mwclient.getMainFrame().getMainPanel().getBMPanel() != null) {
            this.mwclient.getMainFrame().getMainPanel().getBMPanel().checkFactionAccess();
        }
        if (this.mwclient.getMainFrame().getMainPanel().getHQPanel() != null) {
            this.mwclient.getMainFrame().getMainPanel().getHQPanel().reinitialize();
        }
    }

    public String getHouse() {
        return this.House;
    }

    public void setHouseFightingFor(String faction) {
        this.houseFightingFor = this.mwclient.getData().getHouseByName(faction);
    }

    public House getHouseFightingFor() {
        return this.houseFightingFor;
    }

    public void setLogo(String logo) {
        this.myLogo = logo;
    }

    public String getLogo() {
        return "<img height=\"140\" width=\"130\" src =\"" + this.myLogo + "\">";
    }

    public String getMyLogo() {
        return this.myLogo;
    }

    public String getName() {
        return this.Name;
    }

    public int getExp() {
        return this.Exp;
    }

    public double getRating() {
        return this.Rating;
    }

    public int getRewardPoints() {
        return this.RewardPoints;
    }

    public int getMoney() {
        return this.Money;
    }

    public int getBays() {
        return this.Bays;
    }

    public int getFreeBays() {
        return this.FreeBays;
    }

    public int getInfluence() {
        return this.Influence;
    }

    public int getTechs() {
        return this.Techs;
    }

    @Override
    public void setTechnicians(int tech) {
        this.Techs = tech;
        this.doPayTechniciansMath();
    }

    public int getTechCost() {
        if (this.TechCost < 0) {
            return 0;
        }
        return this.TechCost;
    }

    public Vector<CUnit> getHangar() {
        return this.Hangar;
    }

    public int getNextNewArmyID() {
        int newID = -1;
        int possibleNewID = 0;
        while (newID == -1) {
            for (int i = 0; i < this.Armies.size(); ++i) {
                if (this.Armies.get(i).getID() != possibleNewID) continue;
                newID = i;
            }
            if (newID == -1) {
                newID = possibleNewID;
                continue;
            }
            ++possibleNewID;
            newID = -1;
        }
        return newID;
    }

    public void setAutoArmy(StringTokenizer st) {
        this.AutoArmy = new ArrayList();
        if (st == null) {
            return;
        }
        while (st.hasMoreTokens()) {
            String filename = st.nextToken();
            if (filename.equals("CLEAR")) {
                return;
            }
            int distInBoards = Integer.parseInt(this.mwclient.getserverConfigs("DistanceFromMap"));
            int distInHexes = distInBoards * 17;
            CUnit currUnit = new CUnit(this.mwclient);
            int direction = 0;
            switch (this.mwclient.getPlayerStartingEdge()) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    direction = 0;
                    break;
                }
                case 4: {
                    direction = 2;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    direction = 1;
                    break;
                }
                case 8: {
                    direction = 3;
                }
            }
            currUnit.setAutoUnitData(filename, distInHexes, direction);
            this.AutoArmy.add(currUnit);
        }
    }

    public void setAutoGunEmplacements(StringTokenizer st) {
        if (st == null) {
            return;
        }
        while (st.hasMoreTokens()) {
            String filename = st.nextToken();
            CUnit currUnit = new CUnit(this.mwclient);
            currUnit.setAutoUnitData(filename, 0, 0);
            this.AutoArmy.add(currUnit);
        }
    }

    public ArrayList<CUnit> getAutoArmy() {
        return this.AutoArmy;
    }

    public CUnit getUnit(int unitID) {
        for (CUnit currU : this.Hangar) {
            if (currU.getId() != unitID) continue;
            return currU;
        }
        return null;
    }

    public CArmy getArmy(int id) {
        for (CArmy currA : this.Armies) {
            if (currA.getID() != id) continue;
            return currA;
        }
        return null;
    }

    public int getAmountOfTimesUnitExistsInArmies(int unitID) {
        int result = 0;
        for (CArmy currA : this.Armies) {
            if (currA.getUnit(unitID) == null) continue;
            ++result;
        }
        return result;
    }

    public String getArmiesUnitIsIn(int unitID) {
        StringBuilder result = new StringBuilder();
        for (CArmy currA : this.Armies) {
            if (currA.getUnit(unitID) == null) continue;
            result.append(currA.getID() + " ");
        }
        return result.toString();
    }

    public synchronized ArrayList<Unit> getLockedUnits() {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (CArmy currA : this.Armies) {
            if (!currA.isLocked()) continue;
            result.addAll(currA.getUnits());
        }
        return result;
    }

    public synchronized CArmy getLockedArmy() {
        for (CArmy currA : this.Armies) {
            if (!currA.isLocked()) continue;
            return currA;
        }
        return null;
    }

    public void doPayTechniciansMath() {
        if (this.Techs <= 0) {
            this.TechCost = 0;
            return;
        }
        float amountToPay = 0.0f;
        float additive = Float.parseFloat(this.mwclient.getserverConfigs("AdditivePerTech"));
        float ceiling = Float.parseFloat(this.mwclient.getserverConfigs("AdditiveCostCeiling"));
        int techCeiling = (int)(ceiling / additive);
        if (this.Techs > techCeiling) {
            int techsPastCeiling = this.Techs - techCeiling;
            amountToPay += ceiling * (float)techsPastCeiling;
        }
        int techsUsingAdditive = 0;
        techsUsingAdditive = this.Techs > techCeiling ? techCeiling : this.Techs;
        int totalAdditions = 0;
        for (int i = 1; i <= techsUsingAdditive; ++i) {
            totalAdditions += i;
        }
        this.TechCost = Math.round(amountToPay += (float)totalAdditions * additive);
    }

    public void addArmyUnit(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            int unitid = Integer.parseInt(ST.nextToken());
            int bv = Integer.parseInt(ST.nextToken());
            if (ST.hasMoreElements()) {
                int position = Integer.parseInt(ST.nextToken());
                this.getArmy(army).addUnit(this.getUnit(unitid), position);
            } else {
                this.getArmy(army).addUnit(this.getUnit(unitid));
            }
            this.getArmy(army).setBV(bv);
        }
    }

    public void removeArmyUnit(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            int unitid = Integer.parseInt(ST.nextToken());
            int bv = Integer.parseInt(ST.nextToken());
            Iterator<Unit> i = this.getArmy(army).getUnits().iterator();
            while (i.hasNext()) {
                if (i.next().getId() != unitid) continue;
                i.remove();
                break;
            }
            this.getArmy(army).setBV(bv);
            this.getArmy(army).getC3Network().remove(unitid);
        }
        this.mwclient.refreshGUI(5);
    }

    public void updateOperations(String data) {
        StringTokenizer tokenizer = new StringTokenizer(data, "*");
        int armyID = Integer.parseInt(tokenizer.nextToken());
        CArmy army = this.getArmy(armyID);
        if (army == null) {
            return;
        }
        while (tokenizer.hasMoreTokens()) {
            String mode = "";
            String name = "";
            try {
                mode = tokenizer.nextToken();
                name = tokenizer.nextToken();
            }
            catch (NoSuchElementException e) {
                return;
            }
            if (mode.equals("a")) {
                army.getLegalOperations().add(name);
                continue;
            }
            if (!mode.equals("r")) continue;
            army.getLegalOperations().remove(name);
        }
        this.mwclient.getMainFrame().updateAttackMenu();
    }

    public void repositionArmyUnit(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        int army = Integer.parseInt(ST.nextToken());
        int unitid = Integer.parseInt(ST.nextToken());
        int position = Integer.parseInt(ST.nextToken());
        CArmy a = this.getArmy(army);
        Iterator<Unit> i = a.getUnits().iterator();
        while (i.hasNext()) {
            if (i.next().getId() != unitid) continue;
            i.remove();
            break;
        }
        this.getArmy(army).addUnit(this.getUnit(unitid), position);
    }

    public void setUnitStatus(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int unitid = Integer.parseInt(ST.nextToken());
            int status = Integer.parseInt(ST.nextToken());
            if (this.mwclient.isUsingAdvanceRepairs() && status == 2) {
                this.getUnit(unitid).setStatus(1);
            } else {
                this.getUnit(unitid).setStatus(status);
            }
        }
    }

    public void setArmyName(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            String name = ST.nextToken();
            this.getArmy(army).setName(name);
        }
    }

    public void setArmyBV(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            if (this.getArmy(army) != null) {
                this.getArmy(army).setBV(Integer.parseInt(ST.nextToken()));
            } else {
                MWClient.mwClientLog.clientErrLog("Bad Army id: " + army);
            }
        }
    }

    public void setArmyLimit(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            int lowerLimit = Integer.parseInt(ST.nextToken());
            int upperLimit = Integer.parseInt(ST.nextToken());
            this.getArmy(army).setLowerLimiter(lowerLimit);
            this.getArmy(army).setUpperLimiter(upperLimit);
        }
    }

    public void setArmyOpForceSize(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            int opForceSize = Integer.parseInt(ST.nextToken());
            this.getArmy(army).setOpForceSize(opForceSize);
        }
    }

    public void setArmyLock(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            boolean lock = Boolean.parseBoolean(ST.nextToken());
            this.getArmy(army).setLocked(lock);
        }
    }

    public void setPlayerPersonalPilotQueue(CPersonalPilotQueues queue) {
        this.personalPilotQueue = queue;
    }

    public CPersonalPilotQueues getPersonalPilotQueue() {
        return this.personalPilotQueue;
    }

    public void setAdminExcludes(String buffer, String token) {
        this.adminExcludes.clear();
        StringTokenizer ST = new StringTokenizer(buffer, token);
        while (ST.hasMoreElements()) {
            String curr = ST.nextToken();
            if (curr.equals("0")) continue;
            this.adminExcludes.add(curr);
        }
        this.mwclient.getMainFrame().getMainPanel().getUserListPanel().repaint();
    }

    public void setPlayerExcludes(String buffer, String token) {
        this.playerExcludes.clear();
        StringTokenizer ST = new StringTokenizer(buffer, token);
        while (ST.hasMoreElements()) {
            String curr = ST.nextToken();
            if (curr.equals("0")) continue;
            this.playerExcludes.add(curr);
        }
        this.mwclient.getMainFrame().getMainPanel().getUserListPanel().repaint();
    }

    public ArrayList<String> getAdminExcludes() {
        return this.adminExcludes;
    }

    public ArrayList<String> getPlayerExcludes() {
        return this.playerExcludes;
    }

    public void sortHangar() {
        String primeSortOrder = this.mwclient.getConfigParam("PRIMARYHQSORTORDER");
        String secondarySortOrder = this.mwclient.getConfigParam("SECONDARYHQSORTORDER");
        String tertiarySortOrder = this.mwclient.getConfigParam("TERTIARYHQSORTORDER");
        String[] choices = new String[]{"Name", "Battle Value", "Gunnery Skill", "ID Number", "MP (Jumping)", "MP (Walking)", "Pilot Kills", "Unit Type", "Weight (Class)", "Weight (Tons)", "No Sort"};
        int primarySort = 10;
        for (int i = 0; i < choices.length; ++i) {
            if (!primeSortOrder.equals(choices[i])) continue;
            primarySort = i;
        }
        int secondarySort = 10;
        for (int i = 0; i < choices.length; ++i) {
            if (!secondarySortOrder.equals(choices[i])) continue;
            secondarySort = i;
        }
        int tertiarySort = 10;
        for (int i = 0; i < choices.length; ++i) {
            if (!tertiarySortOrder.equals(choices[i])) continue;
            tertiarySort = i;
        }
        Object[] unitsArray = this.Hangar.toArray();
        if (tertiarySort != primarySort && tertiarySort != secondarySort && tertiarySort != 10) {
            Arrays.sort(unitsArray, new CUnitComparator(tertiarySort));
        }
        if (primarySort != secondarySort && secondarySort != 10) {
            Arrays.sort(unitsArray, new CUnitComparator(secondarySort));
        }
        if (primarySort != 10) {
            Arrays.sort(unitsArray, new CUnitComparator(primarySort));
        }
        Vector<CUnit> Hangar2 = new Vector<CUnit>();
        for (int i = 0; i < unitsArray.length; ++i) {
            Hangar2.add((CUnit)unitsArray[i]);
        }
        this.Hangar = Hangar2;
        unitsArray = null;
    }

    public int getHangarSpaceRequired(int typeid, int weightclass, int baymod, String model) {
        if (typeid == 3) {
            return 0;
        }
        if (typeid == 2 && Boolean.parseBoolean(this.mwclient.getserverConfigs("FootInfTakeNoBays"))) {
            boolean isFoot = model.startsWith("Foot");
            boolean isAMFoot = model.startsWith("Anti-Mech Foot");
            if (isFoot || isAMFoot) {
                return 0;
            }
        }
        int result = 1;
        String techAmount = "TechsFor" + Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(typeid);
        result = Integer.parseInt(this.mwclient.getserverConfigs(techAmount));
        if (!this.mwclient.isUsingAdvanceRepairs()) {
            result += baymod;
        }
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public House getMyHouse() {
        return this.myHouse;
    }

    public void applyUnitRepairs(StringTokenizer data) {
        CUnit unit = this.getUnit(Integer.parseInt(data.nextToken()));
        unit.applyRepairs(data.nextToken());
    }

    public void updateTotalTechs(String data) {
        StringTokenizer techs = new StringTokenizer(data, "%");
        int slot = 0;
        while (techs.hasMoreTokens()) {
            this.setTotalTechs(slot, Integer.parseInt(techs.nextToken()));
            ++slot;
        }
    }

    public void setTotalTechs(int slot, int techs) {
        this.totalTechs.set(slot, techs);
    }

    public ArrayList<Integer> getTotalTechs() {
        return this.totalTechs;
    }

    public void updateAvailableTechs(String data) {
        StringTokenizer techs = new StringTokenizer(data, "%");
        int slot = 0;
        while (techs.hasMoreTokens()) {
            this.setAvailableTechs(slot, Integer.parseInt(techs.nextToken()));
            ++slot;
        }
    }

    public void setAvailableTechs(int slot, int techs) {
        this.availableTechs.set(slot, techs);
    }

    public ArrayList<Integer> getAvailableTechs() {
        return this.availableTechs;
    }

    public void setRepairLocation(int loc) {
        this.repairLocation = loc;
    }

    public int getRepairLocation() {
        return this.repairLocation;
    }

    public void setRepairTechType(int type) {
        this.repairTechType = type;
    }

    public int getRepairTechType() {
        return this.repairTechType;
    }

    public void setRepairRetries(int retries) {
        this.repairRetries = retries;
    }

    public int getRepairRetries() {
        return this.repairRetries;
    }

    public void resetRepairs() {
        this.repairLocation = 0;
        this.repairTechType = 0;
        this.repairRetries = 0;
    }

    public void setConventionalMinesAllowed(int mines) {
        this.conventionalMinesAllowed = mines;
    }

    public int getConventionalMinesAllowed() {
        return this.conventionalMinesAllowed;
    }

    public void setVibraMinesAllowed(int mines) {
        this.vibraMinesAllowed = mines;
    }

    public int getVibraMinesAllowed() {
        return this.vibraMinesAllowed;
    }

    public void setMines(StringTokenizer st) {
        this.setConventionalMinesAllowed(Integer.parseInt(st.nextToken()));
        this.setVibraMinesAllowed(Integer.parseInt(st.nextToken()));
    }

    public void setFactionConfigs(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        while (ST.hasMoreTokens()) {
            String key = ST.nextToken();
            String value = ST.nextToken();
            this.mwclient.getserverConfigs().remove(key);
            this.mwclient.getserverConfigs().setProperty(key, value);
        }
        this.mwclient.setWaiting(false);
    }

    public UnitComponents getPartsCache() {
        return this.partsCache;
    }
}

