/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import common.House;
import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import common.campaign.pilot.skills.PilotSkill;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Mounted;
import megamek.common.WeaponType;

public class CUnit
extends Unit {
    protected Entity UnitEntity;
    private int BV;
    private int pilotBV = 0;
    private int scrappableFor = 0;
    private boolean pilotIsRepairing = false;
    private MWClient mwclient;

    public CUnit() {
        this.init();
    }

    public CUnit(MWClient mwclient) {
        this.mwclient = mwclient;
        this.init();
    }

    private void init() {
        this.UnitEntity = null;
        this.BV = 0;
        this.setStatus(1);
        this.setProducer("unknown origin");
    }

    public boolean setData(String data) {
        Mounted mWeapon;
        String unitDamage = null;
        MWClient.mwClientLog.clientOutputLog("PDATA: " + data);
        StringTokenizer ST = new StringTokenizer(data, "$");
        String element = (String)ST.nextElement();
        if (!element.equals("CM")) {
            return false;
        }
        this.setUnitFilename(ST.nextToken());
        this.createEntity();
        if (this.UnitEntity == null) {
            MWClient.mwClientLog.clientErrLog("Cannot load entity!");
            return false;
        }
        this.getC3Type(this.UnitEntity);
        this.setId(Integer.parseInt((String)ST.nextElement()));
        this.setStatus(Integer.parseInt(ST.nextToken()));
        this.setProducer(ST.nextToken());
        String pilotname = "John Denver";
        int gunnery = 4;
        int piloting = 5;
        int exp = 0;
        Pilot p = null;
        StringTokenizer STR = new StringTokenizer(ST.nextToken(), "#");
        pilotname = STR.nextToken();
        exp = Integer.parseInt(STR.nextToken());
        gunnery = Integer.parseInt(STR.nextToken());
        piloting = Integer.parseInt(STR.nextToken());
        p = new Pilot(pilotname, gunnery, piloting);
        p.setExperience(exp);
        int skillAmount = Integer.parseInt(STR.nextToken());
        for (int i = 0; i < skillAmount; ++i) {
            PilotSkill skill = new PilotSkill(Integer.parseInt(STR.nextToken()), STR.nextToken(), Integer.parseInt(STR.nextToken()), STR.nextToken());
            if (skill.getName().equals("Weapon Specialist")) {
                p.setWeapon(STR.nextToken());
            }
            if (skill.getName().equals("Trait")) {
                p.setTraitName(STR.nextToken());
            }
            if (skill.getName().equals("Edge")) {
                p.setTac(Boolean.parseBoolean(STR.nextToken()));
                p.setKO(Boolean.parseBoolean(STR.nextToken()));
                p.setHeadHit(Boolean.parseBoolean(STR.nextToken()));
                p.setExplosion(Boolean.parseBoolean(STR.nextToken()));
            }
            p.getSkills().add(skill);
        }
        if (STR.hasMoreElements()) {
            p.setKills(Integer.parseInt(STR.nextToken()));
        }
        if (STR.hasMoreElements()) {
            STR.nextElement();
        }
        if (STR.hasMoreElements()) {
            STR.nextElement();
        }
        if (STR.hasMoreElements()) {
            p.setHits(Integer.parseInt(STR.nextToken()));
        }
        int mmoptionsamount = Integer.parseInt(ST.nextToken());
        for (int i = 0; i < mmoptionsamount; ++i) {
            MegaMekPilotOption mo = new MegaMekPilotOption(ST.nextToken(), Boolean.parseBoolean(ST.nextToken()));
            p.addMegamekOption(mo);
        }
        this.setType(Integer.parseInt((String)ST.nextElement()));
        this.setType(CUnit.getEntityType(this.UnitEntity));
        this.setPilot(p);
        this.BV = Integer.parseInt(ST.nextToken());
        if (this.BV < 0) {
            this.BV = 0;
        }
        this.setWeightclass(Integer.parseInt(ST.nextToken()));
        if (this.getType() == 0 || this.getType() == 1) {
            this.setWeightclass(CUnit.getEntityWeight(this.UnitEntity));
        }
        this.setId(Integer.parseInt(ST.nextToken()));
        if (this.getModelName().startsWith("Error") || this.getModelName().startsWith("OMG")) {
            this.UnitEntity.setExternalId(this.getId());
            this.UnitEntity.setCrew(new megamek.common.Pilot(p.getName(), p.getGunnery(), p.getPiloting()));
            return true;
        }
        if (this.UnitEntity instanceof Mech) {
            ((Mech)this.UnitEntity).setAutoEject(Boolean.parseBoolean(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            try {
                int maxCrits = Integer.parseInt(ST.nextToken());
                ArrayList<Mounted> e = this.UnitEntity.getAmmo();
                for (int count = 0; count < maxCrits; ++count) {
                    int weaponType = Integer.parseInt(ST.nextToken());
                    String ammoName = ST.nextToken();
                    int shots = Integer.parseInt(ST.nextToken());
                    boolean hotloaded = Boolean.parseBoolean(ST.nextToken());
                    mWeapon = e.get(count);
                    AmmoType at = this.getEntityAmmo(weaponType, ammoName);
                    mWeapon.changeAmmoType(at);
                    mWeapon.setShotsLeft(shots);
                    mWeapon.setHotLoad(hotloaded);
                }
            }
            catch (Exception ex) {
                return true;
            }
        }
        if (ST.hasMoreElements()) {
            int maxMachineGuns = Integer.parseInt(ST.nextToken());
            int currentLocation = 0;
            Entity en = this.UnitEntity;
            Iterator<Mounted> enWeapons = en.getWeapons();
            block5: for (int count = 0; count < maxMachineGuns; ++count) {
                int location = Integer.parseInt(ST.nextToken());
                boolean selection = Boolean.parseBoolean(ST.nextToken());
                while (enWeapons.hasNext()) {
                    mWeapon = enWeapons.next();
                    if (currentLocation == location) {
                        mWeapon.setRapidfire(selection);
                        ++currentLocation;
                        continue block5;
                    }
                    ++currentLocation;
                }
            }
        }
        if (ST.hasMoreElements()) {
            this.UnitEntity.setSpotlight(Boolean.parseBoolean(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.UnitEntity.setSpotlightState(Boolean.parseBoolean(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.pilotBV = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.UnitEntity.setTargSysType(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.scrappableFor = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            unitDamage = ST.nextToken();
        }
        if (ST.hasMoreElements()) {
            this.pilotIsRepairing = Boolean.parseBoolean(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.setRepairCosts(Integer.parseInt(ST.nextToken()), Integer.parseInt(ST.nextToken()));
        }
        this.UnitEntity.setExternalId(this.getId());
        this.UnitEntity.setCrew(new megamek.common.Pilot(p.getName(), p.getGunnery(), p.getPiloting()));
        if (unitDamage != null) {
            UnitUtils.applyBattleDamage(this.UnitEntity, unitDamage);
        }
        return true;
    }

    public void setAutoUnitData(String filename, int distance, int edge) {
        this.setUnitFilename(filename);
        this.setPilot(new Pilot("Autopilot", 4, 5));
        this.createEntity();
        if (distance > 0) {
            this.UnitEntity.setOffBoard(distance, edge);
        }
    }

    public String getSmallDescription() {
        if (this.getType() == 0 || this.getType() == 1) {
            return this.getModelName() + " [" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + "]";
        }
        return this.getModelName() + " [" + this.getPilot().getGunnery() + "]";
    }

    public String getDisplayInfo(String armyText) {
        String capacity;
        String tinfo = "";
        tinfo = this.getType() == 0 && !this.UnitEntity.isOmni() ? "<html><body>#" + this.getId() + " " + this.UnitEntity.getChassis() + ", " + this.getModelName() : "<html><body>#" + this.getId() + " " + this.getModelName();
        tinfo = this.getType() == 0 || this.getType() == 1 ? tinfo + " (" + this.getPilot().getName() + ", " + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ") <br>" : tinfo + " (" + this.getPilot().getName() + ", " + this.getPilot().getGunnery() + ") <br>";
        if (this.getType() == 1) {
            tinfo = tinfo + " Movement: " + this.getEntity().getMovementModeAsString() + "<br>";
        }
        tinfo = tinfo + "BV: " + this.BV + " // Exp: " + this.getPilot().getExperience() + " // Kills: " + this.getPilot().getKills() + "<br> ";
        if (this.getPilot().getSkills().size() > 0) {
            tinfo = tinfo + "Skills: ";
            tinfo = tinfo + this.getPilot().getSkillString(false, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getBasePilotSkill(this.getType()));
            tinfo = tinfo + "<br>";
        }
        if (this.getPilot().getHits() > 0) {
            tinfo = tinfo + "Hits: " + Integer.toString(this.getPilot().getHits()) + "<br>";
        }
        if (!armyText.equals("")) {
            tinfo = tinfo + armyText + "<br>";
        }
        if ((capacity = this.getEntity().getUnusedString()) != null && capacity.startsWith("Troops")) {
            capacity = capacity.substring(9);
            tinfo = tinfo + "Cargo: " + capacity + "<br>";
        }
        if (this.getLifeTimeRepairCost() > 0) {
            tinfo = tinfo + "Repair Costs: " + this.getCurrentRepairCost() + "/" + this.getLifeTimeRepairCost() + "<br>";
        }
        tinfo = tinfo + this.getProducer();
        if (this.scrappableFor > 0 && !Boolean.parseBoolean(this.mwclient.getserverConfigs("UseAdvanceRepair")) && !Boolean.parseBoolean(this.mwclient.getserverConfigs("UseSimpleRepair"))) {
            tinfo = tinfo + "<br><br><b>Scrap Value: " + this.mwclient.moneyOrFluMessage(true, false, this.scrappableFor) + "</b>";
        }
        tinfo = tinfo + "</body></html>";
        return tinfo;
    }

    public String getModelName() {
        if (this.getType() != 0) {
            StringBuilder name = new StringBuilder(new StringTokenizer(this.getEntity().getShortNameRaw()).nextToken());
            name.append(" ").append(this.getEntity().getModel());
            return name.toString();
        }
        if (this.getEntity().isOmni()) {
            return this.UnitEntity.getChassis() + " " + this.UnitEntity.getModel();
        }
        return this.getEntity().getModel();
    }

    public int getBV() {
        if (this.BV < 0) {
            return 0;
        }
        return this.BV;
    }

    public int getBV(boolean c3) {
        if (c3) {
            return this.getOriginalBV(c3) + this.pilotBV;
        }
        if (this.BV < 0) {
            return 0;
        }
        return this.BV;
    }

    public Entity getEntity() {
        return this.UnitEntity;
    }

    public void createEntity() {
        this.UnitEntity = null;
        try {
            MechSummary ms = MechSummaryCache.getInstance().getMech(this.getUnitFilename());
            this.UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
        }
        catch (Exception exep) {
            try {
                MWClient.mwClientLog.clientErrLog("Error loading unit: " + this.getUnitFilename() + ". Try replacing with OMG.");
                MechSummary ms = MechSummaryCache.getInstance().getMech("Error OMG-UR-FD");
                this.UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
            }
            catch (Exception exepe) {
                MWClient.mwClientLog.clientErrLog("Error unit failed to load. Exiting.");
                System.exit(1);
            }
        }
        this.setType(CUnit.getEntityType(this.UnitEntity));
        this.getC3Type(this.UnitEntity);
    }

    public boolean isOmni() {
        boolean isOmni = false;
        String targetChassis = this.getEntity().getChassis();
        if (this.getType() == 1) {
            try {
                FileInputStream fis = new FileInputStream("./data/mechfiles/omnivehiclelist.txt");
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                while (dis.ready()) {
                    String chassie = dis.readLine();
                    if (!targetChassis.equalsIgnoreCase(chassie)) continue;
                    isOmni = true;
                    break;
                }
                dis.close();
                fis.close();
            }
            catch (Exception exception) {}
        } else {
            isOmni = this.getEntity().isOmni();
        }
        return isOmni;
    }

    public int getOriginalBV(boolean C3Network) {
        return this.UnitEntity.calculateBattleValue(C3Network, false);
    }

    public void applyRepairs(String data) {
        this.createEntity();
        UnitUtils.applyBattleDamage(this.UnitEntity, data);
    }

    public boolean getPilotIsReparing() {
        return this.pilotIsRepairing;
    }

    public static int getPriceForUnit(MWClient mwclient, int weightclass, int type_id, House producer) {
        int result = Integer.MAX_VALUE;
        String classtype = Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(type_id) + "Price";
        result = type_id == 0 ? Integer.parseInt(mwclient.getserverConfigs(Unit.getWeightClassDesc(weightclass) + "Price")) : Integer.parseInt(mwclient.getserverConfigs(classtype));
        if ((result += producer.getHouseUnitPriceMod(type_id, weightclass)) < 0) {
            result = 0;
        }
        return result;
    }

    public static int getInfluenceForUnit(MWClient mwclient, int weightclass, int type_id, House producer) {
        int result = Integer.MAX_VALUE;
        String classtype = Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(type_id) + "Inf";
        result = type_id == 0 ? Integer.parseInt(mwclient.getserverConfigs(Unit.getWeightClassDesc(weightclass) + "Inf")) : Integer.parseInt(mwclient.getserverConfigs(classtype));
        if ((result += producer.getHouseUnitFluMod(type_id, weightclass)) < 0) {
            result = 0;
        }
        return result;
    }

    public static int getPPForUnit(MWClient mwclient, int weightclass, int type_id, House producer) {
        int result = Integer.MAX_VALUE;
        String classtype = Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(type_id) + "PP";
        result = type_id == 0 ? Integer.parseInt(mwclient.getserverConfigs(Unit.getWeightClassDesc(weightclass) + "PP")) : Integer.parseInt(mwclient.getserverConfigs(classtype));
        if ((result += producer.getHouseUnitComponentMod(type_id, weightclass)) < 0) {
            result = 0;
        }
        return result;
    }

    public static double getArmorCost(Entity unit, MWClient client) {
        double cost = 0.0;
        if (Boolean.parseBoolean(client.getserverConfigs("UsePartsRepair"))) {
            return 0.0;
        }
        String armorCost = "CostPoint" + UnitUtils.getArmorShortName(unit);
        cost = Double.parseDouble(client.getserverConfigs(armorCost));
        return cost;
    }

    public static double getStructureCost(Entity unit, MWClient client) {
        double cost = 0.0;
        if (Boolean.parseBoolean(client.getserverConfigs("UsePartsRepair"))) {
            return 0.0;
        }
        String armorCost = "CostPoint" + UnitUtils.getInternalShortName(unit) + "IS";
        cost = Double.parseDouble(client.getserverConfigs(armorCost));
        return cost;
    }

    public static double getCritCost(Entity unit, MWClient client, CriticalSlot crit) {
        WeaponType weapon;
        Mounted mounted;
        double cost = 0.0;
        if (Boolean.parseBoolean(client.getserverConfigs("UsePartsRepair"))) {
            return 0.0;
        }
        if (crit == null) {
            return 0.0;
        }
        if (crit.isBreached() && !crit.isDamaged()) {
            return 0.0;
        }
        cost = UnitUtils.isEngineCrit(crit) ? Double.parseDouble(client.getserverConfigs("EngineCritRepairCost")) : (crit.getType() == 0 ? (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("SystemCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("SystemCritRepairCost"))) : ((mounted = unit.getEquipment(crit.getIndex())).getType() instanceof WeaponType ? ((weapon = (WeaponType)mounted.getType()).hasFlag(262144L) ? (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("EnergyWeaponCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("EnergyWeaponCritRepairCost"))) : (weapon.hasFlag(131072L) ? (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("BallisticCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("BallisticCritRepairCost"))) : (weapon.hasFlag(524288L) ? (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("MissileCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("MissileCritRepairCost"))) : (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("EquipmentCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("EquipmentCritRepairCost")))))) : (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("EquipmentCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("EquipmentCritRepairCost")))));
        cost = Math.max(cost, 1.0);
        return cost;
    }
}

