/*
 * Decompiled with CFR 0.152.
 */
package client.cmd;

import client.MWClient;
import client.cmd.Command;
import common.util.UnitUtils;
import java.util.Enumeration;
import java.util.StringTokenizer;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Building;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;
import megamek.server.Server;

public class RGTS
extends Command {
    private Server server = null;

    public RGTS(MWClient mwclient) {
        super(mwclient);
    }

    public void execute(String input) {
        Entity ent;
        this.server = this.mwclient.getMyServer();
        StringBuilder result = new StringBuilder();
        String name = "";
        String winnerName = "";
        if (this.server.getGame().getVictoryTeam() != 0) {
            int numberOfWinners = 0;
            Enumeration<Player> en = this.server.getGame().getPlayers();
            while (en.hasMoreElements()) {
                Player p = en.nextElement();
                if (p.getTeam() != this.server.getGame().getVictoryTeam()) continue;
                StringTokenizer st = new StringTokenizer(p.getName().trim(), "~");
                name = "";
                while (st.hasMoreElements()) {
                    name = st.nextToken().trim();
                }
                winnerName = winnerName + name;
                if (++numberOfWinners <= 0) continue;
                winnerName = winnerName + "*";
            }
            winnerName = winnerName + "#";
        } else if (this.server.getGame().getVictoryPlayerId() == -1) {
            winnerName = "DRAW#";
        } else {
            winnerName = this.server.getGame().getPlayer(this.server.getGame().getVictoryPlayerId()).getName();
            StringTokenizer st = new StringTokenizer(winnerName, "~");
            name = "";
            while (st.hasMoreElements()) {
                name = st.nextToken().trim();
            }
            winnerName = name + "#";
        }
        result.append(winnerName);
        Enumeration<Entity> en = this.server.getGame().getDevastatedEntities();
        while (en.hasMoreElements()) {
            ent = en.nextElement();
            if (ent.getOwner().getName().startsWith("War Bot")) continue;
            result.append(this.serializeEntity(ent, true, false) + "#");
        }
        en = this.server.getGame().getGraveyardEntities();
        while (en.hasMoreElements()) {
            ent = en.nextElement();
            if (ent.getOwner().getName().startsWith("War Bot")) continue;
            if (ent instanceof Mech && ent.getInternal(1) <= 0) {
                result.append(this.serializeEntity(ent, true, true) + "#");
                continue;
            }
            result.append(this.serializeEntity(ent, true, false) + "#");
        }
        en = this.server.getGame().getEntities();
        while (en.hasMoreElements()) {
            ent = en.nextElement();
            if (ent.getOwner().getName().startsWith("War Bot")) continue;
            if (ent instanceof Mech && ent.getInternal(1) <= 0) {
                result.append(this.serializeEntity(ent, true, true) + "#");
                continue;
            }
            result.append(this.serializeEntity(ent, true, false) + "#");
        }
        en = this.server.getGame().getRetreatedEntities();
        while (en.hasMoreElements()) {
            ent = en.nextElement();
            if (ent.getOwner().getName().startsWith("War Bot")) continue;
            if (ent instanceof Mech && ent.getInternal(1) <= 0) {
                result.append(this.serializeEntity(ent, true, true) + "#");
                continue;
            }
            result.append(this.serializeEntity(ent, true, false) + "#");
        }
        if (this.mwclient.getBuildingTemplate() != null) {
            result.append("BL*" + this.getBuildingsLeft());
        }
        MWClient.mwClientLog.clientOutputLog("CR|" + result);
        this.mwclient.serverSend("CR|" + result.toString());
        this.mwclient.serverSend("SHS|" + this.mwclient.myUsername + "|Open");
    }

    public String serializeEntity(Entity e, boolean fullStatus, boolean forceDevastate) {
        StringBuilder result = new StringBuilder();
        boolean useRepairs = this.mwclient.isUsingAdvanceRepairs();
        if (fullStatus) {
            if (!(e instanceof MechWarrior)) {
                result.append(e.getExternalId() + "*");
                result.append(e.getOwner().getName() + "*");
                result.append(e.getCrew().getHits() + "*");
                if (forceDevastate) {
                    result.append("1024*");
                } else {
                    result.append(e.getRemovalCondition() + "*");
                }
                if (e instanceof BipedMech) {
                    result.append("0*");
                } else if (e instanceof QuadMech) {
                    result.append("5*");
                } else if (e instanceof Tank) {
                    result.append("1*");
                } else if (e instanceof Protomech) {
                    result.append("3*");
                } else if (e instanceof BattleArmor) {
                    result.append("4*");
                } else {
                    result.append("2*");
                }
                Enumeration<Entity> en = e.getKills();
                if (!en.hasMoreElements()) {
                    result.append(" *");
                }
                while (en.hasMoreElements()) {
                    Entity kill = en.nextElement();
                    result.append(kill.getExternalId());
                    if (en.hasMoreElements()) {
                        result.append("~");
                        continue;
                    }
                    result.append("*");
                }
            }
            if (e instanceof Mech) {
                result.append(e.getCrew().isUnconscious() + "*");
                result.append(e.getInternal(1) + "*");
                result.append(e.getInternal(0) + "*");
                result.append(e.getInternal(7) + "*");
                result.append(e.getInternal(6) + "*");
                result.append(e.getInternal(5) + "*");
                result.append(e.getInternal(4) + "*");
                result.append(e.getBadCriticals(0, 4, 1) + "*");
                result.append(((Mech)e).getCockpitType() + "*");
                if (useRepairs) {
                    result.append(UnitUtils.unitBattleDamage(e) + "*");
                }
            } else if (e instanceof Tank) {
                result.append(e.isRepairable() + "*");
                result.append(e.isImmobile() + "*");
                result.append(e.getCrew().isDead() + "*");
                if (useRepairs) {
                    result.append(UnitUtils.unitBattleDamage(e) + "*");
                }
            } else if (e instanceof MechWarrior) {
                MechWarrior mw = (MechWarrior)e;
                result.append("MW*");
                result.append(mw.getOriginalRideExternalId() + "*");
                result.append(mw.getPickedUpByExternalId() + "*");
                result.append(mw.isDestroyed() + "*");
            }
            if (e.isOffBoard()) {
                result.append(e.getOffBoardDistance() + "*");
            }
        } else if (e instanceof MechWarrior) {
            MechWarrior mw = (MechWarrior)e;
            result.append("MW*" + mw.getOriginalRideExternalId() + "*");
            result.append(mw.getPickedUpByExternalId() + "*");
            result.append(mw.isDestroyed() + "*");
        } else {
            result.append(e.getOwner().getName() + "*");
            result.append(e.getExternalId() + "*");
            if (forceDevastate) {
                result.append("1024*");
            } else {
                result.append(e.getRemovalCondition() + "*");
            }
            if (e instanceof Mech) {
                result.append(e.getInternal(1) + "*");
                result.append(e.getInternal(0) + "*");
            } else {
                result.append("1*");
                result.append("1*");
            }
            result.append(e.isRepairable() + "*");
        }
        return result.toString();
    }

    public int getBuildingsLeft() {
        Enumeration<Building> buildings = this.server.getGame().getBoard().getBuildings();
        int buildingCount = 0;
        while (buildings.hasMoreElements()) {
            buildings.nextElement();
            ++buildingCount;
        }
        return buildingCount;
    }
}

