/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CArmy;
import client.gui.dialog.ArmyViewerDialog;
import client.gui.dialog.PlanetNameDialog;
import client.gui.dialog.PlayerNameDialog;
import common.House;
import common.Planet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.MenuKeyListener;

public class AttackMenu
extends JMenu
implements ActionListener {
    private static final long serialVersionUID = 7420602115238025725L;
    private MWClient mwclient;
    private int armyID;
    private String planetName;

    public AttackMenu(MWClient mwclient, int armyID, String planetName) {
        super("Attack");
        this.mwclient = mwclient;
        this.armyID = armyID;
        this.planetName = planetName;
    }

    public void updateMenuItems(boolean fullMenu) {
        this.removeAll();
        TreeMap<String, String[]> allOps = this.mwclient.getAllOps();
        if (this.armyID < 0) {
            TreeSet<String> allEligibles = new TreeSet<String>();
            if (this.planetName == null || this.planetName.trim().equals("") || this.planetName.equals("-1")) {
                for (CArmy currA : this.mwclient.getPlayer().getArmies()) {
                    allEligibles.addAll(currA.getLegalOperations());
                }
            } else {
                Planet tp = this.mwclient.getData().getPlanetByName(this.planetName);
                int houseID = this.mwclient.getPlayer().getHouseFightingFor().getId();
                TreeSet<String> tempEligibles = new TreeSet<String>();
                for (CArmy currA : this.mwclient.getPlayer().getArmies()) {
                    tempEligibles.addAll(currA.getLegalOperations());
                }
                for (String currOpName : tempEligibles) {
                    String key;
                    StringTokenizer st;
                    String[] opProps = this.mwclient.getAllOps().get(currOpName);
                    double range = Double.parseDouble(opProps[0]);
                    String facInfo = opProps[3];
                    String homeInfo = opProps[4];
                    int launchOn = Integer.parseInt(opProps[5]);
                    int launchFrom = Integer.parseInt(opProps[6]);
                    int minOwn = Integer.parseInt(opProps[7]);
                    int maxOwn = Integer.parseInt(opProps[8]);
                    String legalDefenders = opProps[9];
                    String allowPlanetFlags = opProps[10] + "^";
                    String disallowPlanetFlags = opProps[11] + "^";
                    if (!legalDefenders.startsWith("allFactions")) {
                        TreeMap legalDefTree = new TreeMap();
                        StringTokenizer legalDefTokenizer = new StringTokenizer(legalDefenders, "$");
                        while (legalDefTokenizer.hasMoreTokens()) {
                            legalDefTree.put(legalDefTokenizer.nextToken(), null);
                        }
                        Iterator<House> i = tp.getInfluence().getHouses().iterator();
                        boolean foundDefender = false;
                        while (i.hasNext() && !foundDefender) {
                            House currH = i.next();
                            if (!legalDefTree.containsKey(currH.getName())) continue;
                            foundDefender = true;
                        }
                        if (!foundDefender) continue;
                    }
                    if (tp.getFactoryCount() > 0 && facInfo.equals("none") || tp.getFactoryCount() < 1 && facInfo.equals("only") || tp.isHomeWorld() && homeInfo.equals("none") || !tp.isHomeWorld() && homeInfo.equals("only") || tp.getInfluence().getInfluence(houseID) < minOwn || tp.getInfluence().getInfluence(houseID) > maxOwn) continue;
                    if (tp.getInfluence().getInfluence(houseID) >= launchOn) {
                        allEligibles.add(currOpName);
                        continue;
                    }
                    if (allowPlanetFlags.length() > 0) {
                        boolean allowOp = true;
                        st = new StringTokenizer(allowPlanetFlags, "^");
                        while (st.hasMoreTokens()) {
                            key = st.nextToken();
                            if (key.trim().length() < 1 || tp.getPlanetFlags().containsKey(key)) continue;
                            MWClient.mwClientLog.clientErrLog(tp.getName() + " does not have flag: " + key);
                            allowOp = false;
                            break;
                        }
                        if (!allowOp) continue;
                    }
                    if (disallowPlanetFlags.length() > 0) {
                        boolean allowOp = true;
                        st = new StringTokenizer(disallowPlanetFlags, "^");
                        while (st.hasMoreTokens()) {
                            key = st.nextToken();
                            if (key.trim().length() < 1 || !tp.getPlanetFlags().containsKey(key)) continue;
                            allowOp = false;
                            MWClient.mwClientLog.clientErrLog(tp.getName() + " has flag: " + key);
                            break;
                        }
                        if (!allowOp) continue;
                    }
                    Iterator<Planet> i = this.mwclient.getData().getAllPlanets().iterator();
                    boolean launchFound = false;
                    while (i.hasNext() && !launchFound) {
                        double tdist;
                        Planet currP = i.next();
                        if (currP.getInfluence().getInfluence(houseID) < launchFrom || !((tdist = currP.getPosition().distanceSq(tp.getPosition())) <= range)) continue;
                        launchFound = true;
                        allEligibles.add(currOpName);
                    }
                }
            }
            Iterator i = allEligibles.iterator();
            while (i.hasNext()) {
                String[] currProperties = this.mwclient.getAllOps().get(i.next());
                if (!Boolean.parseBoolean(currProperties[12])) continue;
                i.remove();
            }
            if (allEligibles.size() <= 0) {
                JMenuItem filler = new JMenuItem("None");
                this.add(filler);
            }
            for (String currName : allEligibles) {
                if (!allOps.containsKey(currName)) {
                    MWClient.mwClientLog.clientErrLog("Error in updateMenuItems(): no _" + currName + "_ in allOps.");
                    StringBuilder allOpsList = new StringBuilder("allOps contains: ");
                    for (String currO : allOps.keySet()) {
                        allOpsList.append(currO + " ");
                    }
                    MWClient.mwClientLog.clientErrLog(allOpsList.toString());
                    continue;
                }
                String[] settings = allOps.get(currName);
                String color = settings[1];
                String menuItemName = "";
                menuItemName = !fullMenu ? "<html><font color=" + color + ">" + currName + "</font></html>" : " - " + currName;
                JMenuItem currItem = new JMenuItem(menuItemName);
                currItem.addActionListener(this);
                currItem.setActionCommand(currName);
                this.add(currItem);
            }
        } else {
            CArmy clickArmy = this.mwclient.getPlayer().getArmy(this.armyID);
            if (clickArmy != null) {
                if (clickArmy.getLegalOperations().size() <= 0) {
                    JMenuItem filler = new JMenuItem("None");
                    this.add(filler);
                }
                for (String currName : clickArmy.getLegalOperations()) {
                    if (!allOps.containsKey(currName)) {
                        MWClient.mwClientLog.clientErrLog("Error in updateMenuItems(): no _" + currName + "_ in allOps.");
                        String allOpsList = "allOps contains: ";
                        for (String currO : allOps.keySet()) {
                            allOpsList = allOpsList + currO + " ";
                        }
                        MWClient.mwClientLog.clientErrLog(allOpsList);
                        continue;
                    }
                    String[] settings = allOps.get(currName);
                    String color = settings[1];
                    String menuItemName = "";
                    menuItemName = !fullMenu ? "<html><font color=" + color + ">" + currName + "</font></html>" : " - " + currName;
                    JMenuItem currItem = new JMenuItem(menuItemName);
                    currItem.addActionListener(this);
                    currItem.setActionCommand(currName);
                    this.add(currItem);
                }
            }
        }
        if (fullMenu) {
            int i;
            this.setText("Games");
            this.setMnemonic('G');
            JMenuItem toAdd = new JMenuItem("Attacks:");
            MouseListener[] mouse = toAdd.getMouseListeners();
            FocusListener[] focus = toAdd.getFocusListeners();
            MenuKeyListener[] menukey = toAdd.getMenuKeyListeners();
            PropertyChangeListener[] property = toAdd.getPropertyChangeListeners();
            for (i = 0; i < mouse.length; ++i) {
                toAdd.removeMouseListener(mouse[i]);
            }
            for (i = 0; i < focus.length; ++i) {
                toAdd.removeFocusListener(focus[i]);
            }
            for (i = 0; i < menukey.length; ++i) {
                toAdd.removeFocusListener(focus[i]);
            }
            for (i = 0; i < property.length; ++i) {
                toAdd.removePropertyChangeListener(property[i]);
            }
            this.add((Component)toAdd, 0);
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowAttackFromReserve")) && this.mwclient.getMyStatus() == 2) {
                this.add(new JSeparator());
                toAdd = new JMenuItem("Attack From Reserve");
                toAdd.addActionListener(this);
                toAdd.setActionCommand("cmdAttackFromReserve");
                this.add(toAdd);
            }
            this.add(new JSeparator());
            toAdd = new JMenuItem("Check Access");
            toAdd.addActionListener(this);
            toAdd.setActionCommand("cmdCheckAccess");
            this.add(toAdd);
            toAdd = new JMenuItem("Games Status");
            toAdd.addActionListener(this);
            toAdd.setActionCommand("cmdGamesStatus");
            toAdd.setMnemonic('G');
            this.add(toAdd);
            if (this.mwclient.getMyStatus() >= 3) {
                toAdd = new JMenuItem("Cancel Game");
                toAdd.addActionListener(this);
                toAdd.setActionCommand("cmdCancelGames");
                this.add(toAdd);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String name = e.getActionCommand();
        if (name.equals("cmdCancelGames")) {
            this.mwclient.sendChat("/c terminate");
            return;
        }
        if (name.equals("cmdCheckAccess")) {
            if (this.mwclient.getPlayer().getArmies().size() <= 0) {
                String toUser = "CH|CLIENT: It's impossible to check legality when you have no armies.";
                this.mwclient.doParseDataInput(toUser);
                return;
            }
            TreeSet<String> names = new TreeSet<String>();
            for (CArmy currArmy : this.mwclient.getPlayer().getArmies()) {
                names.add("#" + currArmy.getID() + " - BV: " + currArmy.getBV());
            }
            JComboBox<Object> armyCombo = new JComboBox<Object>(names.toArray());
            armyCombo.setEditable(false);
            JComboBox<Object> attackCombo = new JComboBox<Object>(this.mwclient.getAllOps().keySet().toArray());
            attackCombo.setEditable(false);
            JPanel holderPanel = new JPanel();
            holderPanel.setLayout(new BoxLayout(holderPanel, 1));
            holderPanel.add(armyCombo);
            holderPanel.add(attackCombo);
            JOptionPane jop = new JOptionPane(holderPanel, 3, 2);
            JDialog dlg = jop.createDialog(null, "Select army and attack type.");
            armyCombo.grabFocus();
            armyCombo.getEditor().selectAll();
            dlg.setVisible(true);
            if ((Integer)jop.getValue() == 2) {
                return;
            }
            String attackName = (String)attackCombo.getSelectedItem();
            String armyName = (String)armyCombo.getSelectedItem();
            this.armyID = Integer.parseInt(armyName.substring(1, armyName.indexOf(" ")).trim());
            this.mwclient.sendChat("/c checkarmyeligibility#" + this.armyID + "#" + attackName);
            return;
        }
        if (name.equals("cmdGamesStatus")) {
            this.mwclient.sendChat("/c games");
            return;
        }
        if (name.equals("cmdAttackFromReserve")) {
            String planet = "";
            String target = "";
            String Op = "";
            TreeSet<String> allEligibles = new TreeSet<String>();
            for (CArmy currA : this.mwclient.getPlayer().getArmies()) {
                allEligibles.addAll(currA.getLegalOperations());
            }
            Iterator i = allEligibles.iterator();
            while (i.hasNext()) {
                String[] currProperties = this.mwclient.getAllOps().get(i.next());
                if (!Boolean.parseBoolean(currProperties[13])) continue;
                i.remove();
            }
            JComboBox<Object> attackCombo = new JComboBox<Object>(allEligibles.toArray());
            attackCombo.setEditable(false);
            JOptionPane jop = new JOptionPane(attackCombo, 3, 2);
            JDialog dlg = jop.createDialog(null, "Select an operation.");
            dlg.setVisible(true);
            if ((Integer)jop.getValue() == 2) {
                return;
            }
            Op = (String)attackCombo.getSelectedItem();
            String[] opProperties = this.mwclient.getAllOps().get(Op);
            PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Choose a planet", opProperties);
            planetDialog.setVisible(true);
            planet = planetDialog.getPlanetName();
            planetDialog.dispose();
            if (planet == null) {
                return;
            }
            PlayerNameDialog playerDialog = new PlayerNameDialog(this.mwclient, "Select an opponent", 0);
            playerDialog.setVisible(true);
            target = playerDialog.getPlayerName();
            playerDialog.dispose();
            if (target == null) {
                return;
            }
            new ArmyViewerDialog(this.mwclient, Op, null, 2, planet, target, -1, -1);
            return;
        }
        if (this.mwclient.getMyStatus() < 3) {
            String toUser = "CH|CLIENT: You must be active in order to initiate standard attacks.";
            this.mwclient.doParseDataInput(toUser);
            return;
        }
        if (this.mwclient.getMyStatus() == 4) {
            String toUser = "CH|CLIENT: You may not initiate an attack while you are in a game.";
            this.mwclient.doParseDataInput(toUser);
            return;
        }
        if (this.planetName.equals("-1")) {
            String[] opProperties = this.mwclient.getAllOps().get(name);
            PlanetNameDialog planetdialog = new PlanetNameDialog(this.mwclient, "Select a planet to attack.", opProperties);
            planetdialog.setVisible(true);
            this.planetName = planetdialog.getPlanetName();
            planetdialog.dispose();
            if (this.planetName == null || this.planetName.trim().length() == 0) {
                return;
            }
        }
        if (this.armyID < 0) {
            new ArmyViewerDialog(this.mwclient, name, null, 1, this.planetName, null, -1, -1);
        } else {
            this.mwclient.sendChat("/c attack#" + name + "#" + this.armyID + "#" + this.planetName);
        }
    }
}

