/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CBMUnit;
import client.campaign.CCampaign;
import java.awt.Color;
import java.awt.Component;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class BlackMarketModel
extends AbstractTableModel {
    private static final long serialVersionUID = -783116408720137035L;
    public MWClient mwclient;
    CCampaign theCampaign;
    public TreeMap mechs;
    public TreeMap bids;
    public Object[] sortedMechs;
    public static final int MECH = 0;
    public static final int BV = 1;
    public static final int MIN = 2;
    public static final int TICKS = 3;
    public static final int BID = 4;
    public static final int AUCTION_ID = 5;
    final String[] columnNames = new String[]{"Unit", "Stock BV", "Min Bid", "Ticks", "Your Bid"};
    final String[] longValues = new String[]{"XXXXXX-XXXX-XXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX"};

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public BlackMarketModel(MWClient client) {
        this.mwclient = client;
        this.theCampaign = this.mwclient.getCampaign();
        this.mechs = this.theCampaign.getBlackMarket();
        this.sortedMechs = this.mechs.values().toArray();
    }

    public void refreshModel() {
        this.sortedMechs = this.mechs.values().toArray();
        this.fireTableDataChanged();
    }

    public void initColumnSizes(JTable table) {
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        BlackMarketModel model = this;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, this.longValues[i], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    public int getRowCount() {
        return this.sortedMechs.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0) {
            return "";
        }
        if (row >= this.sortedMechs.length) {
            return "";
        }
        CBMUnit mm = (CBMUnit)this.sortedMechs[row];
        switch (col) {
            case 0: {
                return mm.getModelName();
            }
            case 1: {
                return mm.getEmbeddedUnit().getEntity().calculateBattleValue(false, false);
            }
            case 2: {
                return new Integer(mm.getMinBid());
            }
            case 3: {
                return new Integer(mm.getTicks());
            }
            case 4: {
                if (mm.getBid() > 0) {
                    return new Integer(mm.getBid());
                }
                return null;
            }
            case 5: {
                return new Integer(mm.getAuctionID());
            }
        }
        return "";
    }

    public Renderer getRenderer() {
        return new Renderer();
    }

    private class Renderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 5506902358006897558L;

        private Renderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component d = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel c = new JLabel();
            c.setOpaque(true);
            if (BlackMarketModel.this.mechs.size() < row || row < 0) {
                return c;
            }
            if (table.getModel().getValueAt(row, column) != null) {
                c.setText(table.getModel().getValueAt(row, column).toString());
            }
            c.setToolTipText("");
            CBMUnit mm = (CBMUnit)BlackMarketModel.this.mechs.get(table.getModel().getValueAt(row, 5));
            String description = "<html><body>#" + mm.getAuctionID() + " " + mm.getEmbeddedUnit().getEntity().getChassis() + " (" + mm.getEmbeddedUnit().getEntity().getModel() + ")<br>";
            if (mm.getEmbeddedUnit().getC3Level() > 0) {
                if (mm.getEmbeddedUnit().getC3Level() == 1) {
                    description = description + "<br>C3 Slave";
                } else if (mm.getEmbeddedUnit().getC3Level() == 2) {
                    description = description + "<br>C3 Master";
                } else if (mm.getEmbeddedUnit().getC3Level() == 3) {
                    description = description + "<br>C3 Improved";
                }
            }
            description = description + "</body></html>";
            c.setToolTipText(description);
            if (isSelected) {
                c.setForeground(d.getForeground());
                c.setBackground(d.getBackground());
                return c;
            }
            if (mm.playerIsSeller()) {
                c.setBackground(Color.lightGray);
            } else if (table.getModel().getValueAt(row, 4) != null) {
                c.setBackground(Color.green);
            } else {
                c.setBackground(Color.white);
            }
            return c;
        }
    }
}

