/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CCampaign;
import common.BMEquipment;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class BlackMarketPartsModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4312857440681697117L;
    public MWClient mwclient;
    CCampaign theCampaign;
    public TreeMap<String, BMEquipment> components;
    public Object[] sortedComponents = null;
    private String type = "";
    public static final int PART = 0;
    public static final int TECH = 1;
    public static final int COST = 2;
    public static final int AMOUNT = 3;
    final String[] columnNames = new String[]{"Part", "Tech", "Cost", "Amount"};
    final String[] longValues = new String[]{"XXXXXX-XXXX-XXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX"};

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public BlackMarketPartsModel(MWClient client, String type) {
        this.mwclient = client;
        this.theCampaign = this.mwclient.getCampaign();
        this.type = type;
        this.components = this.theCampaign.getBlackMarketParts();
        this.filter();
    }

    public void refreshModel() {
        this.filter();
        this.fireTableDataChanged();
    }

    private void filter() {
        TreeMap<String, BMEquipment> tempTree = new TreeMap<String, BMEquipment>();
        for (String key : this.components.keySet()) {
            BMEquipment eq = this.components.get(key);
            if (!eq.getEquipmentType().equals(this.type)) continue;
            tempTree.put(key, eq);
        }
        if (tempTree.size() > 0) {
            this.sortedComponents = tempTree.values().toArray();
        }
    }

    public void initColumnSizes(JTable table) {
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        BlackMarketPartsModel model = this;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, this.longValues[i], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    public int getRowCount() {
        if (this.sortedComponents == null) {
            return 0;
        }
        return this.sortedComponents.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0) {
            return "";
        }
        if (row >= this.sortedComponents.length) {
            return "";
        }
        BMEquipment bme = (BMEquipment)this.sortedComponents[row];
        switch (col) {
            case 0: {
                return bme.getEquipmentName();
            }
            case 2: {
                DecimalFormat df = new DecimalFormat("#,###,###,##0.00");
                return df.format(bme.getCost());
            }
            case 1: {
                return bme.getTech();
            }
            case 3: {
                if (this.mwclient.getPlayer().getPartsCache().getPartsCritCount(bme.getEquipmentInternalName()) < 1) {
                    return bme.getAmount();
                }
                return bme.getAmount() + "(" + this.mwclient.getPlayer().getPartsCache().getPartsCritCount(bme.getEquipmentInternalName()) + ")";
            }
        }
        return "";
    }

    public Renderer getRenderer() {
        return new Renderer();
    }

    class Renderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 5506902358006897558L;

        Renderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component d = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel c = new JLabel();
            c.setOpaque(true);
            if (BlackMarketPartsModel.this.components.size() < row || row < 0) {
                return c;
            }
            if (table.getModel().getValueAt(row, column) != null) {
                c.setText(table.getModel().getValueAt(row, column).toString());
            }
            c.setToolTipText("");
            BMEquipment bme = BlackMarketPartsModel.this.components.get(table.getModel().getValueAt(row, 0));
            String description = "<html><body>" + bme.getEquipmentName() + " C:" + bme.getCost() + " A:" + bme.getAmount() + " T:" + bme.getTech() + "<br>";
            description = description + "</body></html>";
            c.setToolTipText(description);
            if (isSelected) {
                c.setForeground(d.getForeground());
                c.setBackground(d.getBackground());
                return c;
            }
            if (row % 2 == 0) {
                c.setBackground(Color.lightGray);
            } else {
                c.setBackground(Color.white);
            }
            if (bme.isCostUp()) {
                c.setForeground(new Color(195, 11, 0));
            } else {
                c.setForeground(new Color(3, 149, 50));
            }
            return c;
        }
    }
}

