/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CCampaign;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import client.gui.HSMek;
import client.gui.MMNetHyperLinkListener;
import client.gui.MyHTMLEditorKit;
import client.gui.SpringLayoutHelper;
import client.gui.dialog.MechDetailDisplay;
import common.House;
import common.Unit;
import common.util.UnitUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.border.LineBorder;
import megamek.common.Entity;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Pilot;

public class CHSPanel
extends JPanel {
    MWClient mwclient;
    CPlayer thePlayer;
    CCampaign theCampaign;
    JEditorPane mainPane = new JEditorPane();
    JScrollPane scrollPane = new JScrollPane();
    MyHTMLEditorKit kit = new MyHTMLEditorKit();
    GridBagConstraints gridBagConstraints;
    private JPanel pnlBtns = new JPanel();
    private JPanel hsButtonSpringPanel = new JPanel();
    private JButton buyNewButton = new JButton();
    private JButton buyUsedButton = new JButton();
    private JLabel lblInfo = new JLabel();
    private BuyPopupListener myPopup = null;
    private String HouseName;
    private TreeMap<String, String> componentsInfo;
    private TreeMap<String, TreeMap<String, String>> factoriesInfo;
    private TreeMap<String, Vector<HSMek>> unitsInfo;

    public CHSPanel(MWClient client) {
        this.setLayout(new GridBagLayout());
        this.mwclient = client;
        this.theCampaign = this.mwclient.getCampaign();
        this.thePlayer = this.theCampaign.getPlayer();
        this.myPopup = new BuyPopupListener();
        this.mainPane.setEditorKit(this.kit);
        this.mainPane.setEditable(false);
        this.mainPane.addHyperlinkListener(new MMNetHyperLinkListener(this.mwclient, this));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setViewportBorder(new LineBorder(new Color(0, 0, 0)));
        this.scrollPane.setViewportView(this.mainPane);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, this.gridBagConstraints);
        this.pnlBtns.setLayout(new BoxLayout(this.pnlBtns, 1));
        this.hsButtonSpringPanel = new JPanel(new SpringLayout());
        this.buyNewButton.setText("Buy New");
        this.buyNewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CHSPanel.this.buyNewButtonActionPerformed(evt);
            }
        });
        this.buyNewButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                CHSPanel.this.buyNewUnitMouseEvent(evt);
            }
        });
        this.hsButtonSpringPanel.add(this.buyNewButton);
        this.buyUsedButton.setText("Buy Used");
        this.buyUsedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CHSPanel.this.buyUsedButtonActionPerformed(evt);
            }
        });
        this.buyUsedButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                CHSPanel.this.buyUsedUnitMouseEvent(evt);
            }
        });
        this.hsButtonSpringPanel.add(this.buyUsedButton);
        SpringLayoutHelper.setupSpringGrid(this.hsButtonSpringPanel, 1, 3);
        this.lblInfo.setAlignmentX(0.5f);
        this.lblInfo.setSize(0, 0);
        this.pnlBtns.add(this.lblInfo);
        this.pnlBtns.add(this.hsButtonSpringPanel);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 0.0;
        this.add((Component)this.pnlBtns, this.gridBagConstraints);
        this.componentsInfo = new TreeMap();
        this.factoriesInfo = new TreeMap();
        this.unitsInfo = new TreeMap();
    }

    public void setFactionName(String name) {
        this.HouseName = name;
    }

    public void clearHouseStatusData() {
        this.componentsInfo.clear();
        this.factoriesInfo.clear();
        this.unitsInfo.clear();
    }

    public void addFactionUnit(String unitData) {
        StringTokenizer tokenizer = new StringTokenizer(unitData, "$");
        String weight = tokenizer.nextToken();
        String type = tokenizer.nextToken();
        HSMek currHSUnit = new HSMek(this.mwclient, tokenizer);
        Vector<HSMek> weightAndTypeVec = this.unitsInfo.get(weight + "$" + type);
        if (weightAndTypeVec == null) {
            weightAndTypeVec = new Vector();
            this.unitsInfo.put(weight + "$" + type, weightAndTypeVec);
        }
        weightAndTypeVec.add(currHSUnit);
    }

    public void removeFactionUnit(String unitData) {
        StringTokenizer tokenizer = new StringTokenizer(unitData, "$");
        String weight = tokenizer.nextToken();
        String type = tokenizer.nextToken();
        int unitID = Integer.valueOf(tokenizer.nextToken());
        Vector<HSMek> weightAndTypeVec = this.unitsInfo.get(weight + "$" + type);
        if (weightAndTypeVec == null) {
            return;
        }
        Iterator<HSMek> i = weightAndTypeVec.iterator();
        while (i.hasNext()) {
            HSMek currHSMek = i.next();
            if (currHSMek.getUnitID() != unitID) continue;
            i.remove();
            return;
        }
    }

    public void changeFactionComponents(String componentData) {
        StringTokenizer tokenizer = new StringTokenizer(componentData, "$");
        String weight = tokenizer.nextToken();
        String type = tokenizer.nextToken();
        String currentPP = tokenizer.nextToken();
        String prodUnits = tokenizer.nextToken();
        this.componentsInfo.remove(weight + "$" + type);
        this.componentsInfo.put(weight + "$" + type, currentPP + "$" + prodUnits);
    }

    public void addFactionFactory(String factoryData) {
        StringTokenizer tokenizer = new StringTokenizer(factoryData, "$");
        int weight = Integer.valueOf(tokenizer.nextToken());
        int type = Integer.valueOf(tokenizer.nextToken());
        String founder = tokenizer.nextToken();
        String planet = tokenizer.nextToken();
        String factoryName = tokenizer.nextToken();
        int timeToRefresh = Integer.valueOf(tokenizer.nextToken());
        if (this.canProduce(0, type)) {
            this.addFactoryHelper(weight, new Integer(0), timeToRefresh, founder, planet, factoryName);
        }
        if (this.canProduce(1, type)) {
            this.addFactoryHelper(weight, new Integer(1), timeToRefresh, founder, planet, factoryName);
        }
        if (this.canProduce(2, type)) {
            this.addFactoryHelper(weight, new Integer(2), timeToRefresh, founder, planet, factoryName);
        }
        if (this.canProduce(3, type)) {
            this.addFactoryHelper(weight, new Integer(3), timeToRefresh, founder, planet, factoryName);
        }
        if (this.canProduce(4, type)) {
            this.addFactoryHelper(weight, new Integer(4), timeToRefresh, founder, planet, factoryName);
        }
    }

    public void removeFactionFactory(String factoryData) {
        StringTokenizer tokenizer = new StringTokenizer(factoryData, "$");
        int weight = Integer.valueOf(tokenizer.nextToken());
        int type = Integer.valueOf(tokenizer.nextToken());
        String planet = tokenizer.nextToken();
        String factoryName = tokenizer.nextToken();
        if (this.canProduce(0, type)) {
            this.removeFactoryHelper(weight, 0, planet, factoryName);
        }
        if (this.canProduce(1, type)) {
            this.removeFactoryHelper(weight, 1, planet, factoryName);
        }
        if (this.canProduce(2, type)) {
            this.removeFactoryHelper(weight, 2, planet, factoryName);
        }
        if (this.canProduce(3, type)) {
            this.removeFactoryHelper(weight, 3, planet, factoryName);
        }
        if (this.canProduce(4, type)) {
            this.removeFactoryHelper(weight, 4, planet, factoryName);
        }
    }

    public void changeFactionFactory(String factoryData) {
        StringTokenizer tokenizer = new StringTokenizer(factoryData, "$");
        int weight = Integer.valueOf(tokenizer.nextToken());
        int type = Integer.valueOf(tokenizer.nextToken());
        String planet = tokenizer.nextToken();
        String factoryName = tokenizer.nextToken();
        int timeToRefresh = Integer.valueOf(tokenizer.nextToken());
        if (this.canProduce(0, type)) {
            this.changeFactoryHelper(weight, 0, planet, factoryName, timeToRefresh);
        }
        if (this.canProduce(1, type)) {
            this.changeFactoryHelper(weight, 1, planet, factoryName, timeToRefresh);
        }
        if (this.canProduce(2, type)) {
            this.changeFactoryHelper(weight, 2, planet, factoryName, timeToRefresh);
        }
        if (this.canProduce(3, type)) {
            this.changeFactoryHelper(weight, 3, planet, factoryName, timeToRefresh);
        }
        if (this.canProduce(4, type)) {
            this.changeFactoryHelper(weight, 4, planet, factoryName, timeToRefresh);
        }
    }

    private void addFactoryHelper(int weight, int type, int timeToRefresh, String founder, String planet, String factoryName) {
        TreeMap<String, String> weightAndTypeMap = this.factoriesInfo.get(weight + "$" + type);
        if (weightAndTypeMap == null) {
            weightAndTypeMap = new TreeMap();
            this.factoriesInfo.put(weight + "$" + type, weightAndTypeMap);
        }
        weightAndTypeMap.put(planet + "$" + factoryName, founder + "$" + planet + "$" + factoryName + "$" + timeToRefresh);
    }

    private void removeFactoryHelper(int weight, int type, String planet, String factoryName) {
        TreeMap<String, String> weightAndTypeMap = this.factoriesInfo.get(weight + "$" + type);
        if (weightAndTypeMap == null) {
            return;
        }
        Iterator<String> i = weightAndTypeMap.keySet().iterator();
        while (i.hasNext()) {
            String currName = i.next();
            if (!currName.equals(planet + "$" + factoryName)) continue;
            i.remove();
        }
    }

    private void changeFactoryHelper(int weight, int type, String planet, String factoryName, int timeToRefresh) {
        TreeMap<String, String> weightAndTypeMap = this.factoriesInfo.get(weight + "$" + type);
        if (weightAndTypeMap == null) {
            MWClient.mwClientLog.clientErrLog("Error updating factory: null treemap at weight & type.");
            return;
        }
        String oldFactoryInfo = weightAndTypeMap.get(planet + "$" + factoryName);
        if (oldFactoryInfo == null) {
            MWClient.mwClientLog.clientErrLog("Error updating factory: null oldFactory.");
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(oldFactoryInfo, "$");
        String founder = tokenizer.nextToken();
        weightAndTypeMap.put(planet + "$" + factoryName, founder + "$" + planet + "$" + factoryName + "$" + timeToRefresh);
    }

    private boolean canProduce(int type_id, int productionCapabilities) {
        if (productionCapabilities == 0) {
            return true;
        }
        int test = productionCapabilities;
        if (test - 16 >= 0) {
            test -= 16;
            if (type_id == 4) {
                return true;
            }
        }
        if (test - 8 >= 0) {
            test -= 8;
            if (type_id == 3) {
                return true;
            }
        }
        if (test - 4 >= 0) {
            test -= 4;
            if (type_id == 2) {
                return true;
            }
        }
        if (test - 2 >= 0) {
            test -= 2;
            if (type_id == 1) {
                return true;
            }
        }
        return test - 1 >= 0 && type_id == 0;
    }

    public void updateDisplay() {
        String useIt;
        StringBuilder result = new StringBuilder();
        boolean usingAdvanceRepairs = this.mwclient.isUsingAdvanceRepairs();
        result.append("<TABLE Border=\"1\"><TR><TH>" + this.HouseName + "</TH><TH>Light</TH><TH>Medium</TH><TH>Heavy</TH><TH>Assault</TH></TR>");
        for (int type_id = 0; type_id < 5; ++type_id) {
            useIt = "Use" + Unit.getTypeClassDesc(type_id);
            if (!Boolean.parseBoolean(this.mwclient.getserverConfigs(useIt))) continue;
            result.append("<TR><TD VALIGN=MIDDLE><b>" + Unit.getTypeClassDesc(type_id) + "</b></TD>");
            for (int weight = 0; weight < 4; ++weight) {
                String Comps = this.componentsInfo.get(weight + "$" + type_id);
                StringTokenizer ST = new StringTokenizer(Comps, "$");
                int comps = Integer.parseInt(ST.nextToken());
                if (comps > 0 || this.factoriesInfo.get(weight + "$" + type_id) != null) {
                    result.append("<TD><img src=\"data/images/miniticks.gif\">:" + comps);
                    result.append("<img src=\"data/images/units.gif\">:" + ST.nextToken() + "<br>");
                    int typetocheck = type_id;
                    TreeMap<String, String> facs = this.factoriesInfo.get(weight + "$" + typetocheck);
                    if (facs != null) {
                        boolean hasOpen = false;
                        int minrefresh = Integer.MAX_VALUE;
                        for (String Fac : facs.values()) {
                            ST = new StringTokenizer(Fac, "$");
                            String founder = ST.nextToken();
                            String planet = ST.nextToken();
                            String factoryName = ST.nextToken();
                            int refreshTime = Integer.parseInt(ST.nextToken());
                            if (refreshTime == 0) {
                                House foundH = this.mwclient.getData().getHouseByName(founder);
                                int cbillCost = CUnit.getPriceForUnit(this.mwclient, weight, type_id, foundH);
                                int fluCost = CUnit.getInfluenceForUnit(this.mwclient, weight, type_id, foundH);
                                int ppCost = CUnit.getPPForUnit(this.mwclient, weight, type_id, foundH);
                                if (!this.mwclient.getPlayer().getMyHouse().getName().equalsIgnoreCase(foundH.getName())) {
                                    cbillCost = Math.round((float)cbillCost * Float.parseFloat(this.mwclient.getserverConfigs("NonOriginalCBillMultiplier")));
                                    fluCost = Math.round((float)fluCost * Float.parseFloat(this.mwclient.getserverConfigs("NonOriginalInfluenceMultiplier")));
                                    ppCost = Math.round((float)ppCost * Float.parseFloat(this.mwclient.getserverConfigs("NonOriginalComponentMultiplier")));
                                }
                                String costString = "(Cost: " + this.mwclient.moneyOrFluMessage(true, true, cbillCost, false) + ", " + this.mwclient.moneyOrFluMessage(false, true, fluCost, false) + ", " + ppCost + " Components)";
                                result.append("<a href=\"MEKWARS/c request#" + weight + "#" + type_id + "#" + planet + "#" + factoryName + "\"><img border=\"0\" alt=\"Click to buy a " + founder + " " + Unit.getTypeClassDesc(type_id) + " from " + factoryName + " on " + planet + ". " + costString + "\" src=\"data/images/open" + founder + ".gif\"></a>");
                                hasOpen = true;
                                continue;
                            }
                            result.append("<a href=\"MEKWARS/c request#" + weight + "#" + type_id + "#" + planet + "#" + factoryName + "\"<img border=\"0\" alt=\"" + factoryName + " on " + planet + " built by " + founder + " (Refresh Time: " + refreshTime + ")\" src=\"data/images/closed" + founder + ".gif\"></a>");
                            if (refreshTime >= minrefresh) continue;
                            minrefresh = refreshTime;
                        }
                        if (!hasOpen) {
                            result.append("<img src=\"data/images/clock.gif\">:" + minrefresh);
                        }
                    } else {
                        result.append("<img src=\"data/images/absent.gif\">");
                    }
                } else {
                    result.append("<TD> </TD>");
                }
                result.append("</TD>");
            }
            result.append("</TR>");
        }
        result.append("</TABLE>");
        for (int type = 0; type < 5; ++type) {
            int weight;
            useIt = "Use" + Unit.getTypeClassDesc(type);
            if (!Boolean.parseBoolean(this.mwclient.getserverConfigs(useIt))) continue;
            boolean hasUnits = false;
            for (weight = 0; weight < 4; ++weight) {
                if (this.unitsInfo.get(weight + "$" + type) == null) continue;
                hasUnits = true;
            }
            if (hasUnits) {
                result.append("<b>" + Unit.getTypeClassDesc(type) + " Bays</b><br>");
            }
            for (weight = 0; weight < 4; ++weight) {
                if (this.unitsInfo.get(weight + "$" + type) == null || this.unitsInfo.get(weight + "$" + type).size() <= 0) continue;
                result.append("<a href=\"MEKWARS/c requestdonated#" + weight + "#" + type + "\"><img border=\"0\" alt=\"Request one of the Units from this bay" + "\" src=\"data/images/cart.gif\"></a> " + Unit.getWeightClassDesc(weight) + ": ");
                Vector<HSMek> v = this.unitsInfo.get(weight + "$" + type);
                HSMek[] entities = new HSMek[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    entities[i] = v.elementAt(i);
                }
                Arrays.sort(entities, new Comparator(){

                    public int compare(Object obj1, Object obj2) {
                        HSMek a = (HSMek)obj1;
                        HSMek b = (HSMek)obj2;
                        if (a.getName().compareTo(b.getName()) == 0) {
                            String damA = a.getBattleDamage();
                            String damB = b.getBattleDamage();
                            return damA.compareTo(damB);
                        }
                        return a.getName().compareTo(b.getName());
                    }
                });
                for (int j = 0; j < entities.length; ++j) {
                    StringBuilder unitString = new StringBuilder();
                    HSMek m = entities[j];
                    int num = 1;
                    while (j < entities.length - 1 && m.getName().equalsIgnoreCase(entities[j + 1].getName()) && m.getBattleDamage().equalsIgnoreCase(entities[j + 1].getBattleDamage())) {
                        ++j;
                        ++num;
                    }
                    if (usingAdvanceRepairs) {
                        Entity e = m.getEntity();
                        UnitUtils.applyBattleDamage(e, m.getBattleDamage());
                        if (!UnitUtils.canStartUp(e)) {
                            unitString.append("<font color=\"BLUE\">");
                        } else if (UnitUtils.hasCriticalDamage(e)) {
                            unitString.append("<font color=\"red\">");
                        } else if (UnitUtils.hasArmorDamage(e)) {
                            unitString.append("<font color=\"yellow\">");
                        } else {
                            unitString.append("<font color=\"black\">");
                        }
                    }
                    if (m.getType().equalsIgnoreCase("mek") || m.getType().equalsIgnoreCase("vehicle")) {
                        unitString.append("<a href=\"MEKINFO" + m.getMekFile() + "#" + m.getBV() + "#" + m.getEntity().getCrew().getGunnery() + "#" + m.getEntity().getCrew().getPiloting() + "#" + m.getBattleDamage() + "\">" + m.getName());
                    } else {
                        unitString.append("<a href=\"MEKINFO" + m.getMekFile() + "#" + m.getBV() + "#" + m.getEntity().getCrew().getGunnery() + "#" + m.getEntity().getCrew().getPiloting() + "#" + m.getBattleDamage() + "\">" + m.getName());
                    }
                    if (num > 1) {
                        unitString.insert(0, num + " x ");
                    }
                    unitString.append("</a>");
                    if (usingAdvanceRepairs) {
                        unitString.append("</font>");
                    }
                    if (j < entities.length - 1) {
                        unitString.append(", ");
                    } else {
                        unitString.append("<br>");
                    }
                    result.append(unitString.toString());
                }
            }
        }
        this.mainPane.setText(result.toString());
    }

    public void setInfoText(String s) {
        this.lblInfo.setText(s);
        if (s == null) {
            this.hsButtonSpringPanel.setVisible(true);
            this.lblInfo.setVisible(false);
        } else if (s.equals("")) {
            this.hsButtonSpringPanel.setVisible(true);
            this.lblInfo.setVisible(false);
        } else {
            if (this.lblInfo.getWidth() == 0 && this.lblInfo.getHeight() == 0) {
                Dimension newDim = new Dimension();
                newDim.setSize(this.lblInfo.getPreferredSize().getWidth(), this.hsButtonSpringPanel.getSize().getHeight());
                this.lblInfo.setMinimumSize(newDim);
            }
            this.hsButtonSpringPanel.setVisible(false);
            this.lblInfo.setVisible(true);
        }
    }

    public void showInfoWindow(String MekFile, int BV, int Gunnery, int Piloting, String battleDamage) {
        Entity UnitEntity = null;
        try {
            MechSummary ms = MechSummaryCache.getInstance().getMech(MekFile);
            UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
        }
        catch (Exception exep) {
            try {
                MWClient.mwClientLog.clientErrLog("Error loading unit: " + MekFile + ". Try replacing with OMG.");
                MechSummary ms = MechSummaryCache.getInstance().getMech("Error OMG-UR-FD");
                UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
            }
            catch (Exception exepe) {
                MWClient.mwClientLog.clientErrLog("Error unit failed to load. Exiting.");
                return;
            }
        }
        JFrame InfoWindow = new JFrame();
        MechDetailDisplay MechDetailInfo = new MechDetailDisplay();
        UnitEntity.loadAllWeapons();
        UnitEntity.setCrew(new Pilot("", Gunnery, Piloting));
        if (battleDamage.trim().length() > 1) {
            UnitUtils.applyBattleDamage(UnitEntity, battleDamage, false);
        }
        MechDetailInfo.displayEntity(UnitEntity, BV, this.mwclient.getConfig().getImage("CAMO"));
        InfoWindow.getContentPane().add(MechDetailInfo);
        InfoWindow.setSize(220, 400);
        InfoWindow.setResizable(false);
        InfoWindow.setTitle(UnitEntity.getModel());
        InfoWindow.setLocationRelativeTo(null);
        InfoWindow.setVisible(true);
    }

    private void buyNewButtonActionPerformed(ActionEvent e) {
    }

    private void buyUsedButtonActionPerformed(ActionEvent e) {
    }

    private void buyNewUnitMouseEvent(MouseEvent e) {
        JPopupMenu buy = this.createBuyNewPopupMenu();
        buy.show(e.getComponent(), e.getX(), e.getY());
    }

    private void buyUsedUnitMouseEvent(MouseEvent e) {
        JPopupMenu buy = this.createBuyUsedPopupMenu();
        buy.show(e.getComponent(), e.getX(), e.getY());
    }

    private JPopupMenu createBuyNewPopupMenu() {
        JPopupMenu buy = new JPopupMenu();
        JMenuItem menuItem = null;
        JMenu tmenu = new JMenu("Mek");
        buy.add(tmenu);
        menuItem = new JMenuItem("Light Mek");
        menuItem.setActionCommand("BUY|LIGHT|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Medium Mek");
        menuItem.setActionCommand("BUY|MEDIUM|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Heavy Mek");
        menuItem.setActionCommand("BUY|HEAVY|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Assault Mek");
        menuItem.setActionCommand("BUY|ASSAULT|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseVehicle"))) {
            tmenu = new JMenu("Vehicle");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Vehicle");
            menuItem.setActionCommand("BUY|LIGHT|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Vehicle");
            menuItem.setActionCommand("BUY|MEDIUM|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Vehicle");
            menuItem.setActionCommand("BUY|HEAVY|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Vehicle");
            menuItem.setActionCommand("BUY|ASSAULT|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseInfantry"))) {
            tmenu = new JMenu("Infantry");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Infantry");
            menuItem.setActionCommand("BUY|LIGHT|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Infantry");
            menuItem.setActionCommand("BUY|MEDIUM|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Infantry");
            menuItem.setActionCommand("BUY|HEAVY|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Infantry");
            menuItem.setActionCommand("BUY|ASSAULT|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseProtoMek"))) {
            tmenu = new JMenu("ProtoMek");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light ProtoMek");
            menuItem.setActionCommand("BUY|LIGHT|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium ProtoMek");
            menuItem.setActionCommand("BUY|MEDIUM|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy ProtoMek");
            menuItem.setActionCommand("BUY|HEAVY|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault ProtoMek");
            menuItem.setActionCommand("BUY|ASSAULT|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseBattleArmor"))) {
            tmenu = new JMenu("Battle Armor");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Battle Armor");
            menuItem.setActionCommand("BUY|LIGHT|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Battle Armor");
            menuItem.setActionCommand("BUY|MEDIUM|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Battle Armor");
            menuItem.setActionCommand("BUY|HEAVY|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Battle Armor");
            menuItem.setActionCommand("BUY|ASSAULT|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowPersonalPilotQueues"))) {
            tmenu = new JMenu("Pilots");
            buy.add(tmenu);
            JMenu smenu = new JMenu("Mek");
            menuItem = new JMenuItem("Light Pilot");
            menuItem.setActionCommand("BUYP|0|0");
            menuItem.addActionListener(this.myPopup);
            smenu.add(menuItem);
            menuItem = new JMenuItem("Medium Pilot");
            menuItem.setActionCommand("BUYP|0|1");
            menuItem.addActionListener(this.myPopup);
            smenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Pilot");
            menuItem.setActionCommand("BUYP|0|2");
            menuItem.addActionListener(this.myPopup);
            smenu.add(menuItem);
            menuItem = new JMenuItem("Assault Pilot");
            menuItem.setActionCommand("BUYP|0|3");
            menuItem.addActionListener(this.myPopup);
            smenu.add(menuItem);
            tmenu.add(smenu);
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseProtoMek"))) {
                smenu = new JMenu("Proto");
                menuItem = new JMenuItem("Light Pilot");
                menuItem.setActionCommand("BUYP|3|0");
                menuItem.addActionListener(this.myPopup);
                smenu.add(menuItem);
                menuItem = new JMenuItem("Medium Pilot");
                menuItem.setActionCommand("BUYP|3|1");
                menuItem.addActionListener(this.myPopup);
                smenu.add(menuItem);
                menuItem = new JMenuItem("Heavy Pilot");
                menuItem.setActionCommand("BUYP|3|2");
                menuItem.addActionListener(this.myPopup);
                smenu.add(menuItem);
                menuItem = new JMenuItem("Assault Pilot");
                menuItem.setActionCommand("BUYP|3|3");
                menuItem.addActionListener(this.myPopup);
                smenu.add(menuItem);
                tmenu.add(smenu);
            }
        }
        return buy;
    }

    private JPopupMenu createBuyUsedPopupMenu() {
        JPopupMenu buy = new JPopupMenu();
        JMenuItem menuItem = null;
        JMenu tmenu = new JMenu("Mek");
        buy.add(tmenu);
        menuItem = new JMenuItem("Light Mek");
        menuItem.setActionCommand("BUYU|LIGHT|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Medium Mek");
        menuItem.setActionCommand("BUYU|MEDIUM|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Heavy Mek");
        menuItem.setActionCommand("BUYU|HEAVY|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Assault Mek");
        menuItem.setActionCommand("BUYU|ASSAULT|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseVehicle"))) {
            tmenu = new JMenu("Vehicle");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Vehicle");
            menuItem.setActionCommand("BUYU|LIGHT|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Vehicle");
            menuItem.setActionCommand("BUYU|MEDIUM|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Vehicle");
            menuItem.setActionCommand("BUYU|HEAVY|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Vehicle");
            menuItem.setActionCommand("BUYU|ASSAULT|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseInfantry"))) {
            tmenu = new JMenu("Infantry");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Infantry");
            menuItem.setActionCommand("BUYU|LIGHT|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Infantry");
            menuItem.setActionCommand("BUYU|MEDIUM|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Infantry");
            menuItem.setActionCommand("BUYU|HEAVY|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Infantry");
            menuItem.setActionCommand("BUYU|ASSAULT|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseProtoMek"))) {
            tmenu = new JMenu("ProtoMek");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light ProtoMek");
            menuItem.setActionCommand("BUYU|LIGHT|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Infantry");
            menuItem.setActionCommand("BUYU|MEDIUM|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Infantry");
            menuItem.setActionCommand("BUYU|HEAVY|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Infantry");
            menuItem.setActionCommand("BUYU|ASSAULT|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseBattleArmor"))) {
            tmenu = new JMenu("Battle Armor");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Battle Armor");
            menuItem.setActionCommand("BUYU|LIGHT|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Battle Armor");
            menuItem.setActionCommand("BUYU|MEDIUM|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Battle Armor");
            menuItem.setActionCommand("BUYU|HEAVY|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Battle Armor");
            menuItem.setActionCommand("BUYU|ASSAULT|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        return buy;
    }

    class BuyPopupListener
    extends MouseAdapter
    implements ActionListener {
        BuyPopupListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String s = actionEvent.getActionCommand();
            StringTokenizer st = new StringTokenizer(s, "|");
            String command = st.nextToken();
            if (command.equalsIgnoreCase("BUY")) {
                CHSPanel.this.mwclient.sendChat("/c request#" + st.nextToken() + "#" + st.nextToken());
            } else if (command.equalsIgnoreCase("BUYU")) {
                CHSPanel.this.mwclient.sendChat("/c requestdonated#" + st.nextToken() + "#" + st.nextToken());
            } else if (command.equalsIgnoreCase("BUYP")) {
                CHSPanel.this.mwclient.sendChat("/c buypilotsfromhouse#" + st.nextToken() + "#" + st.nextToken());
            }
        }
    }
}

