/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.gui.CBMPanel;
import client.gui.CBMPartsPanel;
import client.gui.CBattlePanel;
import client.gui.CCommPanel;
import client.gui.CHQPanel;
import client.gui.CHSPanel;
import client.gui.CMainFrame;
import client.gui.CMapPanel;
import client.gui.CPlayerPanel;
import client.gui.CUserListPanel;
import common.BMEquipment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CMainPanel
extends JPanel
implements ChangeListener,
ComponentListener {
    JSplitPane MainSPane;
    JSplitPane TabSPane;
    JSplitPane SideSPane;
    CPlayerPanel PlayerPanel;
    CUserListPanel UserListPanel;
    JTabbedPane MainTPane = new JTabbedPane(3);
    CCommPanel CommPanel;
    CSelectTabAction CommSelect;
    CHQPanel HQPanel = null;
    CBMPanel BMPanel = null;
    CHSPanel HSPanel = null;
    JTabbedPane BMETabbed = null;
    CSelectTabAction HQSelect = null;
    CSelectTabAction BMSelect = null;
    CSelectTabAction HSSelect = null;
    CSelectTabAction BMESelect = null;
    CBattlePanel BattlePanel = null;
    CSelectTabAction BattleSelect = null;
    CMapPanel MapPanel = null;
    CSelectTabAction MapSelect = null;
    MWClient mwclient;
    CTabForwardAction ForwardMainTab;
    CTabBackwardAction BackwardMainTab;
    int panelDivider;
    int playerPanelDivider;
    int verticalPanelDivider;
    int sPanelDivider = 0;

    public CMainPanel(MWClient client, CMainFrame mainFrame) {
        this.mwclient = client;
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(620, 400));
        this.addComponentListener(this);
        this.createMainTPane(mainFrame);
        this.PlayerPanel = new CPlayerPanel(this.mwclient);
        this.UserListPanel = new CUserListPanel(this.mwclient);
        this.add((Component)this.PlayerPanel, "North");
        this.panelDivider = this.mwclient.getConfig().getIntParam("PANELDIVIDER");
        this.sPanelDivider = this.mwclient.getConfig().getIntParam("SPLITTERSIZE");
        this.playerPanelDivider = this.mwclient.getConfig().getIntParam("PLAYERPANELDIVIDER");
        this.verticalPanelDivider = this.mwclient.getConfig().getIntParam("VERTICALDIVIDER");
        this.TabSPane = new JSplitPane(0, this.MainTPane, this.CommPanel);
        this.TabSPane.setOneTouchExpandable(true);
        this.TabSPane.setDividerLocation(this.panelDivider);
        this.TabSPane.setDividerSize(this.sPanelDivider);
        this.SideSPane = new JSplitPane(0, this.PlayerPanel, this.UserListPanel);
        this.SideSPane.setOneTouchExpandable(true);
        this.SideSPane.setDividerLocation(this.playerPanelDivider);
        this.SideSPane.setDividerSize(this.sPanelDivider);
        this.MainSPane = new JSplitPane(1, this.TabSPane, this.SideSPane);
        this.MainSPane.setOneTouchExpandable(true);
        this.MainSPane.setDividerLocation(this.verticalPanelDivider);
        this.MainSPane.setDividerSize(this.sPanelDivider);
        this.add((Component)this.MainSPane, "Center");
        this.ForwardMainTab = new CTabForwardAction();
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt X"), "TabForward");
        this.getActionMap().put("TabForward", this.ForwardMainTab);
        this.BackwardMainTab = new CTabBackwardAction();
        this.getInputMap(2).put(KeyStroke.getKeyStroke("shift alt X"), "TabBackward");
        this.getActionMap().put("TabBackward", this.BackwardMainTab);
        this.revalidate();
    }

    private void addPanelMain(JPanel panel, CSelectTabAction select, String name, String tooltip, String mnemostr, String commandStr) {
        this.MainTPane.addTab(name, null, panel, tooltip);
        int index = this.MainTPane.indexOfComponent(panel);
        int mnemo = this.MainTPane.getTitleAt(index).indexOf(mnemostr.toUpperCase());
        if (mnemo == -1) {
            mnemo = this.MainTPane.getTitleAt(index).indexOf(mnemostr.toLowerCase());
        }
        this.MainTPane.setDisplayedMnemonicIndexAt(index, mnemo);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt " + mnemostr), commandStr);
        this.getActionMap().put(commandStr, select);
    }

    private void addPanelCComm(JPanel panel, CSelectTabAction select, String name, String tooltip, String mnemostr, String commandStr, CCommPanel CommPanel) {
        CommPanel.CommTPane.addTab(name, null, panel, tooltip);
        int index = CommPanel.CommTPane.indexOfComponent(panel);
        int mnemo = CommPanel.CommTPane.getTitleAt(index).indexOf(mnemostr.toUpperCase());
        if (mnemo == -1) {
            mnemo = CommPanel.CommTPane.getTitleAt(index).indexOf(mnemostr.toLowerCase());
        }
        CommPanel.CommTPane.setDisplayedMnemonicIndexAt(index, mnemo);
        CommPanel.CommTPane.getInputMap(2).put(KeyStroke.getKeyStroke("alt " + mnemostr), commandStr);
        CommPanel.CommTPane.getActionMap().put(commandStr, select);
    }

    private void addPanelMain(JTabbedPane panel, CSelectTabAction select, String name, String tooltip, String mnemostr, String commandStr) {
        this.MainTPane.addTab(name, null, panel, tooltip);
        int index = this.MainTPane.indexOfComponent(panel);
        int mnemo = this.MainTPane.getTitleAt(index).indexOf(mnemostr.toUpperCase());
        if (mnemo == -1) {
            mnemo = this.MainTPane.getTitleAt(index).indexOf(mnemostr.toLowerCase());
        }
        this.MainTPane.setDisplayedMnemonicIndexAt(index, mnemo);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt " + mnemostr), commandStr);
        this.getActionMap().put(commandStr, select);
    }

    private void addPanelCComm(JTabbedPane panel, CSelectTabAction select, String name, String tooltip, String mnemostr, String commandStr, CCommPanel CommPanel) {
        CommPanel.CommTPane.addTab(name, null, panel, tooltip);
        int index = CommPanel.CommTPane.indexOfComponent(panel);
        int mnemo = CommPanel.CommTPane.getTitleAt(index).indexOf(mnemostr.toUpperCase());
        if (mnemo == -1) {
            mnemo = CommPanel.CommTPane.getTitleAt(index).indexOf(mnemostr.toLowerCase());
        }
        CommPanel.CommTPane.setDisplayedMnemonicIndexAt(index, mnemo);
        CommPanel.CommTPane.getInputMap(2).put(KeyStroke.getKeyStroke("alt " + mnemostr), commandStr);
        CommPanel.CommTPane.getActionMap().put(commandStr, select);
    }

    private void createMainTPane(CMainFrame mainFrame) {
        this.CommPanel = new CCommPanel(this.mwclient);
        String tabText = "";
        String mnemonicText = "";
        if (this.mwclient.getConfig().isParam("HQTABVISIBLE")) {
            this.HQPanel = new CHQPanel(this.mwclient);
            this.HQSelect = new CSelectTabAction(this.HQPanel);
            tabText = this.mwclient.getConfig().getParam("HQTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("HQMNEMONIC");
            if (this.mwclient.getConfig().isParam("HQINTOPROW")) {
                this.addPanelMain(this.HQPanel, this.HQSelect, tabText, "Command Center and Hangars (Alt + " + mnemonicText + ")", mnemonicText, "HQSelect");
            } else {
                this.addPanelCComm(this.HQPanel, this.HQSelect, tabText, "Command Center and Hangars (Alt + " + mnemonicText + ")", mnemonicText, "HQSelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("BMTABVISIBLE")) {
            this.BMPanel = new CBMPanel(this.mwclient);
            this.BMSelect = new CSelectTabAction(this.BMPanel);
            tabText = this.mwclient.getConfig().getParam("BMTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("BMMNEMONIC");
            if (this.mwclient.getConfig().isParam("BMINTOPROW")) {
                this.addPanelMain(this.BMPanel, this.BMSelect, tabText, "Buy and Sell Units (Alt + " + mnemonicText + ")", mnemonicText, "BMSelect");
            } else {
                this.addPanelCComm(this.BMPanel, this.BMSelect, tabText, "Buy and Sell Units (Alt + " + mnemonicText + ")", mnemonicText, "BMSelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("BMETABVISIBLE") && Boolean.parseBoolean(this.mwclient.getserverConfigs("UsePartsBlackMarket"))) {
            this.BMETabbed = new JTabbedPane(3);
            this.BMETabbed.addTab("Ammo", new CBMPartsPanel(this.mwclient, BMEquipment.PART_AMMO));
            this.BMETabbed.addTab("Armor", new CBMPartsPanel(this.mwclient, BMEquipment.PART_ARMOR));
            this.BMETabbed.addTab("Weapons", new CBMPartsPanel(this.mwclient, BMEquipment.PART_WEAPON));
            this.BMETabbed.addTab("Misc", new CBMPartsPanel(this.mwclient, BMEquipment.PART_MISC));
            this.BMESelect = new CSelectTabAction(this.BMETabbed);
            tabText = this.mwclient.getConfig().getParam("BMETABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("BMEMNEMONIC");
            if (this.mwclient.getConfig().isParam("BMEINTOPROW")) {
                this.addPanelMain(this.BMETabbed, this.BMESelect, tabText, "Buy and Sell Parts (Alt + " + mnemonicText + ")", mnemonicText, "BMESelect");
            } else {
                this.addPanelCComm(this.BMETabbed, this.BMESelect, tabText, "Buy and Sell Parts (Alt + " + mnemonicText + ")", mnemonicText, "BMESelect", this.CommPanel);
            }
        }
        this.HSPanel = new CHSPanel(this.mwclient);
        if (this.mwclient.getConfig().isParam("HSTATUSTABVISIBLE")) {
            this.HSSelect = new CSelectTabAction(this.HSPanel);
            tabText = this.mwclient.getConfig().getParam("HSTATUSTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("HSTATUSMNEMONIC");
            if (this.mwclient.getConfig().isParam("HSTATUSINTOPROW")) {
                this.addPanelMain(this.HSPanel, this.HSSelect, tabText, "Show current House Status (Alt + " + mnemonicText + ")", mnemonicText, "HSSelect");
            } else {
                this.addPanelCComm(this.HSPanel, this.HSSelect, tabText, "Show current House Status (Alt + " + mnemonicText + ")", mnemonicText, "HSSelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("BATTLETABVISIBLE")) {
            this.BattlePanel = new CBattlePanel(this.mwclient);
            this.BattleSelect = new CSelectTabAction(this.BattlePanel);
            tabText = this.mwclient.getConfig().getParam("BATTLETABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("BATTLEMNEMONIC");
            if (this.mwclient.getConfig().isParam("BATTLEINTOPROW")) {
                this.addPanelMain(this.BattlePanel, this.BattleSelect, tabText, "Battles Intelligence Data (Alt + " + mnemonicText + ")", mnemonicText, "BattleSelect");
            } else {
                this.addPanelCComm(this.BattlePanel, this.BattleSelect, tabText, "Battles Intelligence Data (Alt + " + mnemonicText + ")", mnemonicText, "BattleSelect", this.CommPanel);
            }
        }
        this.MapPanel = new CMapPanel(this.mwclient, mainFrame, this.CommPanel.getWidth(), this.CommPanel.getHeight());
        if (this.mwclient.getConfig().isParam("MAPTABVISIBLE")) {
            this.MapSelect = new CSelectTabAction(this.MapPanel);
            tabText = this.mwclient.getConfig().getParam("MAPTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("MAPMNEMONIC");
            if (this.mwclient.getConfig().isParam("MAPINTOPROW")) {
                this.addPanelMain(this.MapPanel, this.MapSelect, tabText, "Star Map (Alt + " + mnemonicText + ")", mnemonicText, "MapSelect");
            } else {
                this.addPanelCComm(this.MapPanel, this.MapSelect, tabText, "Star Map (Alt + " + mnemonicText + ")", mnemonicText, "MapSelect", this.CommPanel);
            }
        }
        this.MainTPane.addChangeListener(this);
    }

    public void changeStatus(int status, int laststatus) {
        if (status == 2 && laststatus == 1) {
            this.UserListPanel.setLoggedIn(true);
            this.UserListPanel.getUsers().getRenderer().setLoggedIn(true);
            if (this.mwclient.getConfig().isParam("PLAYERPANEL")) {
                this.PlayerPanel.setVisible(true);
            }
            this.TabSPane.setDividerLocation(this.panelDivider);
            this.SideSPane.setDividerLocation(this.playerPanelDivider);
        }
        if (status == 0 || status == 1) {
            this.UserListPanel.setLoggedIn(false);
            this.UserListPanel.getUsers().getRenderer().setLoggedIn(false);
            this.PlayerPanel.setVisible(false);
        }
        if (status == 0) {
            this.MainTPane.setVisible(false);
        } else {
            this.MainTPane.setVisible(true);
        }
    }

    public void selectFirstTab() {
        try {
            this.MainTPane.setSelectedIndex(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void selectMapTab() {
        String currTitle;
        int i;
        String nameToFind = this.mwclient.getConfigParam("MAPTABNAME");
        for (i = this.MainTPane.getTabCount() - 1; 0 <= i; --i) {
            currTitle = this.MainTPane.getTitleAt(i);
            if (!currTitle.equals(nameToFind)) continue;
            this.MainTPane.setSelectedIndex(i);
            return;
        }
        for (i = this.CommPanel.CommTPane.getTabCount() - 1; 0 <= i; --i) {
            currTitle = this.CommPanel.CommTPane.getTitleAt(i);
            if (!currTitle.equals(nameToFind)) continue;
            this.CommPanel.CommTPane.setSelectedIndex(i);
            return;
        }
    }

    public CPlayerPanel getPlayerPanel() {
        return this.PlayerPanel;
    }

    public void setPlayerPanel(CPlayerPanel panel) {
        this.PlayerPanel = panel;
    }

    public CMapPanel getMapPanel() {
        return this.MapPanel;
    }

    public JSplitPane getTabSPane() {
        return this.TabSPane;
    }

    public JSplitPane getMainSPane() {
        return this.MainSPane;
    }

    public JSplitPane getSideSPane() {
        return this.SideSPane;
    }

    public CUserListPanel getUserListPanel() {
        return this.UserListPanel;
    }

    public CCommPanel getCommPanel() {
        return this.CommPanel;
    }

    public CHQPanel getHQPanel() {
        return this.HQPanel;
    }

    public CBMPanel getBMPanel() {
        return this.BMPanel;
    }

    public CHSPanel getHSPanel() {
        return this.HSPanel;
    }

    public void refreshBME() {
        if (this.BMETabbed == null) {
            return;
        }
        try {
            ((CBMPartsPanel)this.BMETabbed.getComponentAt(0)).refresh();
            ((CBMPartsPanel)this.BMETabbed.getComponentAt(1)).refresh();
            ((CBMPartsPanel)this.BMETabbed.getComponentAt(2)).refresh();
            ((CBMPartsPanel)this.BMETabbed.getComponentAt(3)).refresh();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    public JTable getBattleTable() {
        return this.BattlePanel.getBattleTable();
    }

    public void refreshBattleTable() {
        this.BattlePanel.getBattleTableModel().refreshModel();
    }

    public void stateChanged(ChangeEvent e) {
        if (this.MainTPane.getSelectedIndex() == -1) {
            return;
        }
        if (this.MainTPane.getSelectedComponent() == this.CommPanel) {
            this.CommPanel.getInputField().requestFocusInWindow();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.TabSPane.setDividerLocation(this.panelDivider);
        this.SideSPane.setDividerLocation(this.playerPanelDivider);
        this.MainSPane.setDividerLocation(this.verticalPanelDivider);
    }

    public void componentShown(ComponentEvent e) {
        this.TabSPane.setDividerLocation(this.panelDivider);
        this.SideSPane.setDividerLocation(this.playerPanelDivider);
        this.MainSPane.setDividerLocation(this.verticalPanelDivider);
    }

    public void recreateMainTPane(CMainFrame mainFrame) {
        this.MainTPane.removeAll();
        this.CommPanel.CommTPane.removeAll();
        this.CommPanel.reload();
        String tabText = "";
        String mnemonicText = "";
        if (this.mwclient.getConfig().isParam("HQTABVISIBLE")) {
            if (this.HQPanel == null) {
                this.HQPanel = new CHQPanel(this.mwclient);
                this.HQSelect = new CSelectTabAction(this.HQPanel);
            }
            tabText = this.mwclient.getConfig().getParam("HQTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("HQMNEMONIC");
            if (this.mwclient.getConfig().isParam("HQINTOPROW")) {
                this.addPanelMain(this.HQPanel, this.HQSelect, tabText, "Command Center and Hangars (Alt + " + mnemonicText + ")", mnemonicText, "HQSelect");
            } else {
                this.addPanelCComm(this.HQPanel, this.HQSelect, tabText, "Command Center and Hangars (Alt + " + mnemonicText + ")", mnemonicText, "HQSelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("BMTABVISIBLE")) {
            if (this.BMPanel == null) {
                this.BMPanel = new CBMPanel(this.mwclient);
                this.BMSelect = new CSelectTabAction(this.BMPanel);
            }
            tabText = this.mwclient.getConfig().getParam("BMTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("BMMNEMONIC");
            if (this.mwclient.getConfig().isParam("BMINTOPROW")) {
                this.addPanelMain(this.BMPanel, this.BMSelect, tabText, "Buy and Sell Units (Alt + " + mnemonicText + ")", mnemonicText, "BMSelect");
            } else {
                this.addPanelCComm(this.BMPanel, this.BMSelect, tabText, "Buy and Sell Units (Alt + " + mnemonicText + ")", mnemonicText, "BMSelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("BMETABVISIBLE") && Boolean.parseBoolean(this.mwclient.getserverConfigs("UsePartsBlackMarket"))) {
            if (this.BMETabbed == null) {
                this.BMETabbed = new JTabbedPane(3);
                this.BMETabbed.addTab("Ammo", new CBMPartsPanel(this.mwclient, BMEquipment.PART_AMMO));
                this.BMETabbed.addTab("Armor", new CBMPartsPanel(this.mwclient, BMEquipment.PART_ARMOR));
                this.BMETabbed.addTab("Weapons", new CBMPartsPanel(this.mwclient, BMEquipment.PART_WEAPON));
                this.BMETabbed.addTab("Misc", new CBMPartsPanel(this.mwclient, BMEquipment.PART_MISC));
                this.BMESelect = new CSelectTabAction(this.BMETabbed);
            }
            tabText = this.mwclient.getConfig().getParam("BMETABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("BMEMNEMONIC");
            if (this.mwclient.getConfig().isParam("BMEINTOPROW")) {
                this.addPanelMain(this.BMETabbed, this.BMSelect, tabText, "Buy and Sell Parts (Alt + " + mnemonicText + ")", mnemonicText, "BMESelect");
            } else {
                this.addPanelCComm(this.BMETabbed, this.BMSelect, tabText, "Buy and Sell Parts (Alt + " + mnemonicText + ")", mnemonicText, "BMESelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("HSTATUSTABVISIBLE")) {
            if (this.HSPanel == null) {
                this.HSPanel = new CHSPanel(this.mwclient);
                this.HSSelect = new CSelectTabAction(this.HSPanel);
            } else if (this.HSSelect == null) {
                this.HSSelect = new CSelectTabAction(this.HSPanel);
            }
            tabText = this.mwclient.getConfig().getParam("HSTATUSTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("HSTATUSMNEMONIC");
            if (this.mwclient.getConfig().isParam("HSTATUSINTOPROW")) {
                this.addPanelMain(this.HSPanel, this.HSSelect, tabText, "Show current House Status (Alt + " + mnemonicText + ")", mnemonicText, "HSSelect");
            } else {
                this.addPanelCComm(this.HSPanel, this.HSSelect, tabText, "Show current House Status (Alt + " + mnemonicText + ")", mnemonicText, "HSSelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("BATTLETABVISIBLE")) {
            if (this.BattlePanel == null) {
                this.BattlePanel = new CBattlePanel(this.mwclient);
                this.BattleSelect = new CSelectTabAction(this.BattlePanel);
            }
            tabText = this.mwclient.getConfig().getParam("BATTLETABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("BATTLEMNEMONIC");
            if (this.mwclient.getConfig().isParam("BATTLEINTOPROW")) {
                this.addPanelMain(this.BattlePanel, this.BattleSelect, tabText, "Battles Intelligence Data (Alt + " + mnemonicText + ")", mnemonicText, "BattleSelect");
            } else {
                this.addPanelCComm(this.BattlePanel, this.BattleSelect, tabText, "Battles Intelligence Data (Alt + " + mnemonicText + ")", mnemonicText, "BattleSelect", this.CommPanel);
            }
        }
        if (this.MapPanel == null) {
            this.MapPanel = new CMapPanel(this.mwclient, mainFrame, this.CommPanel.getWidth(), this.CommPanel.getHeight());
        }
        if (this.mwclient.getConfig().isParam("MAPTABVISIBLE")) {
            if (this.MapSelect == null) {
                this.MapSelect = new CSelectTabAction(this.MapPanel);
            }
            tabText = this.mwclient.getConfig().getParam("MAPTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("MAPMNEMONIC");
            if (this.mwclient.getConfig().isParam("MAPINTOPROW")) {
                this.addPanelMain(this.MapPanel, this.MapSelect, tabText, "Star Map (Alt + " + mnemonicText + ")", mnemonicText, "MapSelect");
            } else {
                this.addPanelCComm(this.MapPanel, this.MapSelect, tabText, "Star Map (Alt + " + mnemonicText + ")", mnemonicText, "MapSelect", this.CommPanel);
            }
        }
        this.MainTPane.addChangeListener(this);
    }

    private class CSelectTabAction
    extends AbstractAction {
        Component Tab = null;

        public CSelectTabAction(Component tab) {
            this.Tab = tab;
        }

        public void actionPerformed(ActionEvent e) {
            block3: {
                try {
                    if (CMainPanel.this.MainTPane.isEnabledAt(CMainPanel.this.MainTPane.indexOfComponent(this.Tab))) {
                        CMainPanel.this.MainTPane.setSelectedComponent(this.Tab);
                    }
                }
                catch (Exception ex) {
                    if (!CMainPanel.this.CommPanel.CommTPane.isEnabledAt(CMainPanel.this.CommPanel.CommTPane.indexOfComponent(this.Tab))) break block3;
                    CMainPanel.this.CommPanel.CommTPane.setSelectedComponent(this.Tab);
                }
            }
        }
    }

    private class CTabBackwardAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            int count = CMainPanel.this.MainTPane.getTabCount();
            if (count < 2) {
                return;
            }
            int index = CMainPanel.this.MainTPane.getSelectedIndex();
            if (--index == -1) {
                index = count - 1;
            }
            while (!CMainPanel.this.MainTPane.isEnabledAt(index)) {
                if (--index != -1) continue;
                index = count - 1;
            }
            CMainPanel.this.MainTPane.setSelectedIndex(index);
        }
    }

    private class CTabForwardAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            int count = CMainPanel.this.MainTPane.getTabCount();
            if (count < 2) {
                return;
            }
            int index = CMainPanel.this.MainTPane.getSelectedIndex();
            if (++index == count) {
                index = 0;
            }
            while (!CMainPanel.this.MainTPane.isEnabledAt(index)) {
                if (++index != count) continue;
                index = 0;
            }
            CMainPanel.this.MainTPane.setSelectedIndex(index);
        }
    }
}

