/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.CConfig;
import client.MWClient;
import client.campaign.CPlayer;
import client.gui.MMNetHyperLinkListener;
import client.gui.MyHTMLEditorKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.StringReader;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.text.html.HTMLEditorKit;

public class CPlayerPanel
extends JScrollPane {
    MWClient mwclient;
    CPlayer player;
    CConfig config;
    private static final String PP_NAME = "Name";
    private static final String PP_STATUS = "Status:";
    private static final String PP_EXP = "Experience:";
    private static final String PP_ELO = "Rating:";
    private static final String PP_REWARD = "Reward Points:";
    private static final String PP_TECHS = "Techs:";
    private static final String PP_PAIDTECHS = "Paid Techs:";
    private static final String PP_BAYS = "Bays:";
    private static final String PP_IDLETECHS = "Idle Techs:";
    protected JPanel PlayerPanel = new JPanel();
    protected JEditorPane lblLogo = new JEditorPane("text/html", "");
    protected JPanel InfoPanel = new JPanel();
    protected JLabel lblName = new JLabel();
    protected JLabel lblStatus = new JLabel();
    protected JLabel lblExp = new JLabel();
    protected JLabel lblRating = new JLabel();
    protected JLabel lblMoney = new JLabel();
    protected JLabel lblInfluence = new JLabel();
    protected JLabel lblMekbay = new JLabel();
    protected JLabel lblTechs = new JLabel();
    protected JLabel lblRewardPoints = new JLabel();
    protected JLabel lblNextTick = new JLabel();
    protected long nextTick = System.currentTimeMillis();

    public CPlayerPanel(MWClient client) {
        Insets insets = new Insets(0, 0, 0, 0);
        int center = 10;
        int none = 0;
        String endtag = "";
        String tag = "";
        this.mwclient = client;
        this.player = client.getPlayer();
        this.config = client.getConfig();
        boolean logo = client.getConfig().isParam("LOGO");
        int height = client.getConfig().getIntParam("PLAYERPANELHEIGHT");
        this.setMinimumSize(new Dimension(0, 0));
        Dimension dimension = logo ? new Dimension(140, height + 140) : new Dimension(140, height);
        this.PlayerPanel.setLayout(new GridBagLayout());
        this.PlayerPanel.setMinimumSize(dimension);
        this.PlayerPanel.setPreferredSize(dimension);
        dimension = new Dimension(140, 150);
        MMNetHyperLinkListener chatHLL = new MMNetHyperLinkListener(this.mwclient);
        MyHTMLEditorKit kit = new MyHTMLEditorKit();
        this.lblLogo.setPreferredSize(dimension);
        this.lblLogo.setMinimumSize(dimension);
        this.lblLogo.setMaximumSize(dimension);
        this.lblLogo.setEditable(false);
        this.lblLogo.addHyperlinkListener(chatHLL);
        this.lblLogo.setEditorKit(kit);
        this.lblLogo.setEnabled(true);
        if (logo) {
            this.PlayerPanel.add(this.lblLogo);
        }
        dimension = new Dimension(140, height + 30);
        this.InfoPanel.setLayout(new BoxLayout(this.InfoPanel, 1));
        this.InfoPanel.setPreferredSize(dimension);
        this.InfoPanel.setMinimumSize(dimension);
        this.InfoPanel.setMaximumSize(dimension);
        this.lblName.setText(tag + PP_NAME + endtag);
        this.lblStatus.setText(tag + PP_STATUS + endtag);
        this.lblExp.setText(tag + PP_EXP + endtag);
        this.lblRating.setText(tag + PP_ELO + endtag);
        this.lblMoney.setText(tag + client.getserverConfigs("MoneyLongName") + ": " + endtag);
        this.lblInfluence.setText(tag + client.getserverConfigs("FluLongName") + endtag);
        if (this.mwclient.isUsingAdvanceRepairs()) {
            this.lblMekbay.setText(tag + PP_BAYS + endtag);
            this.lblTechs.setText(tag + PP_IDLETECHS + endtag);
        } else {
            this.lblMekbay.setText(tag + PP_TECHS + endtag);
            this.lblTechs.setText(tag + PP_PAIDTECHS + endtag);
        }
        this.lblRewardPoints.setText(tag + PP_REWARD + endtag);
        this.lblNextTick.setText("Next Tick: N/A");
        this.InfoPanel.add(this.lblName);
        this.InfoPanel.add(this.lblStatus);
        this.InfoPanel.add(this.lblExp);
        if (!Boolean.parseBoolean(client.getserverConfigs("HideELO"))) {
            this.InfoPanel.add(this.lblRating);
        }
        this.InfoPanel.add(this.lblMoney);
        this.InfoPanel.add(this.lblInfluence);
        this.InfoPanel.add(this.lblMekbay);
        this.InfoPanel.add(this.lblTechs);
        if (Boolean.parseBoolean(client.getserverConfigs("ShowReward"))) {
            this.InfoPanel.add(this.lblRewardPoints);
        }
        this.InfoPanel.add(this.lblNextTick);
        if (logo) {
            this.PlayerPanel.add((Component)this.InfoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, center, none, insets, 0, 0));
        } else {
            this.PlayerPanel.add((Component)this.InfoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, center, none, insets, 0, 0));
        }
        if (logo) {
            this.setPreferredSize(new Dimension(130, height + 140));
            this.setMinimumSize(new Dimension(140, height + 140));
            this.setMaximumSize(new Dimension(140, height + 140));
        } else {
            this.setPreferredSize(new Dimension(130, height + 40));
            this.setMinimumSize(new Dimension(140, height + 40));
            this.setMaximumSize(new Dimension(140, height + 40));
        }
        this.setBorder(new LineBorder(Color.black));
        this.setViewportView(this.PlayerPanel);
        TThread clockT = new TThread(this);
        clockT.start();
    }

    public void refresh() {
        if (this.mwclient.getConfig().isParam("LOGO")) {
            try {
                this.lblLogo.setBackground(this.mwclient.getMainFrame().getBackground());
                this.lblLogo.getDocument().remove(0, this.lblLogo.getDocument().getLength());
                ((HTMLEditorKit)this.lblLogo.getEditorKit()).read(new StringReader(this.mwclient.getPlayer().getLogo()), this.lblLogo.getDocument(), 0);
                this.lblLogo.setCaretPosition(this.lblLogo.getDocument().getLength());
            }
            catch (Exception ex) {
                MWClient.mwClientLog.clientErrLog(ex);
            }
        }
        this.lblName.setText(this.player.getName());
        this.lblStatus.setText("Status: " + this.mwclient.getStatus());
        this.lblExp.setText("Experience: " + this.player.getExp());
        DecimalFormat myFormatter = new DecimalFormat("###.##");
        String ratingStr = myFormatter.format(this.player.getRating());
        this.lblRating.setText("Rating: " + ratingStr);
        if (this.player.getMoney() == 0) {
            this.lblMoney.setText(this.mwclient.moneyOrFluMessage(true, false, -2) + ": " + this.player.getMoney());
        } else {
            this.lblMoney.setText(this.mwclient.moneyOrFluMessage(true, false, -this.player.getMoney()) + ": " + this.player.getMoney());
        }
        if (this.player.getInfluence() == 0) {
            this.lblInfluence.setText(this.mwclient.moneyOrFluMessage(false, false, -2) + ": " + this.player.getInfluence());
        } else {
            this.lblInfluence.setText(this.mwclient.moneyOrFluMessage(false, false, -this.player.getInfluence()) + ": " + this.player.getInfluence());
        }
        if (this.mwclient.isUsingAdvanceRepairs()) {
            try {
                this.lblMekbay.setText("Bays: " + this.player.getFreeBays() + "/" + this.player.getBays() + " (" + this.mwclient.moneyOrFluMessage(true, true, this.player.getTechCost()) + ")");
                this.lblTechs.setText("Idle Techs: " + this.player.getAvailableTechs().get(0) + "/" + this.player.getAvailableTechs().get(1) + "/" + this.player.getAvailableTechs().get(2) + "/" + this.player.getAvailableTechs().get(3));
            }
            catch (Exception exception) {}
        } else {
            this.lblMekbay.setText("Techs: " + this.player.getFreeBays() + "/" + this.player.getBays());
            this.lblTechs.setText("Paid Techs: " + this.player.getTechs() + " (" + this.mwclient.moneyOrFluMessage(true, true, this.player.getTechCost()) + ")");
        }
        this.lblRewardPoints.setText("Reward Points: " + this.player.getRewardPoints() + "/" + this.mwclient.getserverConfigs("XPRewardCap"));
    }

    public void setNextTick(long nextTick) {
        this.nextTick = nextTick;
    }

    public void updateClock() {
        this.lblNextTick.setText("Next Tick: " + (this.nextTick - System.currentTimeMillis()) / 1000L + " s");
    }

    private static class TThread
    extends Thread {
        CPlayerPanel myPanel;

        public TThread(CPlayerPanel p) {
            this.myPanel = p;
        }

        public synchronized void run() {
            while (true) {
                this.myPanel.updateClock();
                try {
                    this.wait(1000L);
                    continue;
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                    continue;
                }
                break;
            }
        }
    }
}

