/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.CConfig;
import client.CUser;
import client.MWClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;

public class CUserListPanel
extends JPanel
implements ActionListener {
    public static int SORTMODE_NAME = 0;
    public static int SORTMODE_HOUSE = 1;
    public static int SORTMODE_EXP = 2;
    public static int SORTMODE_RATING = 3;
    public static int SORTMODE_STATUS = 4;
    public static int SORTMODE_USERLEVEL = 5;
    public static int SORTMODE_COUNTRY = 6;
    public static int SORTORDER_ASCENDING = 1;
    public static int SORTORDER_DESCENDING = 2;
    MWClient mwclient;
    CConfig Config;
    boolean LoggedIn = false;
    boolean Dedicateds;
    JScrollPane UserListSP;
    JList UserList;
    CUserListModel Users;
    JPanel countPanel = new JPanel();
    JLabel CountLabel = new JLabel();
    JButton ActivityButton = new JButton();
    UserListPopupListener UserListPopup = new UserListPopupListener();

    public CUserListPanel(MWClient client) {
        this.mwclient = client;
        this.Dedicateds = this.mwclient.getConfig().isParam("USERLISTDEDICATEDS");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(180, 480));
        this.setMinimumSize(new Dimension(120, 100));
        this.setMaximumSize(new Dimension(180, 2000));
        this.Users = new CUserListModel(this.mwclient);
        this.UserList = new JList(this.Users);
        this.UserList.setAlignmentX(0.0f);
        this.UserList.addMouseListener(this.UserListPopup);
        this.UserList.setCellRenderer(this.Users.getRenderer());
        this.UserListSP = new JScrollPane(this.UserList);
        this.UserListSP.setPreferredSize(new Dimension(180, 480));
        this.UserListSP.setMinimumSize(new Dimension(180, 100));
        this.UserListSP.setMaximumSize(new Dimension(180, 2000));
        this.UserListSP.setBorder(new LineBorder(Color.black));
        this.UserListSP.setViewportView(this.UserList);
        this.add((Component)this.UserListSP, "Center");
        this.CountLabel.setAlignmentX(0.5f);
        this.CountLabel.setAlignmentY(0.5f);
        this.CountLabel.setBorder(BorderFactory.createEmptyBorder(3, 2, 2, 2));
        this.CountLabel.setText("Player Count: " + this.UserList.getModel().getSize());
        if (this.mwclient.getConfig().isParam("USERLISTCOUNT")) {
            this.CountLabel.setVisible(true);
        } else {
            this.CountLabel.setVisible(false);
        }
        this.ActivityButton.setText("Waiting ...");
        this.ActivityButton.setEnabled(false);
        this.ActivityButton.setAlignmentX(0.5f);
        this.ActivityButton.setAlignmentY(0.5f);
        this.ActivityButton.addActionListener(this);
        if (this.mwclient.getConfig().isParam("USERLISTACTIVITYBTN")) {
            this.ActivityButton.setVisible(true);
        } else {
            this.ActivityButton.setVisible(false);
        }
        this.countPanel.setLayout(new BoxLayout(this.countPanel, 1));
        this.countPanel.add(this.ActivityButton);
        this.countPanel.add(this.CountLabel);
        this.countPanel.setBorder(BorderFactory.createEmptyBorder(4, 2, 3, 2));
        this.add((Component)this.countPanel, "South");
        String mode = this.mwclient.getConfig().getParam("SORTMODE");
        if (mode.equals("HOUSE")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_HOUSE);
        } else if (mode.equals("EXP")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_EXP);
        } else if (mode.equals("RATING")) {
            if (!Boolean.parseBoolean(this.mwclient.getserverConfigs("HideELO"))) {
                ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_RATING);
            } else {
                ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_NAME);
            }
        } else if (mode.equals("STATUS")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_STATUS);
        } else if (mode.equals("USERLEVEL")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_USERLEVEL);
        } else if (mode.equals("COUNTRY")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_COUNTRY);
        } else {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_NAME);
        }
        String order = this.mwclient.getConfig().getParam("SORTORDER");
        if (order.equals("DESCENDING")) {
            ((CUserListModel)this.UserList.getModel()).setSortOrder(SORTORDER_DESCENDING);
        } else {
            ((CUserListModel)this.UserList.getModel()).setSortOrder(SORTORDER_ASCENDING);
        }
    }

    public CUserListModel getUsers() {
        return this.Users;
    }

    public JList getUserList() {
        return this.UserList;
    }

    public synchronized void refresh() {
        try {
            ((CUserListModel)this.UserList.getModel()).refreshModel();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
        this.CountLabel.setText("Player Count: " + this.UserList.getModel().getSize());
    }

    public void setLoggedIn(boolean tloggedin) {
        this.LoggedIn = tloggedin;
        if (this.LoggedIn) {
            this.ActivityButton.setEnabled(true);
            this.ActivityButton.setText("Activate");
        } else {
            this.ActivityButton.setEnabled(true);
            this.ActivityButton.setText("Login");
        }
    }

    public void setActivateButtonText(String s) {
        this.ActivityButton.setText(s);
    }

    public void setActivityButtonEnabled(boolean b) {
        this.ActivityButton.setEnabled(b);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ActivityButton) {
            if (this.mwclient.getMyStatus() == 2) {
                this.mwclient.sendChat("/c activate");
            } else if (this.mwclient.getMyStatus() == 3) {
                this.mwclient.sendChat("/c deactivate");
            } else if (this.mwclient.getMyStatus() == 1) {
                this.mwclient.sendChat("/c login");
            }
        }
    }

    public static class CUserListModel
    extends AbstractListModel {
        SortedSet Users;
        UserListCellRenderer Renderer;
        MWClient mwclient;
        boolean Dedicateds;

        public CUserListModel(MWClient client) {
            this.mwclient = client;
            this.Dedicateds = this.mwclient.getConfig().isParam("USERLISTDEDICATEDS");
            this.Users = Collections.synchronizedSortedSet(new TreeSet(new UserComparator()));
            this.Renderer = new UserListCellRenderer(this);
        }

        public synchronized void clear() {
            this.Users.clear();
        }

        public void add(Object o) {
            this.Users.add(o);
        }

        public synchronized void remove(Object o) {
            this.Users.remove(o);
        }

        public synchronized void addAll(Collection c) {
            this.Users.addAll(c);
        }

        public synchronized int getSize() {
            return this.Users.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void refreshModel() {
            Collection<CUser> users;
            this.fireIntervalRemoved(this, 0, this.Users.size());
            this.clear();
            int myLevel = this.mwclient.getUser(this.mwclient.getPlayer().getName()).getUserlevel();
            Collection<CUser> collection = users = this.mwclient.getUsers();
            synchronized (collection) {
                for (CUser currU : users) {
                    if (currU.isInvis() && myLevel < currU.getUserlevel() || currU.getName().startsWith("[Dedicated]") && !this.Dedicateds) continue;
                    this.add(currU);
                }
            }
            this.fireIntervalAdded(this, 0, this.Users.size());
        }

        public void setDedicateds(boolean dedicateds) {
            this.Dedicateds = dedicateds;
        }

        public void setSortMode(int tsortmode) {
            ((UserComparator)this.Users.comparator()).setMode(tsortmode);
            this.refreshModel();
        }

        public int getSortMode() {
            return ((UserComparator)this.Users.comparator()).getMode();
        }

        public void setSortOrder(int tsortorder) {
            ((UserComparator)this.Users.comparator()).setOrder(tsortorder);
            this.refreshModel();
        }

        public int getSortOrder() {
            return ((UserComparator)this.Users.comparator()).getOrder();
        }

        public synchronized Object getElementAt(int index) {
            if (index < this.Users.size()) {
                return ((CUser)this.Users.toArray()[index]).getName();
            }
            return null;
        }

        public synchronized CUser getUser(int index) {
            if (index < this.Users.size()) {
                return (CUser)this.Users.toArray()[index];
            }
            return null;
        }

        public synchronized CUser getUser(String name) {
            for (CUser user : this.Users) {
                if (!user.getName().equals(name)) continue;
                return user;
            }
            return new CUser();
        }

        public UserListCellRenderer getRenderer() {
            return this.Renderer;
        }

        public class UserComparator
        implements Comparator {
            int Mode = SORTMODE_NAME;
            int Order = SORTORDER_ASCENDING;

            public int compare(Object o1, Object o2) {
                CUser user1 = null;
                CUser user2 = null;
                int result = 0;
                if (this.Order == SORTORDER_DESCENDING) {
                    user1 = (CUser)o2;
                    user2 = (CUser)o1;
                } else {
                    user1 = (CUser)o1;
                    user2 = (CUser)o2;
                }
                if (this.Mode == SORTMODE_NAME) {
                    return user1.getName().compareToIgnoreCase(user2.getName());
                }
                if (this.Mode == SORTMODE_HOUSE) {
                    result = user1.getHouse().compareToIgnoreCase(user2.getHouse());
                }
                if (this.Mode == SORTMODE_COUNTRY) {
                    result = user1.getCountry().compareToIgnoreCase(user2.getCountry());
                }
                if (this.Mode == SORTMODE_EXP) {
                    result = new Integer(user2.getExp()).compareTo(new Integer(user1.getExp()));
                }
                if (this.Mode == SORTMODE_RATING) {
                    result = new Float(user2.getRating()).compareTo(new Float(user1.getRating()));
                }
                if (this.Mode == SORTMODE_STATUS) {
                    result = new Integer(user2.getStatus()).compareTo(new Integer(user1.getStatus()));
                }
                if (this.Mode == SORTMODE_USERLEVEL) {
                    result = new Integer(user2.getUserlevel()).compareTo(new Integer(user1.getUserlevel()));
                }
                if (result == 0) {
                    if (this.Order == SORTORDER_DESCENDING) {
                        return user2.getName().compareToIgnoreCase(user1.getName());
                    }
                    return user1.getName().compareToIgnoreCase(user2.getName());
                }
                return result;
            }

            public boolean equals(Object o1, Object o2) {
                return ((CUser)o1).getName().equals(((CUser)o2).getName());
            }

            public void setMode(int tmode) {
                if (tmode == SORTMODE_NAME || tmode == SORTMODE_HOUSE || tmode == SORTMODE_EXP || tmode == SORTMODE_RATING || tmode == SORTMODE_STATUS || tmode == SORTMODE_USERLEVEL || tmode == SORTMODE_COUNTRY) {
                    this.Mode = tmode;
                }
            }

            public int getMode() {
                return this.Mode;
            }

            public void setOrder(int torder) {
                if (torder == SORTORDER_ASCENDING || torder == SORTORDER_DESCENDING) {
                    this.Order = torder;
                }
            }

            public int getOrder() {
                return this.Order;
            }
        }

        static class UserListCellRenderer
        extends JLabel
        implements ListCellRenderer {
            MWClient ulMwclient;
            CUserListModel Owner;
            boolean LoggedIn = false;
            boolean TextBold = true;
            boolean TextColor = true;
            boolean TextImage = true;
            ImageIcon LogoutImage;
            ImageIcon ReserveImage;
            ImageIcon ActiveImage;
            ImageIcon FightImage;

            public UserListCellRenderer(CUserListModel towner) {
                this.Owner = towner;
                this.ulMwclient = towner.mwclient;
                this.TextBold = this.ulMwclient.getConfig().isParam("USERLISTBOLD");
                this.TextColor = this.ulMwclient.getConfig().isParam("USERLISTCOLOR");
                this.TextImage = this.ulMwclient.getConfig().isParam("USERLISTIMAGE");
                this.LogoutImage = this.ulMwclient.getConfig().getImage("LOGOUT");
                this.ReserveImage = this.ulMwclient.getConfig().getImage("RESERVE");
                this.ActiveImage = this.ulMwclient.getConfig().getImage("ACTIVE");
                this.FightImage = this.ulMwclient.getConfig().getImage("FIGHT");
                this.setOpaque(true);
            }

            public void setLoggedIn(boolean tloggedin) {
                this.LoggedIn = tloggedin;
            }

            public void refreshParams() {
                this.TextBold = this.ulMwclient.getConfig().isParam("USERLISTBOLD");
                this.TextColor = this.ulMwclient.getConfig().isParam("USERLISTCOLOR");
                this.TextImage = this.ulMwclient.getConfig().isParam("USERLISTIMAGE");
                this.LogoutImage = this.ulMwclient.getConfig().getImage("LOGOUT");
                this.ReserveImage = this.ulMwclient.getConfig().getImage("RESERVE");
                this.ActiveImage = this.ulMwclient.getConfig().getImage("ACTIVE");
                this.FightImage = this.ulMwclient.getConfig().getImage("FIGHT");
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
                int userlevel = 0;
                CUser user = this.Owner.getUser(index);
                if (user == null) {
                    return null;
                }
                userlevel = user.getUserlevel();
                String invisFlag = " ";
                if (user.isInvis()) {
                    invisFlag = "(I) ";
                }
                if (userlevel < 30) {
                    this.setText(user.getName());
                }
                if (userlevel >= 30 && userlevel < 100) {
                    this.setText("^" + invisFlag + user.getName());
                }
                if (userlevel >= 100 && userlevel < 200) {
                    this.setText("*" + invisFlag + user.getName());
                }
                if (userlevel >= 200) {
                    this.setText("@" + invisFlag + user.getName());
                }
                boolean isOnNoPlay = false;
                if (this.ulMwclient.getPlayer().getAdminExcludes().contains(user.getName().toLowerCase())) {
                    isOnNoPlay = true;
                } else if (this.ulMwclient.getPlayer().getPlayerExcludes().contains(user.getName().toLowerCase())) {
                    isOnNoPlay = true;
                }
                String searchString = user.getName().trim();
                int isMuted = 0;
                if (userlevel < 100) {
                    String currString;
                    String ignoreList = this.ulMwclient.getConfig().getParam("IGNOREPUBLIC");
                    StringTokenizer it = new StringTokenizer(ignoreList, ",");
                    while (it.hasMoreTokens()) {
                        currString = it.nextToken().trim();
                        if (!currString.equalsIgnoreCase(searchString)) continue;
                        ++isMuted;
                    }
                    ignoreList = this.ulMwclient.getConfig().getParam("IGNOREPRIVATE");
                    it = new StringTokenizer(ignoreList, ",");
                    while (it.hasMoreTokens()) {
                        currString = it.nextToken().trim();
                        if (!currString.equalsIgnoreCase(searchString)) continue;
                        ++isMuted;
                    }
                    if (user.getHouse().equals(this.ulMwclient.getPlayer().getHouse())) {
                        ignoreList = this.ulMwclient.getConfig().getParam("IGNOREHOUSE");
                        it = new StringTokenizer(ignoreList, ",");
                        while (it.hasMoreTokens()) {
                            currString = it.nextToken();
                            if (!currString.equalsIgnoreCase(searchString)) continue;
                            ++isMuted;
                        }
                    }
                }
                String muteUps = "";
                for (int i = 1; i < isMuted; ++i) {
                    muteUps = muteUps + "+";
                }
                if (isMuted > 0 && isOnNoPlay) {
                    this.setText(this.getText() + " [muted" + muteUps + ", np]");
                } else if (isMuted > 0) {
                    this.setText(this.getText() + " [muted" + muteUps + "]");
                } else if (isOnNoPlay) {
                    this.setText(this.getText() + " [np]");
                }
                if (selected) {
                    this.setForeground(list.getSelectionForeground());
                    this.setBackground(list.getSelectionBackground());
                } else {
                    this.setBackground(list.getBackground());
                    if (this.TextColor && this.LoggedIn) {
                        this.setForeground(user.getRGBColor());
                    } else {
                        this.setForeground(Color.black);
                    }
                }
                if (this.LoggedIn) {
                    int status = user.getStatus();
                    if (status == 1) {
                        this.setFont(this.getFont().deriveFont(0));
                        if (this.TextImage) {
                            try {
                                this.setIcon(this.LogoutImage);
                            }
                            catch (Exception ex) {
                                MWClient.mwClientLog.clientErrLog(ex);
                            }
                        }
                    } else {
                        if (this.TextBold) {
                            this.setFont(this.getFont().deriveFont(1));
                        } else {
                            this.setFont(this.getFont().deriveFont(0));
                        }
                        if (this.TextImage) {
                            if (status == 2) {
                                try {
                                    this.setIcon(this.ReserveImage);
                                }
                                catch (Exception ex) {
                                    MWClient.mwClientLog.clientErrLog(ex);
                                }
                            }
                            if (status == 3) {
                                try {
                                    this.setIcon(this.ActiveImage);
                                }
                                catch (Exception ex) {
                                    MWClient.mwClientLog.clientErrLog(ex);
                                }
                            }
                            if (status == 4) {
                                try {
                                    this.setIcon(this.FightImage);
                                }
                                catch (Exception ex) {
                                    MWClient.mwClientLog.clientErrLog(ex);
                                }
                            }
                        } else {
                            this.setIcon(null);
                        }
                    }
                    this.setIconTextGap(7);
                    this.setToolTipText(user.getInfo(this.ulMwclient.getConfig().isParam("NOIMGINCHAT")));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                    this.setIcon(null);
                    this.setToolTipText(user.getShortInfo());
                }
                return this;
            }
        }
    }

    class UserListPopupListener
    extends MouseAdapter
    implements ActionListener {
        UserListPopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            int row;
            if (e.getClickCount() == 2 && (row = CUserListPanel.this.UserList.locationToIndex(e.getPoint())) > -1 && row < CUserListPanel.this.UserList.getModel().getSize()) {
                CUser user = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row);
                String input = "/mail " + user.getName() + ", ";
                input = input + CUserListPanel.this.mwclient.getMainFrame().getMainPanel().getCommPanel().getInput();
                CUserListPanel.this.mwclient.getMainFrame().getMainPanel().getCommPanel().setInput(input);
                CUserListPanel.this.mwclient.getMainFrame().getMainPanel().getCommPanel().focusInputField();
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            int row = -1;
            String userName = "";
            JPopupMenu popup = new JPopupMenu();
            if (e.isPopupTrigger() && (row = CUserListPanel.this.UserList.locationToIndex(e.getPoint())) > -1 && row < CUserListPanel.this.UserList.getModel().getSize()) {
                JMenuItem item;
                CUser user = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row);
                userName = user.getName();
                if (!userName.equalsIgnoreCase(CUserListPanel.this.mwclient.getPlayer().getName())) {
                    String currString;
                    item = new JMenuItem("<HTML>Mail " + userName + "</b></HTML>");
                    item.setActionCommand("MA|" + userName);
                    item.addActionListener(this);
                    popup.add(item);
                    if (CUserListPanel.this.LoggedIn && user.getStatus() != 1) {
                        JMenu sendMen = new JMenu("Send");
                        item = new JMenuItem("Send " + CUserListPanel.this.mwclient.moneyOrFluMessage(true, false, -2));
                        item.setActionCommand("MO|" + userName);
                        item.addActionListener(this);
                        sendMen.add(item);
                        item = new JMenuItem("Send Unit");
                        item.setActionCommand("TU|" + userName);
                        item.addActionListener(this);
                        sendMen.add(item);
                        if (Boolean.parseBoolean(CUserListPanel.this.mwclient.getserverConfigs("AllowPersonalPilotQueues"))) {
                            item = new JMenuItem("Send Pilot");
                            item.setActionCommand("TP|" + userName);
                            item.addActionListener(this);
                            sendMen.add(item);
                        }
                        if (Boolean.parseBoolean(CUserListPanel.this.mwclient.getserverConfigs("UseDirectSell"))) {
                            item = new JMenuItem("Direct Sell Unit");
                            item.setActionCommand("DSU|" + userName);
                            item.addActionListener(this);
                            sendMen.add(item);
                        }
                        popup.add(sendMen);
                    }
                    JMenu blockMen = new JMenu("Block");
                    String searchString = userName;
                    boolean matched = false;
                    String ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNOREPUBLIC");
                    StringTokenizer st = new StringTokenizer(ignoreList, ",");
                    while (st.hasMoreTokens() && !matched) {
                        currString = st.nextToken().trim();
                        if (!currString.equalsIgnoreCase(searchString)) continue;
                        matched = true;
                    }
                    if (!matched) {
                        item = new JMenuItem("Mute (Main)");
                        item.setActionCommand("MU|" + userName + "|PUBLIC");
                        item.addActionListener(this);
                        blockMen.add(item);
                    } else {
                        item = new JMenuItem("Unmute (Main)");
                        item.setActionCommand("UMU|" + userName + "|PUBLIC");
                        item.addActionListener(this);
                        blockMen.add(item);
                    }
                    ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNOREPRIVATE");
                    st = new StringTokenizer(ignoreList, ",");
                    matched = false;
                    while (st.hasMoreTokens() && !matched) {
                        currString = st.nextToken().trim();
                        if (!currString.equalsIgnoreCase(searchString)) continue;
                        matched = true;
                    }
                    if (!matched) {
                        item = new JMenuItem("Mute (Private)");
                        item.setActionCommand("MU|" + userName + "|PRIVATE");
                        item.addActionListener(this);
                        blockMen.add(item);
                    } else {
                        item = new JMenuItem("Unmute (Private)");
                        item.setActionCommand("UMU|" + userName + "|PRIVATE");
                        item.addActionListener(this);
                        blockMen.add(item);
                    }
                    if (user.getHouse().equals(CUserListPanel.this.mwclient.getPlayer().getHouse())) {
                        ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNOREHOUSE");
                        st = new StringTokenizer(ignoreList, ",");
                        matched = false;
                        while (st.hasMoreTokens() && !matched) {
                            currString = st.nextToken().trim();
                            if (!currString.equalsIgnoreCase(searchString)) continue;
                            matched = true;
                        }
                        if (!matched) {
                            item = new JMenuItem("Mute (House)");
                            item.setActionCommand("MU|" + userName + "|HOUSE");
                            item.addActionListener(this);
                            blockMen.add(item);
                        } else {
                            item = new JMenuItem("Unmute (House)");
                            item.setActionCommand("UMU|" + userName + "|HOUSE");
                            item.addActionListener(this);
                            blockMen.add(item);
                        }
                    }
                    if (Integer.parseInt(CUserListPanel.this.mwclient.getserverConfigs("NoPlayListSize")) >= 1) {
                        if (CUserListPanel.this.LoggedIn && user.getStatus() != 1) {
                            boolean isOnNoPlay = false;
                            if (CUserListPanel.this.mwclient.getPlayer().getAdminExcludes().contains(userName.toLowerCase())) {
                                isOnNoPlay = true;
                            } else if (CUserListPanel.this.mwclient.getPlayer().getPlayerExcludes().contains(userName.toLowerCase())) {
                                isOnNoPlay = true;
                            }
                            if (isOnNoPlay) {
                                item = new JMenuItem("Remove from No-Play");
                                item.setActionCommand("RNP|" + userName);
                                item.addActionListener(this);
                                blockMen.add(item);
                            } else {
                                item = new JMenuItem("Add to No-Play");
                                item.setActionCommand("ANP|" + userName);
                                item.addActionListener(this);
                                blockMen.add(item);
                            }
                        } else {
                            item = new JMenuItem("No-Play");
                            item.setEnabled(false);
                            blockMen.add(item);
                        }
                        popup.addSeparator();
                    }
                    popup.add(blockMen);
                }
                if (CUserListPanel.this.mwclient.isMod()) {
                    Object o;
                    URLClassLoader loader;
                    File loadJar;
                    try {
                        loadJar = new File("./MekWarsAdmin.jar");
                        if (!loadJar.exists()) {
                            MWClient.mwClientLog.clientErrLog("ModeratorUserlistPopupMenu creation skipped. No MekWarsAdmin.jar present.");
                        } else {
                            loader = new URLClassLoader(new URL[]{loadJar.toURL()});
                            Class<?> c = loader.loadClass("admin.ModeratorUserlistPopupMenu");
                            o = c.newInstance();
                            c.getDeclaredMethod("createMenu", MWClient.class, CUser.class).invoke(o, CUserListPanel.this.mwclient, user);
                            popup.add((JMenu)o);
                        }
                    }
                    catch (Exception ex) {
                        MWClient.mwClientLog.clientErrLog("ModeratorUserlistPopupMenu creation FAILED!");
                        MWClient.mwClientLog.clientErrLog(ex);
                    }
                    try {
                        loadJar = new File("./MekWarsAdmin.jar");
                        if (!loadJar.exists()) {
                            MWClient.mwClientLog.clientErrLog("AdminUserlistPopupMenu creation skipped. No MekWarsAdmin.jar present.");
                        } else {
                            loader = new URLClassLoader(new URL[]{loadJar.toURL()});
                            Class<?> c = loader.loadClass("admin.AdminUserlistPopupMenu");
                            o = c.newInstance();
                            c.getDeclaredMethod("createMenu", MWClient.class, CUser.class).invoke(o, CUserListPanel.this.mwclient, user);
                            if (((JMenu)o).getItemCount() > 0) {
                                popup.add((JMenu)o);
                            }
                        }
                    }
                    catch (Exception ex) {
                        MWClient.mwClientLog.clientErrLog("AdminUserlistPopupMenu creation FAILED!");
                        MWClient.mwClientLog.clientErrLog(ex);
                    }
                    popup.addSeparator();
                }
                if (((CUserListModel)CUserListPanel.this.UserList.getModel()).getSortOrder() == SORTORDER_DESCENDING) {
                    item = new JMenuItem("Ascending Order");
                    item.setActionCommand("SO|A");
                    item.addActionListener(this);
                    popup.add(item);
                } else {
                    item = new JMenuItem("Descending Order");
                    item.setActionCommand("SO|D");
                    item.addActionListener(this);
                    popup.add(item);
                }
                JMenu sortSub = new JMenu("Sort By");
                popup.add(sortSub);
                item = new JMenuItem("Name");
                item.setActionCommand("SM|N");
                item.addActionListener(this);
                sortSub.add(item);
                if (CUserListPanel.this.LoggedIn) {
                    item = new JMenuItem("Faction");
                    item.setActionCommand("SM|H");
                    item.addActionListener(this);
                    sortSub.add(item);
                    item = new JMenuItem("Experience");
                    item.setActionCommand("SM|E");
                    item.addActionListener(this);
                    sortSub.add(item);
                    if (!Boolean.parseBoolean(CUserListPanel.this.mwclient.getserverConfigs("HideELO"))) {
                        item = new JMenuItem("Rating");
                        item.setActionCommand("SM|R");
                        item.addActionListener(this);
                        sortSub.add(item);
                    }
                    item = new JMenuItem("Status");
                    item.setActionCommand("SM|S");
                    item.addActionListener(this);
                    sortSub.add(item);
                }
                item = new JMenuItem("Userlevel");
                item.setActionCommand("SM|L");
                item.addActionListener(this);
                sortSub.add(item);
                item = new JMenuItem("Country");
                item.setActionCommand("SM|C");
                item.addActionListener(this);
                sortSub.add(item);
                popup.addSeparator();
                JMenu settingSub = new JMenu("List Settings");
                popup.add(settingSub);
                item = new JCheckBoxMenuItem("Activity Button");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTACTIVITYBTN")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULA|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Bold Names");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTBOLD")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULB|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Colored Names");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTCOLOR")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULC|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Dedicated Hosts");
                if (CUserListPanel.this.Dedicateds) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("TD");
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Player Count");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTCOUNT")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULN|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Status Images");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTIMAGE")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULI|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StringTokenizer it;
            String newList;
            String ignoreList;
            String searchString;
            String mode;
            String s = actionEvent.getActionCommand();
            StringTokenizer st = new StringTokenizer(s, "|");
            String command = st.nextToken();
            String userName = "";
            if (command.equals("MA") && st.hasMoreElements()) {
                userName = st.nextToken();
                CUserListPanel.this.mwclient.getMainFrame().jMenuFileMail_actionPerformed(userName);
                return;
            }
            if (command.equals("MO") && st.hasMoreElements()) {
                userName = st.nextToken();
                CUserListPanel.this.mwclient.getMainFrame().jMenuCommanderTransferMoney_actionPerformed(userName);
                return;
            }
            if (command.equals("TU") && st.hasMoreElements()) {
                userName = st.nextToken();
                CUserListPanel.this.mwclient.getMainFrame().jMenuCommanderTransferUnit_actionPerformed(userName, -1);
                return;
            }
            if (command.equals("TP") && st.hasMoreElements()) {
                userName = st.nextToken();
                CUserListPanel.this.mwclient.getMainFrame().jMenuCommanderTransferPilot_actionPerformed(userName);
                return;
            }
            if (command.equals("DSU") && st.hasMoreElements()) {
                userName = st.nextToken();
                CUserListPanel.this.mwclient.getMainFrame().jMenuCommanderDirectSell_actionPerformed(userName, null);
                return;
            }
            if (command.equals("MU") && st.hasMoreElements()) {
                userName = st.nextToken();
                mode = st.nextToken();
                searchString = userName;
                ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNORE" + mode);
                newList = "";
                it = new StringTokenizer(ignoreList, ",");
                boolean matched = false;
                while (it.hasMoreTokens() && !matched) {
                    String currString = it.nextToken();
                    newList = newList + currString + ",";
                    if (!currString.equals(searchString)) continue;
                    matched = true;
                }
                if (!matched) {
                    newList = newList + searchString + ",";
                }
                CUserListPanel.this.mwclient.getConfig().setParam("IGNORE" + mode, newList);
                CUserListPanel.this.mwclient.setIgnorePublic();
                CUserListPanel.this.mwclient.setIgnoreHouse();
                CUserListPanel.this.mwclient.setIgnorePrivate();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
                String toUser = "CH|CLIENT: You muted " + searchString + " (" + mode + ").";
                CUserListPanel.this.mwclient.doParseDataInput(toUser);
                CUserListPanel.this.UserList.repaint();
            }
            if (command.equals("UMU") && st.hasMoreElements()) {
                userName = st.nextToken();
                mode = st.nextToken();
                searchString = userName;
                ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNORE" + mode);
                newList = "";
                it = new StringTokenizer(ignoreList, ",");
                while (it.hasMoreTokens()) {
                    String currString = it.nextToken();
                    if (currString.equals(searchString)) continue;
                    newList = newList + currString + ",";
                }
                CUserListPanel.this.mwclient.getConfig().setParam("IGNORE" + mode, newList);
                CUserListPanel.this.mwclient.setIgnorePublic();
                CUserListPanel.this.mwclient.setIgnoreHouse();
                CUserListPanel.this.mwclient.setIgnorePrivate();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
                String toUser = "CH|CLIENT: You unmuted " + searchString + " (" + mode + ").";
                CUserListPanel.this.mwclient.doParseDataInput(toUser);
                CUserListPanel.this.UserList.repaint();
            }
            if (command.equals("RNP") && st.hasMoreElements()) {
                userName = st.nextToken();
                CUserListPanel.this.mwclient.sendChat("/c noplay#remove#" + userName);
            }
            if (command.equals("ANP") && st.hasMoreElements()) {
                userName = st.nextToken();
                CUserListPanel.this.mwclient.sendChat("/c noplay#add#" + userName);
            }
            if (command.equals("SM") && st.hasMoreElements()) {
                command = st.nextToken();
                if (command.equals("N")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_NAME);
                } else if (command.equals("H")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_HOUSE);
                } else if (command.equals("E")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_EXP);
                } else if (command.equals("R")) {
                    if (!Boolean.parseBoolean(CUserListPanel.this.mwclient.getserverConfigs("HideELO"))) {
                        ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_RATING);
                    } else {
                        ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_NAME);
                    }
                } else if (command.equals("S")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_STATUS);
                } else if (command.equals("L")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_USERLEVEL);
                } else if (command.equals("C")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_COUNTRY);
                }
                if (command.equals("H")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "HOUSE");
                } else if (command.equals("E")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "EXP");
                } else if (command.equals("R")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "RATING");
                } else if (command.equals("S")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "STATUS");
                } else if (command.equals("L")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "USERLEVEL");
                } else if (command.equals("C")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "COUNTRY");
                } else {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "NAME");
                }
                CUserListPanel.this.mwclient.getConfig().saveConfig();
                return;
            }
            if (command.equals("SO") && st.hasMoreElements()) {
                command = st.nextToken();
                if (command.equals("A")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortOrder(SORTORDER_ASCENDING);
                }
                if (command.equals("D")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortOrder(SORTORDER_DESCENDING);
                }
                if (command.equals("D")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTORDER", "DESCENDING");
                } else {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTORDER", "ASCENDING");
                }
                CUserListPanel.this.mwclient.getConfig().saveConfig();
                return;
            }
            if (command.equals("TD")) {
                boolean bl = CUserListPanel.this.Dedicateds = !CUserListPanel.this.Dedicateds;
                if (CUserListPanel.this.Dedicateds) {
                    CUserListPanel.this.mwclient.getConfig().setParam("USERLISTDEDICATEDS", "YES");
                } else {
                    CUserListPanel.this.mwclient.getConfig().setParam("USERLISTDEDICATEDS", "NO");
                }
                ((CUserListModel)CUserListPanel.this.UserList.getModel()).setDedicateds(CUserListPanel.this.Dedicateds);
                CUserListPanel.this.refresh();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULC") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTCOLOR", command);
                CUserListPanel.this.Users.getRenderer().refreshParams();
                CUserListPanel.this.UserList.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULI") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTIMAGE", command);
                CUserListPanel.this.Users.getRenderer().refreshParams();
                CUserListPanel.this.UserList.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULB") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTBOLD", command);
                CUserListPanel.this.Users.getRenderer().refreshParams();
                CUserListPanel.this.UserList.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULN") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTCOUNT", command);
                CUserListPanel.this.CountLabel.setVisible(Boolean.parseBoolean(command));
                CUserListPanel.this.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULA") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTACTIVITYBTN", command);
                CUserListPanel.this.ActivityButton.setVisible(Boolean.parseBoolean(command));
                CUserListPanel.this.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            }
        }
    }
}

