/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.gui.TableMap;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class TableSorter
extends TableMap {
    public static final int SORTER_BM = 0;
    public static final int SORTER_BUILDTABLES = 1;
    public static final int SORTER_BATTLES = 2;
    public static final int SORTER_BMPARTS = 3;
    int[] indexes;
    Vector<Integer> sortingColumns = new Vector();
    boolean ascending = true;
    int compares;
    int sortMode;
    int currentColumn = -2;
    boolean currentOrder = true;
    MWClient mwclient = null;

    public TableSorter(TableModel model, MWClient mwclient, int mode) {
        this.setModel(model);
        this.mwclient = mwclient;
        this.sortMode = mode;
        this.loadSavedSortPreferences(mode);
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Class<?> type = this.model.getColumnClass(column);
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s2;
            String s1 = (String)data.getValueAt(row1, column);
            int result = s1.compareTo(s2 = (String)data.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        int result = 0;
        try {
            Comparable v1 = (Comparable)data.getValueAt(row1, column);
            Comparable v2 = (Comparable)data.getValueAt(row2, column);
            result = v1.compareTo(v2);
        }
        catch (Exception ex) {
            Object v1 = data.getValueAt(row1, column);
            String s1 = v1.toString();
            Object v2 = data.getValueAt(row2, column);
            String s2 = v2.toString();
            result = s1.compareTo(s2);
        }
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            int column = this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        super.tableChanged(e);
        this.restorePreviousSort();
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            MWClient.mwClientLog.clientErrLog("Sorter not informed of a change in model.");
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public Object getValueAt(int aRow, int aColumn) {
        if (aRow < 0 || aRow >= this.indexes.length) {
            return null;
        }
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(column);
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void restorePreviousSort() {
        if (this.currentColumn != -2) {
            this.sortByColumn(this.currentColumn, this.currentOrder);
        }
    }

    public void loadSavedSortPreferences(int mode) {
        if (mode == 0) {
            this.currentColumn = Integer.parseInt(this.mwclient.getConfigParam("BMSORTCOLUMN"));
            this.currentOrder = Boolean.parseBoolean(this.mwclient.getConfigParam("BMSORTORDER"));
        } else if (mode == 1) {
            this.currentColumn = Integer.parseInt(this.mwclient.getConfigParam("TABLEBROWSERSORTCOLUMN"));
            this.currentOrder = Boolean.parseBoolean(this.mwclient.getConfigParam("TABLEBROWSERSORTORDER"));
        } else if (this.sortMode == 2) {
            this.currentColumn = Integer.parseInt(this.mwclient.getConfigParam("BATTLESSORTCOLUMN"));
            this.currentOrder = Boolean.parseBoolean(this.mwclient.getConfigParam("BATTLESSORTORDER"));
        } else if (mode == 3) {
            this.currentColumn = Integer.parseInt(this.mwclient.getConfigParam("BMESORTCOLUMN"));
            this.currentOrder = Boolean.parseBoolean(this.mwclient.getConfigParam("BMESORTORDER"));
        }
    }

    public void saveSortPreferences() {
        if (this.sortMode == 0) {
            this.mwclient.getConfig().setParam("BMSORTCOLUMN", Integer.toString(this.currentColumn));
            this.mwclient.getConfig().setParam("BMSORTORDER", Boolean.toString(this.currentOrder));
        } else if (this.sortMode == 1) {
            this.mwclient.getConfig().setParam("TABLEBROWSERSORTCOLUMN", Integer.toString(this.currentColumn));
            this.mwclient.getConfig().setParam("TABLEBROWSERSORTORDER", Boolean.toString(this.currentOrder));
        } else if (this.sortMode == 2) {
            this.mwclient.getConfig().setParam("BATTLESSORTCOLUMN", Integer.toString(this.currentColumn));
            this.mwclient.getConfig().setParam("BATTLESSORTORDER", Boolean.toString(this.currentOrder));
        } else if (this.sortMode == 3) {
            this.mwclient.getConfig().setParam("BMESORTCOLUMN", Integer.toString(this.currentColumn));
            this.mwclient.getConfig().setParam("BMESORTORDER", Boolean.toString(this.currentOrder));
        }
        this.mwclient.getConfig().saveConfig();
        this.mwclient.setConfig();
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final TableSorter sorter = this;
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                int column = tableView.getColumnModel().getColumnIndexAtX(e.getX());
                if (column == -1) {
                    return;
                }
                if (column == TableSorter.this.currentColumn) {
                    if (TableSorter.this.currentOrder) {
                        sorter.sortByColumn(column, false);
                        tableView.repaint();
                        TableSorter.this.currentOrder = false;
                    } else {
                        sorter.sortByColumn(column, true);
                        tableView.repaint();
                        TableSorter.this.currentOrder = true;
                    }
                    sorter.saveSortPreferences();
                } else {
                    if (TableSorter.this.sortMode == 1 && column == 3) {
                        sorter.sortByColumn(column, false);
                        TableSorter.this.currentOrder = false;
                    } else {
                        sorter.sortByColumn(column, true);
                        TableSorter.this.currentOrder = true;
                    }
                    tableView.repaint();
                    TableSorter.this.currentColumn = column;
                    sorter.saveSortPreferences();
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }
}

