/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import common.House;
import common.Planet;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class PlanetNameDialog
extends JDialog
implements ActionListener {
    private final TreeSet planetNames;
    private final Collection planets;
    private JList matchingPlanetsList;
    private JScrollPane scrollPane;
    private JTextField nameField;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private String planetName = null;

    public PlanetNameDialog(MWClient mwclient, String boxText, String[] opProps) {
        super(mwclient.getMainFrame(), boxText, true);
        this.planets = mwclient.getData().getAllPlanets();
        this.planetNames = new TreeSet();
        if (opProps == null) {
            Iterator it = this.planets.iterator();
            while (it.hasNext()) {
                this.planetNames.add(((Planet)it.next()).getName());
            }
        } else {
            for (Planet tp : this.planets) {
                StringTokenizer st;
                double range = Double.parseDouble(opProps[0]);
                String facInfo = opProps[3];
                String homeInfo = opProps[4];
                int launchOn = Integer.parseInt(opProps[5]);
                int launchFrom = Integer.parseInt(opProps[6]);
                int minOwn = Integer.parseInt(opProps[7]);
                int maxOwn = Integer.parseInt(opProps[8]);
                String legalDefenders = opProps[9];
                String allowPlanetFlags = opProps[10];
                String disallowPlanetFlags = opProps[11];
                if (!legalDefenders.equals("allFactions")) {
                    TreeMap legalDefTree = new TreeMap();
                    StringTokenizer legalDefTokenizer = new StringTokenizer(legalDefenders, "$");
                    while (legalDefTokenizer.hasMoreTokens()) {
                        legalDefTree.put(legalDefTokenizer.nextToken(), null);
                    }
                    Iterator<House> houseIt = tp.getInfluence().getHouses().iterator();
                    boolean foundDefender = false;
                    while (houseIt.hasNext() && !foundDefender) {
                        House currH = houseIt.next();
                        if (!legalDefTree.containsKey(currH.getName())) continue;
                        foundDefender = true;
                    }
                    if (!foundDefender) continue;
                }
                if (facInfo.equals("none") && tp.getFactoryCount() > 0 || facInfo.equals("only") && tp.getFactoryCount() < 1 || tp.isHomeWorld() && homeInfo.equals("none") || !tp.isHomeWorld() && homeInfo.equals("only")) continue;
                int houseID = mwclient.getPlayer().getMyHouse().getId();
                if (tp.getInfluence().getInfluence(houseID) < minOwn || tp.getInfluence().getInfluence(houseID) > maxOwn) continue;
                if (tp.getInfluence().getInfluence(houseID) >= launchOn) {
                    this.planetNames.add(tp.getName());
                    continue;
                }
                if (allowPlanetFlags.length() > 0) {
                    st = new StringTokenizer(allowPlanetFlags, "^");
                    while (st.hasMoreTokens()) {
                        if (tp.getPlanetFlags().containsKey(st.nextToken())) continue;
                    }
                }
                if (disallowPlanetFlags.length() > 0) {
                    st = new StringTokenizer(disallowPlanetFlags, "^");
                    while (st.hasMoreTokens()) {
                        if (!tp.getPlanetFlags().containsKey(st.nextToken())) continue;
                    }
                }
                Iterator i2 = this.planets.iterator();
                boolean launchFound = false;
                while (i2.hasNext() && !launchFound) {
                    double tdist;
                    Planet lp = (Planet)i2.next();
                    if (lp.getInfluence().getInfluence(houseID) < launchFrom || !((tdist = lp.getPosition().distanceSq(tp.getPosition())) <= range)) continue;
                    launchFound = true;
                    this.planetNames.add(tp.getName());
                }
            }
        }
        final Object[] allPlanetNames = this.planetNames.toArray();
        this.matchingPlanetsList = new JList<Object>(allPlanetNames);
        this.matchingPlanetsList.setVisibleRowCount(20);
        this.matchingPlanetsList.setSelectionMode(0);
        this.nameField = new JTextField();
        this.nameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                new Thread(){

                    public void run() {
                        String text = PlanetNameDialog.this.nameField.getText();
                        if (text == null || text.equals("")) {
                            PlanetNameDialog.this.matchingPlanetsList.setListData(allPlanetNames);
                            return;
                        }
                        ArrayList<String> possiblePlanets = new ArrayList<String>();
                        text = text.toLowerCase();
                        for (String curPlanet : PlanetNameDialog.this.planetNames) {
                            if (curPlanet.toLowerCase().indexOf(text) == -1) continue;
                            possiblePlanets.add(curPlanet);
                        }
                        PlanetNameDialog.this.matchingPlanetsList.setListData(possiblePlanets.toArray());
                        boolean shouldContinue = true;
                        int element = 0;
                        Iterator it = possiblePlanets.iterator();
                        while (it.hasNext() && shouldContinue) {
                            String name = (String)it.next();
                            if (name.toLowerCase().startsWith(text)) {
                                PlanetNameDialog.this.matchingPlanetsList.setSelectedIndex(element);
                                shouldContinue = false;
                            }
                            ++element;
                        }
                        if (shouldContinue) {
                            PlanetNameDialog.this.matchingPlanetsList.setSelectedIndex(0);
                        }
                    }
                }.start();
            }
        });
        this.scrollPane = new JScrollPane(this.matchingPlanetsList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.nameField);
        springPanel.add(this.scrollPane);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(springPanel);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            String selectedPlanet = (String)this.matchingPlanetsList.getSelectedValue();
            if (selectedPlanet == null) {
                selectedPlanet = this.nameField.getText();
            }
            if (selectedPlanet == null || selectedPlanet.equals("")) {
                return;
            }
            if (this.matchingPlanetsList.getModel().getSize() == 1) {
                selectedPlanet = (String)this.matchingPlanetsList.getModel().getElementAt(0);
            }
            for (Planet planet : this.planets) {
                if (!selectedPlanet.equals(planet.getName())) continue;
                this.setPlanetName(planet.getName());
                this.setVisible(false);
                return;
            }
            this.setPlanetName(null);
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 300.0) {
            width = 300;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 300.0) {
            height = 300;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }

    private void setPlanetName(String name) {
        this.planetName = name;
    }

    public String getPlanetName() {
        return this.planetName;
    }
}

